/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import com.esri.arcgis.system.AoInitialize;
import com.esri.arcgis.system.EngineInitializer;
import com.esri.arcgis.system.esriLicenseProductCode;
import com.esri.arcgis.system.esriLicenseStatus;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ArcObjectsInitializer {
    private static final Log log = LogFactory.getLog(ArcObjectsInitializer.class);
    private static AoInitialize aoInit = null;

    private static int[] getProductCodeIntegers(String[] productCodes) {
        Class<esriLicenseProductCode> clazz = esriLicenseProductCode.class;
        ArrayList<Integer> codes = new ArrayList<Integer>();
        for (String c : productCodes) {
            try {
                Field f = clazz.getDeclaredField("esriLicenseProductCode" + c);
                codes.add(f.getInt(null));
            }
            catch (Exception e) {
                log.warn((Object)("Invalid product code: " + c));
            }
        }
        int[] c = new int[codes.size()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = (Integer)codes.get(i);
        }
        return c;
    }

    public static void initializeLicenseWithStringCodes(String[] productCodes) throws Exception {
        int[] codes = ArcObjectsInitializer.getProductCodeIntegers((String[])productCodes);
        ArcObjectsInitializer.initializeLicense((int[])codes);
    }

    public static void initializeEditOrViewLicense() throws Exception {
        ArcObjectsInitializer.initializeLicense((int[])new int[]{60, 50, 30, 40, 20, 10});
    }

    public static void initializeEditLicense() throws Exception {
        ArcObjectsInitializer.initializeLicense((int[])new int[]{60, 50, 30});
    }

    public static void initializeViewLicense() throws Exception {
        ArcObjectsInitializer.initializeLicense((int[])new int[]{40, 20, 10});
    }

    public static void initializeLicense(int[] productCodes) throws Exception {
        EngineInitializer.initializeEngine();
        aoInit = new AoInitialize();
        for (int code : productCodes) {
            String codeString = ArcObjectsInitializer.findStaticFieldByValue(esriLicenseProductCode.class, (Object)code);
            log.info((Object)("Checking for product code availability for " + codeString));
            int status = aoInit.isProductCodeAvailable(code);
            log.info((Object)("Status: " + ArcObjectsInitializer.findStaticFieldByValue(esriLicenseStatus.class, (Object)status)));
            if (status != 10) continue;
            status = aoInit.initialize(code);
            log.info((Object)("Initialize result: " + ArcObjectsInitializer.findStaticFieldByValue(esriLicenseStatus.class, (Object)status)));
            return;
        }
        throw new Exception("No suitable ArcObjects license found");
    }

    public static void shutdown() throws Exception {
        if (aoInit != null) {
            aoInit.shutdown();
        }
    }

    private static String findStaticFieldByValue(Class clazz, Object value) {
        try {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].get(null).equals(value)) continue;
                return fields[i].getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value.toString();
    }
}

