/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import nl.b3p.catalog.arcgis.ArcObjectsInitializer;
import nl.b3p.catalog.arcgis.ArcObjectsLinker;
import nl.b3p.catalog.config.ArcObjectsConfig;
import nl.b3p.catalog.config.CatalogAppConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArcObjectsInitializerListener
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(ArcObjectsInitializerListener.class);
    private boolean initialized;

    public void contextInitialized(ServletContextEvent sce) {
        CatalogAppConfig cfg = CatalogAppConfig.getConfig();
        if (cfg != null && !cfg.getArcObjectsConfig().isEnabled()) {
            log.info((Object)"ArcObjects is not enabled by config");
            return;
        }
        ArcObjectsConfig aoCfg = cfg.getArcObjectsConfig();
        try {
            log.info((Object)"Attempting to add ArcObjects jar to classpath...");
            ArcObjectsLinker.link((String)aoCfg.getArcEngineHome());
            log.info((Object)"OK, initializing license");
            ArcObjectsInitializer.initializeLicenseWithStringCodes((String[])aoCfg.getProductCodes().toArray(new String[0]));
            this.initialized = true;
        }
        catch (Exception e) {
            log.error((Object)"Error initializing ArcObjects", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            if (this.initialized) {
                ArcObjectsInitializer.shutdown();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error shutting down ArcObjects", (Throwable)e);
        }
    }
}

