/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import nl.b3p.catalog.B3PCatalogException;
import nl.b3p.catalog.arcgis.ArcObjectsNotFoundException;
import nl.b3p.catalog.arcgis.ArcSDEHelper;
import nl.b3p.catalog.arcgis.ArcSDEJDBCDataset;
import nl.b3p.catalog.arcgis.ArcSDEJDBCHelper;
import nl.b3p.catalog.config.Root;
import nl.b3p.catalog.config.SDERoot;
import nl.b3p.catalog.filetree.DirContent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ArcSDEHelperProxy {
    private static final Log log = LogFactory.getLog(ArcSDEHelperProxy.class);

    static void rethrow(NoClassDefFoundError ncdfex) throws B3PCatalogException {
        String message = "ArcObjects is niet goed geinitialiseerd. Om metadata te bekijken en weg te schrijven in ArcSDE is dit nodig.";
        log.warn((Object)message, (Throwable)ncdfex);
        throw new ArcObjectsNotFoundException(message, (Throwable)ncdfex);
    }

    public static DirContent getDirContent(Root r, String fullPath) throws Exception {
        try {
            SDERoot root = (SDERoot)r;
            if (root.getJndiDataSource() != null) {
                return root.getJDBCHelper().getDirContent(fullPath);
            }
            return ArcSDEHelper.getDirContent((SDERoot)root, (String)fullPath);
        }
        catch (NoClassDefFoundError ncdfex) {
            ArcSDEHelperProxy.rethrow((NoClassDefFoundError)ncdfex);
            return null;
        }
    }

    public static Object getDataset(Root r, String path) throws Exception {
        try {
            SDERoot root = (SDERoot)r;
            if (root.getJndiDataSource() != null) {
                return root.getJDBCHelper().getDataset(path);
            }
            return ArcSDEHelper.getDataset((Root)root, (String)path);
        }
        catch (NoClassDefFoundError ncdfex) {
            ArcSDEHelperProxy.rethrow((NoClassDefFoundError)ncdfex);
            return null;
        }
    }

    public static Object getArcObjectsDataset(Root r, String path) throws Exception {
        try {
            return ArcSDEHelper.getDataset((Root)((SDERoot)r), (String)path);
        }
        catch (NoClassDefFoundError ncdfex) {
            ArcSDEHelperProxy.rethrow((NoClassDefFoundError)ncdfex);
            return null;
        }
    }

    public static String getMetadata(Object dataset) throws Exception {
        try {
            if (dataset instanceof ArcSDEJDBCDataset) {
                return ((ArcSDEJDBCDataset)dataset).getRoot().getJDBCHelper().getMetadata((ArcSDEJDBCDataset)dataset);
            }
            return ArcSDEHelper.getMetadata((Object)dataset);
        }
        catch (NoClassDefFoundError ncdfex) {
            ArcSDEHelperProxy.rethrow((NoClassDefFoundError)ncdfex);
            return null;
        }
    }

    public static String getMetadata(Root r, String path) throws Exception {
        try {
            SDERoot root = (SDERoot)r;
            if (root.getJndiDataSource() != null) {
                return ArcSDEJDBCHelper.getMetadata((SDERoot)root, (String)path);
            }
            return ArcSDEHelper.getMetadata((Object)ArcSDEHelper.getDataset((Root)root, (String)path));
        }
        catch (NoClassDefFoundError ncdfex) {
            ArcSDEHelperProxy.rethrow((NoClassDefFoundError)ncdfex);
            return null;
        }
    }

    public static void saveMetadata(Object dataset, String metadata) throws Exception {
        try {
            if (dataset instanceof ArcSDEJDBCDataset) {
                ((ArcSDEJDBCDataset)dataset).getRoot().getJDBCHelper().saveMetadata((ArcSDEJDBCDataset)dataset, metadata);
            } else {
                ArcSDEHelper.saveMetadata((Object)dataset, (String)metadata);
            }
        }
        catch (NoClassDefFoundError ncdfex) {
            ArcSDEHelperProxy.rethrow((NoClassDefFoundError)ncdfex);
        }
    }
}

