/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import com.esri.arcgis.datasourcesfile.ShapefileWorkspaceFactory;
import com.esri.arcgis.datasourcesraster.RasterBand;
import com.esri.arcgis.datasourcesraster.RasterDataset;
import com.esri.arcgis.geodatabase.FeatureClass;
import com.esri.arcgis.geodatabase.FeatureDataset;
import com.esri.arcgis.geodatabase.GeometricNetwork;
import com.esri.arcgis.geodatabase.IDataset;
import com.esri.arcgis.geodatabase.IEnumDataset;
import com.esri.arcgis.geodatabase.IWorkspace;
import com.esri.arcgis.geodatabase.NetworkDataset;
import com.esri.arcgis.geodatabase.RasterCatalog;
import com.esri.arcgis.geodatabase.RelationshipClass;
import com.esri.arcgis.geodatabase.RepresentationClass;
import com.esri.arcgis.geodatabase.Table;
import com.esri.arcgis.geodatabase.Tin;
import com.esri.arcgis.geodatabase.Topology;
import com.esri.arcgis.geodatabase.Workspace;
import com.esri.arcgis.geodatabase.esriDatasetType;
import com.esri.arcgis.geodatabaseextensions.CadastralFabric;
import com.esri.arcgis.geodatabaseextensions.Terrain;
import com.esri.arcgis.schematic.SchematicDataset;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import nl.b3p.catalog.B3PCatalogException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DatasetHelper {
    private static final Log log = LogFactory.getLog(DatasetHelper.class);
    public static final int DATASET_TYPE_ANY = -1;

    public static String getConstantFieldName(Class c, Object value) {
        for (Field f : c.getDeclaredFields()) {
            int mod = f.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod) || !Modifier.isFinal(mod)) continue;
            try {
                if (!value.equals(f.get(null))) continue;
                return f.getName();
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return null;
    }

    public static IDataset getDataSubset(IDataset dataset, String name, int datasetType) throws IOException {
        IDataset ds;
        log.debug((Object)String.format("Get sub dataset \"%s\" from \"%s\" (dataset type filter %d)", name, dataset.getName(), datasetType));
        IEnumDataset enumDataset = dataset.getSubsets();
        while ((ds = enumDataset.next()) != null) {
            if (datasetType != -1 && datasetType != ds.getType() || !ds.getName().equals(name)) continue;
            log.debug((Object)String.format("Found dataset, type: %s", DatasetHelper.getConstantFieldName(esriDatasetType.class, (Object)ds.getType())));
            return ds;
        }
        return null;
    }

    public static IDataset getShapeDataset(File shapeFile) throws Exception {
        ShapefileWorkspaceFactory shapefileWorkspaceFactory = new ShapefileWorkspaceFactory();
        IWorkspace iWorkspace = shapefileWorkspaceFactory.openFromFile(shapeFile.getParent(), 0);
        Workspace workspace = new Workspace((Object)iWorkspace);
        String shapefileFullname = shapeFile.getName();
        if (!shapefileFullname.endsWith(".shp") || shapefileFullname.length() == ".shp".length()) {
            throw new Exception("File is not a shape file");
        }
        String shapeFilename = shapefileFullname.substring(0, shapefileFullname.lastIndexOf(46));
        return DatasetHelper.getDataSubset((IDataset)workspace, (String)shapeFilename, (int)-1);
    }

    public static IDataset getIDataset(IDataset dataset) throws IOException, B3PCatalogException {
        switch (dataset.getType()) {
            case 4: {
                return new FeatureDataset((Object)dataset);
            }
            case 5: {
                return new FeatureClass((Object)dataset);
            }
            case 22: {
                return new CadastralFabric((Object)dataset);
            }
            case 7: {
                return new GeometricNetwork((Object)dataset);
            }
            case 19: {
                return new NetworkDataset((Object)dataset);
            }
            case 13: {
                return new RasterBand((Object)dataset);
            }
            case 16: {
                return new RasterCatalog((Object)dataset);
            }
            case 12: {
                return new RasterDataset((Object)dataset);
            }
            case 11: {
                return new RelationshipClass((Object)dataset);
            }
            case 21: {
                return new RepresentationClass((Object)dataset);
            }
            case 23: {
                return new SchematicDataset((Object)dataset);
            }
            case 10: {
                return new Table((Object)dataset);
            }
            case 20: {
                return new Terrain((Object)dataset);
            }
            case 14: {
                return new Tin((Object)dataset);
            }
            case 8: {
                return new Topology((Object)dataset);
            }
        }
        throw new B3PCatalogException("Dataset type " + DatasetHelper.getConstantFieldName(esriDatasetType.class, (Object)dataset.getType()) + " wordt niet ondersteund.");
    }
}

