/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.config;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import nl.b3p.catalog.config.AclAccess;
import nl.b3p.catalog.config.ArcObjectsConfig;
import nl.b3p.catalog.config.CSWServerConfig;
import nl.b3p.catalog.config.FileRoot;
import nl.b3p.catalog.config.KBRoot;
import nl.b3p.catalog.config.Root;
import nl.b3p.catalog.config.SDERoot;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@XmlRootElement
public class CatalogAppConfig
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(CatalogAppConfig.class);
    private static CatalogAppConfig config;
    private static final String CURRENT_VERSION = "1.0";
    @XmlAttribute
    private String version;
    private String configFilePath;
    @XmlElement(name="arcobjects")
    private ArcObjectsConfig arcObjectsConfig = new ArcObjectsConfig();
    @XmlElementWrapper(name="roots")
    @XmlElements(value={@XmlElement(name="fileRoot", type=FileRoot.class), @XmlElement(name="sdeRoot", type=SDERoot.class), @XmlElement(name="kbRoot", type=KBRoot.class)})
    private List<Root> roots = new ArrayList();
    @XmlList
    private Set<String> geoFileExtensions = new HashSet<String>(Arrays.asList("gml", "shp", "dxf", "dgn", "sdf", "sdl", "lyr", "ecw", "sid", "tif", "tiff", "asc", "mdb"));
    @XmlElementWrapper
    @XmlElements(value={@XmlElement(name="cswServer", required=false)})
    private List<CSWServerConfig> cswServers = new ArrayList();
    @XmlElementWrapper
    private Map<String, String> mdeConfig = new HashMap();
    private String organizationsJsonFile = "organizations.json";

    @XmlTransient
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public void setConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
    }

    @XmlTransient
    public ArcObjectsConfig getArcObjectsConfig() {
        return this.arcObjectsConfig;
    }

    public void setArcObjectsConfig(ArcObjectsConfig arcObjectsConfig) {
        this.arcObjectsConfig = arcObjectsConfig;
    }

    @XmlTransient
    public List<CSWServerConfig> getCswServers() {
        return this.cswServers;
    }

    public void setCswServers(List<CSWServerConfig> cswServers) {
        this.cswServers = cswServers;
    }

    @XmlTransient
    public List<Root> getRoots() {
        return this.roots;
    }

    public void setRoots(List<Root> roots) {
        this.roots = roots;
    }

    @XmlTransient
    public Set<String> getGeoFileExtensions() {
        return this.geoFileExtensions;
    }

    public void setGeoFileExtensions(Set<String> geoFileExtensions) {
        this.geoFileExtensions = geoFileExtensions;
    }

    @XmlTransient
    public Map<String, String> getMdeConfig() {
        return this.mdeConfig;
    }

    public void setMdeConfig(Map<String, String> mdeConfig) {
        this.mdeConfig = mdeConfig;
    }

    public String getOrganizationsJsonFile() {
        return this.organizationsJsonFile;
    }

    public void setOrganizationsJsonFile(String organizationsJsonFile) {
        this.organizationsJsonFile = organizationsJsonFile;
    }

    public CSWServerConfig getDefaultCswServer() {
        List csws = this.getCswServers();
        if (csws == null || csws.isEmpty()) {
            return null;
        }
        CSWServerConfig csw = (CSWServerConfig)csws.get(0);
        if (csw.getCswName() == null || csw.getCswName().isEmpty()) {
            return null;
        }
        return csw;
    }

    public static CatalogAppConfig getConfig() {
        return config;
    }

    public static CatalogAppConfig loadFromFile(File f) throws JAXBException, IOException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{CatalogAppConfig.class});
        CatalogAppConfig cfg = (CatalogAppConfig)ctx.createUnmarshaller().unmarshal(f);
        cfg.setConfigFilePath(f.getParentFile().getCanonicalPath());
        return cfg;
    }

    public void contextInitialized(ServletContextEvent sce) {
        String catalinaBase;
        String configParam = sce.getServletContext().getInitParameter("config");
        if (configParam == null) {
            throw new IllegalArgumentException("No config file specified in \"config\" context init parameter");
        }
        File f = new File(configParam);
        if (!f.isAbsolute() && (catalinaBase = System.getProperty("catalina.base")) != null) {
            f = new File(catalinaBase, configParam);
        }
        String canonicalPath = null;
        try {
            canonicalPath = f.getCanonicalPath();
        }
        catch (IOException e) {
            canonicalPath = "[IOException: " + e.getMessage() + "]";
        }
        log.info((Object)("Loading configuration from file " + canonicalPath));
        if (!f.exists() || !f.canRead()) {
            throw new IllegalArgumentException(String.format("Config file specified in \"config\" context init parameter with value \"%s\" (canonical path \"%s\") does not exist or cannot be read", configParam, canonicalPath));
        }
        try {
            config = CatalogAppConfig.loadFromFile((File)f);
            log.debug((Object)"Configuration loaded; marshalling for log");
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{CatalogAppConfig.class});
            Marshaller m = ctx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter sw = new StringWriter();
            m.marshal((Object)config, (Writer)sw);
            log.info((Object)("Parsed configuration: \n" + sw.toString()));
            if (!"1.0".equals(config.getVersion())) {
                throw new Exception(String.format("Wrong configuration file version: %s, must be %s", config.getVersion(), "1.0"));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading configuration", (Throwable)e);
            throw new IllegalArgumentException("Error loading configuration from file \"" + canonicalPath + '\"', e);
        }
        if (log.isDebugEnabled()) {
            for (Root r : config.getRoots()) {
                log.debug((Object)String.format("Role access list for root %s: %s", r.getName(), r.getRoleAccessList().toString()));
            }
        }
    }

    public boolean isAddOnly(HttpServletRequest request) {
        if (this.roots == null || this.roots.isEmpty()) {
            return false;
        }
        boolean addOnly = false;
        for (Root root : this.roots) {
            AclAccess highest = root.getRequestUserHighestAccessLevel(request);
            if (highest.getSecurityLevel() == AclAccess.ADD.getSecurityLevel()) {
                addOnly = true;
            }
            if (highest.getSecurityLevel() == AclAccess.ADD.getSecurityLevel()) continue;
            return false;
        }
        return addOnly;
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

