/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.catalog.B3PCatalogException;
import nl.b3p.catalog.config.CSWServerConfig;
import nl.b3p.catalog.config.CatalogAppConfig;
import nl.b3p.catalog.resolution.HtmlErrorResolution;
import nl.b3p.catalog.resolution.HtmlResolution;
import nl.b3p.catalog.resolution.XmlResolution;
import nl.b3p.catalog.stripes.CatalogAction;
import nl.b3p.catalog.stripes.DefaultAction;
import nl.b3p.catalog.xml.DocumentHelper;
import nl.b3p.catalog.xml.mdeXml2Html;
import nl.b3p.csw.client.CswClient;
import nl.b3p.csw.client.CswRequestCreator;
import nl.b3p.csw.client.CswSmartRequestCreator;
import nl.b3p.csw.client.InputById;
import nl.b3p.csw.client.InputBySearch;
import nl.b3p.csw.client.Output;
import nl.b3p.csw.client.OutputById;
import nl.b3p.csw.client.OutputBySearch;
import nl.b3p.csw.client.OwsException;
import nl.b3p.csw.jaxb.csw.GetRecords;
import nl.b3p.csw.server.CswServable;
import nl.b3p.csw.server.GeoNetworkCswServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.json.JSONArray;
import org.json.JSONObject;

public class CatalogAction
extends DefaultAction {
    private static final Log log = LogFactory.getLog(CatalogAction.class);
    protected static final String SEARCH_RESULTS_JSP = "/WEB-INF/jsp/main/searchResults.jsp";
    @Validate(required=true, on={"search"})
    private String searchString;
    @Validate(required=true, on={"search"})
    private String searchType;
    @Validate(required=false)
    private String resultType;
    private List<MetadataBean> metadataList;
    @Validate(required=true, on={"load", "loadMdAsHtml"})
    private String uuid;

    public Resolution search() {
        if (this.searchString == null || this.searchString.trim().equals("")) {
            this.searchString = "*";
        }
        try {
            CswClient client = this.getCswClient();
            GetRecords getRecords = null;
            getRecords = this.searchType.equalsIgnoreCase("title") ? CswSmartRequestCreator.createSmartCswRequest((String)this.searchString, (String)this.searchType) : CswRequestCreator.createCswRequest((String)this.searchString, (String)this.searchType, (String)"", (String)"", (String)"", (boolean)true);
            OutputBySearch output = client.search(new InputBySearch((JAXBElement)getRecords));
            this.metadataList = this.createMetadataList((Output)output);
            if (this.resultType != null && this.resultType.equals("json")) {
                JSONArray resultList = new JSONArray((Collection)this.metadataList);
                JSONObject searchResult = new JSONObject();
                searchResult.put("success", true);
                searchResult.put("result", (Object)resultList);
                return new StreamingResolution("application/json; charset=UTF-8", searchResult.toString());
            }
            return new ForwardResolution(SEARCH_RESULTS_JSP);
        }
        catch (Exception e) {
            String message = "Fout bij het zoeken naar de metadata";
            log.error((Object)message, (Throwable)e);
            return new HtmlErrorResolution(message, e);
        }
    }

    public Resolution loadMdAsHtml() {
        try {
            CswClient client = this.getCswClient();
            OutputById output = client.search(new InputById(this.uuid));
            if (output.getSearchResult() == null) {
                throw new IllegalArgumentException(String.format("Metadata document met UUID \"%s\" kon niet worden gevonden bij CSW-service", this.uuid));
            }
            String metadata = output.getSearchResultString();
            Document mdDoc = DocumentHelper.getMetadataDocument((String)metadata);
            Document htmlDoc = mdeXml2Html.transform((Document)mdDoc, (Boolean)true);
            String d = DocumentHelper.getDocumentString((Document)htmlDoc);
            log.debug((Object)("serverside rendered html for method loadMdAsHtml: " + d));
            StringReader sr = new StringReader(d);
            return new HtmlResolution((Reader)sr);
        }
        catch (Exception e) {
            String message = "Fout bij het laden van de metadata.";
            log.error((Object)message, (Throwable)e);
            return new HtmlErrorResolution(message, e);
        }
    }

    public Resolution load() {
        try {
            CswClient client = this.getCswClient();
            OutputById output = client.search(new InputById(this.uuid));
            if (output.getSearchResult() == null) {
                throw new IllegalArgumentException(String.format("Metadata document met UUID \"%s\" kon niet worden gevonden bij CSW-service", this.uuid));
            }
            if (this.resultType != null && this.resultType.equals("json")) {
                JSONObject loadResult = new JSONObject();
                loadResult.put("success", true);
                loadResult.put("result", (Collection)this.createMetadataList((Output)output));
                return new StreamingResolution("application/json; charset=UTF-8", loadResult.toString());
            }
            return new XmlResolution(output.getSearchResultString());
        }
        catch (Exception e) {
            String message = "Fout bij het laden van de metadata.";
            log.error((Object)message, (Throwable)e);
            return new HtmlErrorResolution(message, e);
        }
    }

    public Resolution export() {
        Resolution resolution = this.load();
        if (resolution instanceof XmlResolution) {
            String exportName = "metadata.xml";
            XmlResolution xmlResolution = (XmlResolution)resolution;
            xmlResolution.setAttachment(true);
            xmlResolution.setFilename(exportName);
        }
        return resolution;
    }

    private CswClient getCswClient() throws B3PCatalogException {
        CSWServerConfig cfg = CatalogAppConfig.getConfig().getDefaultCswServer();
        if (cfg == null || cfg.getCswName() == null || cfg.getCswName().isEmpty()) {
            throw new B3PCatalogException("Geen CSW server geconfigureerd!");
        }
        return new CswClient((CswServable)new GeoNetworkCswServer(cfg.getLoginUrl(), cfg.getUrl(), cfg.getUsername(), cfg.getPassword()));
    }

    protected List<MetadataBean> createMetadataList(Output output) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, JDOMException, JAXBException, OwsException {
        List metadataDocs = output.getSearchResults();
        ArrayList<MetadataBean> list = new ArrayList<MetadataBean>(metadataDocs.size());
        for (Element mdElem : metadataDocs) {
            MetadataBean metadataBean = new MetadataBean(this);
            metadataBean.setTitle(output.getTitle(mdElem));
            metadataBean.setAltTitle("");
            metadataBean.setAbstractString(output.getAbstractText(mdElem));
            metadataBean.setUuid(output.getUUID(mdElem, true));
            metadataBean.setMetadataForService(output.isMetadataForService(mdElem));
            metadataBean.setOperatesOn(output.getOperatesOnAsStringList(mdElem));
            metadataBean.setKeyWords(output.getKeyWordsAsStringList(mdElem));
            metadataBean.setUrlDatasets(output.getUrlDatasetsAsStringList(mdElem));
            metadataBean.setBrowseGraphicFileName(output.getBrowseGraphicFileName(mdElem));
            metadataBean.setDateStamp(output.getDateStamp(mdElem));
            metadataBean.setIdentificationDate(output.getIdentificationDate(mdElem));
            metadataBean.setMetadataStandardName(output.getMetadataStandardName(mdElem));
            metadataBean.setResponsibleOrganisationName(output.getResponsibleOrganisationName(mdElem));
            list.add(metadataBean);
        }
        return list;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getSearchType() {
        return this.searchType;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public String getResultType() {
        return this.resultType;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public List<MetadataBean> getMetadataList() {
        return this.metadataList;
    }

    public void setMetadataList(List<MetadataBean> metadataList) {
        this.metadataList = metadataList;
    }
}

