/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.stripes;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerException;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.catalog.B3PCatalogException;
import nl.b3p.catalog.Roles;
import nl.b3p.catalog.arcgis.ArcGISSynchronizer;
import nl.b3p.catalog.arcgis.ArcObjectsSynchronizerForker;
import nl.b3p.catalog.arcgis.ArcSDEHelperProxy;
import nl.b3p.catalog.arcgis.ArcSDEJDBCDataset;
import nl.b3p.catalog.arcgis.DatasetHelperProxy;
import nl.b3p.catalog.arcgis.FGDBHelperProxy;
import nl.b3p.catalog.arcgis.Shapefiles;
import nl.b3p.catalog.config.AclAccess;
import nl.b3p.catalog.config.ArcObjectsConfig;
import nl.b3p.catalog.config.CatalogAppConfig;
import nl.b3p.catalog.config.Root;
import nl.b3p.catalog.filetree.FileListHelper;
import nl.b3p.catalog.kaartenbalie.KbJDBCHelperProxy;
import nl.b3p.catalog.resolution.HtmlErrorResolution;
import nl.b3p.catalog.resolution.HtmlResolution;
import nl.b3p.catalog.stripes.DefaultAction;
import nl.b3p.catalog.stripes.OrganisationsAction;
import nl.b3p.catalog.xml.DocumentHelper;
import nl.b3p.catalog.xml.NCMLSynchronizer;
import nl.b3p.catalog.xml.Namespaces;
import nl.b3p.catalog.xml.ShapefileSynchronizer;
import nl.b3p.catalog.xml.XPathHelper;
import nl.b3p.catalog.xml.mdeXml2Html;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.ProcessingInstruction;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetadataAction
extends DefaultAction {
    private static final Log log = LogFactory.getLog(MetadataAction.class);
    private static final String FILE_MODE = "file";
    private static final String SDE_MODE = "sde";
    private static final String LOCAL_MODE = "local";
    private static final String KB_MODE = "kaartenbalie";
    private static final String EXPORT_TYPE_ALL = "all";
    private static final String EXPORT_TYPE_DATASETS = "datasets";
    private static final String EXPORT_TYPE_SERVICES = "services";
    public static final String ADDRESS = "address";
    public static final String CITY = "city";
    public static final String STATE = "state";
    public static final String POSTCALCODE = "postalCode";
    public static final String COUNTRY = "country";
    public static final String URL = "url";
    public static final String EMAIL = "email";
    public static final String VOICE = "voice";
    public static final String CONTACTS = "contacts";
    public static final String SESSION_KEY_METADATA_XML = MetadataAction.class.getName() + ".METADATA_XML";
    public static final String ISO2SIMPLE_HTML = "xsls/iso-simple-html.xsl";
    private static final DateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final int esriDTFeatureClass = 5;
    @Validate(required=true, on={"!importMD", "!updateXml", "!updateElementsAndGetXml", "!resetXml"})
    private String path;
    @Validate(required=true, on={"!importMD", "!updateXml", "!updateElementsAndGetXml", "!resetXml"})
    private String mode;
    @Validate(required=true, on={"save"})
    private String metadata;
    @Validate(required=true, on={"postComment"})
    private String comment;
    @Validate(required=true, on={"export"})
    private String exportType = "all";
    @Validate
    private FileBean importXml;
    @Validate
    private String synchronizeData;
    @Validate
    private String username;
    @Validate(on={"updateXml"})
    private String elementChanges;
    @Validate(on={"updateXml"})
    private String sectionChange;
    @Validate
    private Boolean viewMode = null;
    @Validate
    private String fileName = null;
    @Validate
    private Boolean newUuid;
    private Root root;
    private AclAccess rootAccess;
    private Map<String, String> extraHeaders = new HashMap();
    protected static final String VIEW_METADATA_JSP = "/WEB-INF/jsp/main/mdview.jsp";

    public void determineRoot() throws B3PCatalogException {
        if (LOCAL_MODE.equals(this.mode)) {
            this.rootAccess = AclAccess.WRITE;
            this.extraHeaders.put("X-MDE-Access", "WRITE");
            if (this.viewMode == null) {
                this.viewMode = Boolean.FALSE;
            }
        } else if (this.path != null && !this.path.isEmpty()) {
            this.root = Root.getRootForPath((String)this.path, (HttpServletRequest)this.getContext().getRequest(), (AclAccess)AclAccess.READ);
            this.rootAccess = this.root.getRequestUserHighestAccessLevel(this.getContext().getRequest());
            if (this.viewMode == null || !this.viewMode.booleanValue()) {
                this.viewMode = this.rootAccess == null || this.rootAccess.getSecurityLevel() < AclAccess.ADD.getSecurityLevel();
            }
            this.extraHeaders.put("X-MDE-Access", this.rootAccess.name());
        } else {
            this.viewMode = Boolean.TRUE;
        }
    }

    public Resolution view() {
        return new ForwardResolution(VIEW_METADATA_JSP);
    }

    public Resolution loadMdAsHtml() {
        Document md = null;
        try {
            this.determineRoot();
            md = this.loadXmlFromSource(md);
            md = this.preprocessXml(md);
            md = this.addDateUUID(md, false);
            this.getContext().getRequest().getSession().setAttribute(SESSION_KEY_METADATA_XML, (Object)md);
            String html = this.createHtmlFragment(md);
            return new HtmlResolution((Reader)new StringReader(html), this.extraHeaders);
        }
        catch (Exception e) {
            this.getContext().getRequest().getSession().removeAttribute(SESSION_KEY_METADATA_XML);
            String message = "Kan geen " + this.mode + " metadata openen van lokatie " + this.path;
            log.error((Object)message, (Throwable)e);
            return new HtmlErrorResolution(message, e);
        }
    }

    public Resolution resetXml() throws Exception {
        try {
            this.viewMode = false;
            this.getContext().getRequest().getSession().removeAttribute(SESSION_KEY_METADATA_XML);
            Document md = DocumentHelper.getMetadataDocument((String)"");
            md = this.preprocessXml(md);
            md = this.addDateUUID(md, false);
            this.getContext().getRequest().getSession().setAttribute(SESSION_KEY_METADATA_XML, (Object)md);
            String html = this.createHtmlFragment(md);
            return new HtmlResolution((Reader)new StringReader(html), this.extraHeaders);
        }
        catch (Exception e) {
            String message = "Fout bij reset document";
            log.error((Object)message, (Throwable)e);
            return new HtmlErrorResolution(message, e);
        }
    }

    public Resolution updateXml() throws Exception {
        try {
            this.viewMode = false;
            Document md = (Document)this.getContext().getRequest().getSession().getAttribute(SESSION_KEY_METADATA_XML);
            if (md == null) {
                throw new IllegalStateException("Geen metadatadocument geopend in deze sessie");
            }
            md = this.applyChangesXml(md, true);
            md = this.preprocessXml(md);
            md = this.syncBetweenElements(md);
            this.getContext().getRequest().getSession().setAttribute(SESSION_KEY_METADATA_XML, (Object)md);
            String html = this.createHtmlFragment(md);
            return new HtmlResolution((Reader)new StringReader(html), this.extraHeaders);
        }
        catch (Exception e) {
            String message = "Fout bij toepassen wijzigingen op XML document: " + this.elementChanges + " " + this.sectionChange;
            log.error((Object)message, (Throwable)e);
            return new HtmlErrorResolution(message, e);
        }
    }

    public Resolution updateElementsAndGetXml() throws Exception {
        try {
            this.viewMode = false;
            Document md = (Document)this.getContext().getRequest().getSession().getAttribute(SESSION_KEY_METADATA_XML);
            if (md == null) {
                throw new IllegalStateException("Geen metadatadocument geopend in deze sessie");
            }
            md = this.applyChangesXml(md, false);
            md = this.syncBetweenElements(md);
            Document mdCopy = this.cleanupXmlCopy(md, this.exportType);
            if (EXPORT_TYPE_DATASETS.equals(this.exportType)) {
                HttpServletRequest req = this.getContext().getRequest();
                StringBuilder sb = new StringBuilder();
                sb.append(req.getScheme());
                sb.append("://");
                sb.append(req.getServerName());
                sb.append(":");
                sb.append(req.getServerPort());
                sb.append(req.getContextPath());
                sb.append("/");
                sb.append(ISO2SIMPLE_HTML);
                ProcessingInstruction pi = new ProcessingInstruction("xml-stylesheet", "type='text/xsl' href='" + sb.toString() + "'");
                mdCopy.addContent(0, (Content)pi);
            }
            return new StreamingResolution("text/plain", (Reader)new StringReader(DocumentHelper.getDocumentString((Document)mdCopy)));
        }
        catch (Exception e) {
            String message = "Fout bij toepassen wijzigingen op XML document: " + this.elementChanges + " " + this.sectionChange;
            log.error((Object)message, (Throwable)e);
            return new HtmlErrorResolution(message, e);
        }
    }

    public Resolution updateAndSaveXml() throws Exception {
        Document mdCopy;
        Document md;
        try {
            md = (Document)this.getContext().getRequest().getSession().getAttribute(SESSION_KEY_METADATA_XML);
            if (md == null) {
                throw new IllegalStateException("Geen metadatadocument geopend in deze sessie");
            }
            md = this.applyChangesXml(md, false);
            md = this.syncBetweenElements(md);
            if (Roles.isAdmin((ServletContext)this.getContext().getServletContext(), (HttpServletRequest)this.getContext().getRequest())) {
                OrganisationsAction.saveOrganisations((Document)md);
            }
            mdCopy = this.cleanupXmlCopy(md, EXPORT_TYPE_ALL);
        }
        catch (Exception e) {
            String message = "Fout bij toepassen wijzigingen op XML document: " + this.elementChanges + " " + this.sectionChange;
            log.error((Object)message, (Throwable)e);
            return new HtmlErrorResolution(message, e);
        }
        String mdString = DocumentHelper.getDocumentString((Document)mdCopy);
        try {
            this.determineRoot();
            if (this.rootAccess.getSecurityLevel() < AclAccess.ADD.getSecurityLevel()) {
                throw new B3PCatalogException("Geen rechten om metadata op te slaan op deze locatie");
            }
            this.saveXmlToSource(mdString);
            String html = this.createHtmlFragment(md);
            return new HtmlResolution((Reader)new StringReader(html), this.extraHeaders);
        }
        catch (Exception e) {
            String message = "Could not write " + this.mode + " metadata to location " + this.path;
            log.error((Object)message, (Throwable)e);
            return new HtmlErrorResolution(message, e);
        }
    }

    public Resolution synchronizeLocal() throws Exception {
        this.determineRoot();
        Document md = (Document)this.getContext().getRequest().getSession().getAttribute(SESSION_KEY_METADATA_XML);
        if (md == null) {
            throw new IllegalStateException("Geen metadatadocument geopend in deze sessie");
        }
        if (this.path.toLowerCase().endsWith(".shp")) {
            ShapefileSynchronizer.synchronizeFromLocalAccessJSON((Document)md, (String)this.synchronizeData);
        } else if (this.path.toLowerCase().endsWith(".nc.xml")) {
            md = NCMLSynchronizer.synchronizeNCML((Document)md, (String)this.synchronizeData);
        }
        this.getContext().getRequest().getSession().setAttribute(SESSION_KEY_METADATA_XML, (Object)md);
        String html = this.createHtmlFragment(md);
        return new HtmlResolution((Reader)new StringReader(html), this.extraHeaders);
    }

    public Resolution synchronize() {
        try {
            if (LOCAL_MODE.equals(this.mode)) {
                return this.synchronizeLocal();
            }
            this.determineRoot();
            Document md = (Document)this.getContext().getRequest().getSession().getAttribute(SESSION_KEY_METADATA_XML);
            if (md == null) {
                throw new IllegalStateException("Geen metadatadocument geopend in deze sessie");
            }
            md = this.syncXmlFromDataSource(md);
            md = this.syncBetweenElements(md);
            this.getContext().getRequest().getSession().setAttribute(SESSION_KEY_METADATA_XML, (Object)md);
            String html = this.createHtmlFragment(md);
            return new HtmlResolution((Reader)new StringReader(html), this.extraHeaders);
        }
        catch (Exception e) {
            String message = "Fout tijdens synchroniseren " + this.mode + " metadata van lokatie " + this.path;
            log.error((Object)message, (Throwable)e);
            return new HtmlErrorResolution(message, e);
        }
    }

    private void synchronizeRegularMetadata(Document xmlDoc, File dataFile) throws IOException, JDOMException, B3PCatalogException {
        String localFilename = dataFile.getName();
        String title = "";
        String fileFormat = "";
        int dotIndex = localFilename.lastIndexOf(".");
        if (dotIndex > 0) {
            title = localFilename.substring(0, dotIndex);
            if (dotIndex < localFilename.length()) {
                fileFormat = localFilename.substring(dotIndex + 1);
                fileFormat = StringUtils.capitalize((String)fileFormat);
            }
        } else if (dotIndex == 0) {
            title = localFilename.substring(1);
        }
        XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:title/gco:CharacterString", (String)title);
        XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gfc:FC_FeatureCatalogue/gmx:name/gco:CharacterString", (String)title);
        XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:distributionInfo/gmd:MD_Distribution/gmd:distributionFormat[1]/gmd:MD_Format/gmd:name/gco:CharacterString", (String)fileFormat);
        XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:distributionInfo/gmd:MD_Distribution/gmd:distributionFormat[1]/gmd:MD_Format/gmd:version/gco:CharacterString", (String)"Onbekend");
        XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:distributionInfo/gmd:MD_Distribution/gmd:transferOptions/gmd:MD_DigitalTransferOptions/gmd:onLine[1]/gmd:CI_OnlineResource/gmd:linkage/gmd:URL", (String)dataFile.getCanonicalPath());
        XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:distributionInfo/gmd:MD_Distribution/gmd:transferOptions/gmd:MD_DigitalTransferOptions/gmd:onLine[1]/gmd:CI_OnlineResource/gmd:name/gco:CharacterString", (String)"");
        XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:distributionInfo/gmd:MD_Distribution/gmd:transferOptions/gmd:MD_DigitalTransferOptions/gmd:onLine[1]/gmd:CI_OnlineResource/gmd:protocol/gco:CharacterString", (String)"download");
        XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:distributionInfo/gmd:MD_Distribution/gmd:transferOptions/gmd:MD_DigitalTransferOptions/gmd:onLine[1]/gmd:CI_OnlineResource/gmd:description/gco:CharacterString", (String)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution importMD() {
        try {
            Document md;
            this.viewMode = false;
            if (this.importXml != null) {
                md = new SAXBuilder().build(this.importXml.getInputStream());
                DocumentHelper.getRoot((Document)md);
            } else if (this.metadata != null) {
                md = DocumentHelper.getMetadataDocument((String)this.metadata);
            } else {
                throw new IllegalArgumentException();
            }
            md = this.preprocessXml(md);
            md = this.addDateUUID(md, this.newUuid == null ? false : this.newUuid);
            this.getContext().getRequest().getSession().setAttribute(SESSION_KEY_METADATA_XML, (Object)md);
            String html = this.createHtmlFragment(md);
            HtmlResolution htmlResolution = new HtmlResolution((Reader)new StringReader(html), this.extraHeaders);
            return htmlResolution;
        }
        catch (Exception e) {
            this.getContext().getRequest().getSession().removeAttribute(SESSION_KEY_METADATA_XML);
            String message = "Fout bij laden importeren metadata " + this.path;
            log.error((Object)message, (Throwable)e);
            HtmlErrorResolution htmlErrorResolution = new HtmlErrorResolution(message, e);
            return htmlErrorResolution;
        }
        finally {
            try {
                if (this.importXml != null) {
                    this.importXml.delete();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public Resolution export() throws Exception {
        Resolution resolution = this.updateElementsAndGetXml();
        if (resolution instanceof StreamingResolution) {
            String exportName = null;
            int i = this.path.lastIndexOf("/");
            if (i == -1) {
                i = this.path.lastIndexOf("\\");
            }
            if (!(exportName = i != -1 ? this.path.substring(i + 1) : this.path).endsWith(".xml")) {
                exportName = exportName + ".xml";
            }
            StreamingResolution sr = (StreamingResolution)resolution;
            sr.setAttachment(true);
            sr.setFilename(exportName);
        }
        return resolution;
    }

    public Resolution postComment() throws Exception {
        try {
            Document md = (Document)this.getContext().getRequest().getSession().getAttribute(SESSION_KEY_METADATA_XML);
            if (md == null) {
                throw new IllegalStateException("Geen metadatadocument geopend in deze sessie");
            }
            this.determineRoot();
            if (this.rootAccess.getSecurityLevel() < AclAccess.COMMENT.getSecurityLevel()) {
                throw new B3PCatalogException("Geen rechten om commentaar aan metadata toe te voegen op deze locatie");
            }
            this.addComment(md, this.comment);
            md = this.preprocessXml(md);
            this.getContext().getRequest().getSession().setAttribute(SESSION_KEY_METADATA_XML, (Object)md);
            if (this.rootAccess.getSecurityLevel() == AclAccess.COMMENT.getSecurityLevel()) {
                Document mdCopy = this.cleanupXmlCopy(md, EXPORT_TYPE_ALL);
                String mdString = DocumentHelper.getDocumentString((Document)mdCopy);
                this.saveXmlToSource(mdString);
            }
            String html = this.createHtmlFragment(md);
            return new HtmlResolution((Reader)new StringReader(html), this.extraHeaders);
        }
        catch (Exception e) {
            String message = "Het is niet gelukt om het commentaar (" + this.comment + ") te posten in " + this.mode + " op lokatie \"" + this.path + "\"";
            log.error((Object)message, (Throwable)e);
            return new HtmlErrorResolution(message, e);
        }
    }

    private Document preprocessXml(Document md) throws JDOMException, IOException, TransformerException {
        md = mdeXml2Html.preprocess((Document)md, (Boolean)this.viewMode);
        md = mdeXml2Html.extraPreprocessor1((Document)md, (Boolean)this.viewMode);
        md = mdeXml2Html.extraPreprocessor2((Document)md, (Boolean)this.viewMode);
        return md;
    }

    private String createHtmlFragment(Document md) throws JDOMException, IOException, TransformerException {
        Document htmlDoc = mdeXml2Html.transform((Document)md, (Boolean)this.viewMode);
        htmlDoc = mdeXml2Html.extraPostprocessor1((Document)htmlDoc, (Boolean)this.viewMode);
        String html = DocumentHelper.getDocumentString((Document)htmlDoc);
        return html;
    }

    private Document addDateUUID(Document md, boolean overwrite) throws JDOMException {
        mdeXml2Html.addDateStamp((Document)md, (boolean)overwrite);
        mdeXml2Html.addUUID((Document)md, (boolean)overwrite);
        return md;
    }

    private Document syncBetweenElements(Document md) throws B3PCatalogException, JDOMException, IOException, TransformerException {
        Boolean synchroniseDC = mdeXml2Html.getXSLParam((String)"synchroniseDC_init");
        if (synchroniseDC != null && synchroniseDC.booleanValue()) {
            md = mdeXml2Html.iSO19115toDCSynchronizer((Document)md);
        }
        md = mdeXml2Html.extraSync1((Document)md);
        md = mdeXml2Html.extraSync2((Document)md);
        return md;
    }

    private File determineXmlFile(File mdFile) throws IOException {
        String path = mdFile.getCanonicalPath();
        if (path.endsWith(".xml")) {
            return mdFile;
        }
        return new File(mdFile.getCanonicalPath() + ".xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadXmlFromSource(Document md) throws JDOMException, Exception {
        if (LOCAL_MODE.equals(this.mode)) {
            if (this.metadata.equals("null")) {
                this.metadata = "empty";
            }
            md = DocumentHelper.getMetadataDocument((String)this.metadata);
        } else if (KB_MODE.equals(this.mode)) {
            this.metadata = KbJDBCHelperProxy.getMetadata((Root)this.root, (String)this.path);
            md = DocumentHelper.getMetadataDocument((String)this.metadata);
        } else if (SDE_MODE.equals(this.mode)) {
            this.metadata = ArcSDEHelperProxy.getMetadata((Root)this.root, (String)this.path);
            md = DocumentHelper.getMetadataDocument((String)this.metadata);
        } else if (FILE_MODE.equals(this.mode)) {
            File mdFile = FileListHelper.getFileForPath((Root)this.root, (String)this.path);
            if (FGDBHelperProxy.isFGDBDirOrInsideFGDBDir((File)mdFile)) {
                try {
                    FGDBHelperProxy.cleanerTrackObjectsInCurrentThread();
                    this.metadata = FGDBHelperProxy.getMetadata((File)mdFile, (int)-1);
                }
                finally {
                    FGDBHelperProxy.cleanerReleaseAllInCurrentThread();
                }
                md = DocumentHelper.getMetadataDocument((String)this.metadata);
            } else {
                md = !(mdFile = this.determineXmlFile(mdFile)).exists() ? DocumentHelper.getMetadataDocument((String)"empty") : DocumentHelper.getMetadataDocument((File)mdFile);
            }
        } else {
            throw new IllegalArgumentException("Invalid mode: " + this.mode);
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveXmlToSource(String mdString) throws Exception {
        if (KB_MODE.equals(this.mode)) {
            KbJDBCHelperProxy.saveMetadata((Root)this.root, (String)this.path, (String)mdString);
        } else if (SDE_MODE.equals(this.mode)) {
            Object dataset = ArcSDEHelperProxy.getDataset((Root)this.root, (String)this.path);
            ArcSDEHelperProxy.saveMetadata((Object)dataset, (String)mdString);
        } else if (FILE_MODE.equals(this.mode)) {
            File mdFile = FileListHelper.getFileForPath((Root)this.root, (String)this.path);
            if (FGDBHelperProxy.isFGDBDirOrInsideFGDBDir((File)mdFile)) {
                try {
                    FGDBHelperProxy.cleanerTrackObjectsInCurrentThread();
                    FGDBHelperProxy.setMetadata((File)mdFile, (int)-1, (String)mdString);
                }
                finally {
                    FGDBHelperProxy.cleanerReleaseAllInCurrentThread();
                }
            } else {
                mdFile = this.determineXmlFile(mdFile);
                BufferedOutputStream outputStream = new BufferedOutputStream(FileUtils.openOutputStream((File)mdFile));
                ((OutputStream)outputStream).write(mdString.getBytes("UTF-8"));
                ((OutputStream)outputStream).close();
            }
        } else {
            throw new IllegalArgumentException("Invalid mode: " + this.mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document syncXmlFromDataSource(Document md) throws JDOMException, Exception {
        if (KB_MODE.equals(this.mode)) {
            String mdString = DocumentHelper.getDocumentString((Document)md);
            mdString = KbJDBCHelperProxy.syncMetadata((Root)this.root, (String)this.path, (String)mdString);
            return DocumentHelper.getMetadataDocument((String)mdString);
        }
        if (SDE_MODE.equals(this.mode)) {
            Object dataset = ArcSDEHelperProxy.getDataset((Root)this.root, (String)this.path);
            if (!(dataset instanceof ArcSDEJDBCDataset)) {
                ArcGISSynchronizer.synchronize((Document)md, (Object)dataset, (String)"ESRI ArcSDE");
                return md;
            }
            ArcObjectsConfig cfg = CatalogAppConfig.getConfig().getArcObjectsConfig();
            if (cfg.isEnabled()) {
                dataset = ArcSDEHelperProxy.getArcObjectsDataset((Root)this.root, (String)this.path);
                ArcGISSynchronizer.synchronize((Document)md, (Object)dataset, (String)"ESRI ArcSDE");
                return md;
            }
            if (!cfg.isForkSynchroniser()) throw new Exception("ArcObjects niet geconfigureerd, synchroniseren niet mogelijk");
            ArcSDEJDBCDataset ds = (ArcSDEJDBCDataset)dataset;
            if (ds.getRoot().getArcobjectsConnection() != null) return ArcObjectsSynchronizerForker.synchronize((ServletContext)this.getContext().getServletContext(), (String)ds.getAbsoluteName(), (String)SDE_MODE, (String)ds.getRoot().getArcobjectsConnection(), (String)this.metadata);
            throw new Exception("ArcObjects niet geconfigureerd, synchroniseren niet mogelijk");
        }
        if (!FILE_MODE.equals(this.mode)) throw new IllegalArgumentException("Invalid mode: " + this.mode);
        File dataFile = FileListHelper.getFileForPath((Root)this.root, (String)this.path);
        boolean isFGDB = FGDBHelperProxy.isFGDBDirOrInsideFGDBDir((File)dataFile);
        ArcObjectsConfig cfg = CatalogAppConfig.getConfig().getArcObjectsConfig();
        if (cfg.isEnabled()) {
            if (isFGDB) {
                try {
                    FGDBHelperProxy.cleanerTrackObjectsInCurrentThread();
                    Object ds = FGDBHelperProxy.getTargetDataset((File)dataFile, (int)-1);
                    ArcGISSynchronizer.synchronize((Document)md, (Object)ds, (String)"ESRI file geodatabase (FGDB)");
                    return md;
                }
                finally {
                    FGDBHelperProxy.cleanerReleaseAllInCurrentThread();
                }
            }
            if (!this.path.endsWith(".shp")) return md;
            try {
                FGDBHelperProxy.cleanerTrackObjectsInCurrentThread();
                Object ds = DatasetHelperProxy.getShapeDataset((File)dataFile);
                ArcGISSynchronizer.synchronize((Document)md, (Object)ds, (String)"ESRI shapefile");
                return md;
            }
            finally {
                FGDBHelperProxy.cleanerReleaseAllInCurrentThread();
            }
        }
        if (cfg.isForkSynchroniser()) {
            return ArcObjectsSynchronizerForker.synchronize((ServletContext)this.getContext().getServletContext(), (String)FileListHelper.getFileForPath((Root)this.root, (String)this.path).getAbsolutePath(), (String)(isFGDB ? "fgdb" : "shape"), null, (String)this.metadata);
        }
        if (this.path.endsWith(".shp")) {
            File shapeFile = FileListHelper.getFileForPath((Root)this.root, (String)this.path);
            String synchronizeData = Shapefiles.getMetadata((String)shapeFile.getCanonicalPath());
            ShapefileSynchronizer.synchronizeFromLocalAccessJSON((Document)md, (String)synchronizeData);
            return md;
        }
        this.synchronizeRegularMetadata(md, dataFile);
        return md;
    }

    private Document cleanupXmlCopy(Document md, String exportType) throws B3PCatalogException {
        Boolean serviceMode = mdeXml2Html.getXSLParam((String)"serviceMode_init");
        Boolean datasetMode = mdeXml2Html.getXSLParam((String)"datasetMode_init");
        if (EXPORT_TYPE_DATASETS.equals(exportType)) {
            serviceMode = Boolean.FALSE;
            datasetMode = Boolean.TRUE;
        } else if (EXPORT_TYPE_SERVICES.equals(exportType)) {
            serviceMode = Boolean.TRUE;
            datasetMode = Boolean.FALSE;
        } else if (EXPORT_TYPE_ALL.equals(exportType)) {
            serviceMode = Boolean.TRUE;
            datasetMode = Boolean.TRUE;
        }
        Document mdCopy = new Document((Element)md.getRootElement().clone());
        mdeXml2Html.cleanUpMetadata((Document)mdCopy, (boolean)(serviceMode == null ? false : serviceMode), (boolean)(datasetMode == null ? false : datasetMode));
        mdeXml2Html.removeEmptyNodes((Document)mdCopy);
        if (EXPORT_TYPE_DATASETS.equals(exportType) || EXPORT_TYPE_SERVICES.equals(exportType)) {
            Element MD_Metadata = DocumentHelper.getMD_Metadata((Document)mdCopy);
            MD_Metadata.detach();
            mdCopy = new Document(MD_Metadata);
        }
        return mdCopy;
    }

    private Document applyChangesXml(Document md, boolean doSections) throws Exception {
        if (this.elementChanges != null) {
            mdeXml2Html.applyElementChanges((Document)md, (JSONArray)new JSONArray(this.elementChanges));
        }
        if (this.sectionChange != null && doSections) {
            mdeXml2Html.applySectionChange((Document)md, (JSONObject)new JSONObject(this.sectionChange));
        }
        return md;
    }

    protected Document extractMD_MetadataAsDoc(Document doc) throws JDOMException, IOException, B3PCatalogException {
        Element MD_Metadata = DocumentHelper.getMD_Metadata((Document)doc);
        MD_Metadata.detach();
        Document extractedDoc = new Document(MD_Metadata);
        return extractedDoc;
    }

    protected String extractMD_Metadata(Document doc) throws JDOMException, IOException, B3PCatalogException {
        Document extractedDoc = this.extractMD_MetadataAsDoc(doc);
        return new XMLOutputter(Format.getPrettyFormat()).outputString(extractedDoc);
    }

    protected Document extractMD_MetadataAsDoc(String md) throws JDOMException, IOException, B3PCatalogException {
        Document doc = DocumentHelper.getMetadataDocument((String)md);
        return this.extractMD_MetadataAsDoc(doc);
    }

    protected String extractMD_Metadata(String md) throws JDOMException, IOException, B3PCatalogException {
        Document extractedDoc = this.extractMD_MetadataAsDoc(md);
        return new XMLOutputter(Format.getPrettyFormat()).outputString(extractedDoc);
    }

    protected Document extractMD_MetadataAsDoc(File mdFile) throws JDOMException, IOException, B3PCatalogException {
        Document doc = DocumentHelper.getMetadataDocument((File)mdFile);
        return this.extractMD_MetadataAsDoc(doc);
    }

    protected String extractMD_Metadata(File mdFile) throws JDOMException, IOException, B3PCatalogException {
        Document extractedDoc = this.extractMD_MetadataAsDoc(mdFile);
        return new XMLOutputter(Format.getPrettyFormat()).outputString(extractedDoc);
    }

    private void addComment(Document doc, String comment) throws B3PCatalogException {
        Element comments = DocumentHelper.getComments((Document)doc);
        if (comments == null) {
            throw new B3PCatalogException("Xml Document is non-metadata xml. This is not allowed.");
        }
        String user = this.getContext().getRequest().getRemoteUser();
        if (user == null) {
            user = this.username;
        }
        Element newComment = new Element("comment", Namespaces.B3P).addContent(Arrays.asList(new Element("username", Namespaces.B3P).setText(user), new Element("dateTime", Namespaces.B3P).setText(DATETIME_FORMAT.format(new Date())), new Element("content", Namespaces.B3P).setText(comment)));
        comments.addContent((Content)newComment);
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getElementChanges() {
        return this.elementChanges;
    }

    public void setElementChanges(String elementChanges) {
        this.elementChanges = elementChanges;
    }

    public String getSectionChange() {
        return this.sectionChange;
    }

    public void setSectionChange(String sectionChange) {
        this.sectionChange = sectionChange;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getExportType() {
        return this.exportType;
    }

    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    public FileBean getImportXml() {
        return this.importXml;
    }

    public void setImportXml(FileBean importXml) {
        this.importXml = importXml;
    }

    public String getSynchronizeData() {
        return this.synchronizeData;
    }

    public void setSynchronizeData(String synchronizeData) {
        this.synchronizeData = synchronizeData;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Boolean getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(Boolean viewMode) {
        this.viewMode = viewMode;
    }

    public Boolean getNewUuid() {
        return this.newUuid;
    }

    public void setNewUuid(Boolean newUuid) {
        this.newUuid = newUuid;
    }
}

