/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import nl.b3p.catalog.B3PCatalogException;
import nl.b3p.catalog.xml.Namespaces;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * Exception performing whole class analysis ignored.
 */
public class DocumentHelper {
    public static final String EMPTY_METADATA = "empty";

    public static String getDocumentString(Document xml) {
        return new XMLOutputter(Format.getPrettyFormat()).outputString(xml);
    }

    public static Document getMetadataDocument(File mdFile) throws IOException, JDOMException, B3PCatalogException {
        if (mdFile == null) {
            throw new B3PCatalogException("Metadata file is null.");
        }
        Document doc = null;
        if (mdFile.exists()) {
            BufferedInputStream inputStream = new BufferedInputStream(FileUtils.openInputStream((File)mdFile));
            doc = new SAXBuilder().build((InputStream)inputStream);
            ((InputStream)inputStream).close();
        } else {
            doc = new Document(new Element("metadata"));
        }
        DocumentHelper.getRoot((Document)doc);
        return doc;
    }

    public static Document getMetadataDocument(String md) throws IOException, JDOMException, B3PCatalogException {
        Document doc = null;
        doc = md == null || StringUtils.isBlank((String)md) || "empty".equals(md) ? new Document(new Element("metadata")) : new SAXBuilder().build((Reader)new StringReader(md));
        DocumentHelper.getRoot((Document)doc);
        return doc;
    }

    public static Element getRoot(Document doc) throws B3PCatalogException {
        boolean rootIs19139;
        if (doc == null) {
            throw new B3PCatalogException("Metadata document is null.");
        }
        Element root = doc.getRootElement();
        boolean rootIsWrapper = root.getName().equals("metadata") && root.getNamespace().equals((Object)Namespace.NO_NAMESPACE);
        boolean bl = rootIs19139 = root.getName().equals("MD_Metadata") && root.getNamespace().equals((Object)Namespaces.GMD);
        if (!rootIsWrapper && !rootIs19139) {
            throw new B3PCatalogException("Root element must be either <metadata/> (no ns) or <MD_Metadata/> (from ns \"http://www.isotc211.org/2005/gmd\"). Root name is: " + root.getName());
        }
        if (!rootIsWrapper && rootIs19139) {
            Element oldRoot = doc.detachRootElement();
            root = new Element("metadata");
            root.setContent((Content)oldRoot);
            doc.setRootElement(root);
        }
        return root;
    }

    public static Element getMD_Metadata(Document doc) throws B3PCatalogException {
        return DocumentHelper.getOrCreateElement((Element)DocumentHelper.getRoot((Document)doc), (String)"MD_Metadata", (Namespace)Namespaces.GMD);
    }

    public static Element getB3Partners(Document doc) throws B3PCatalogException {
        return DocumentHelper.getOrCreateElement((Element)DocumentHelper.getRoot((Document)doc), (String)"B3Partners", (Namespace)Namespaces.B3P);
    }

    public static Element getComments(Document doc) throws B3PCatalogException {
        return DocumentHelper.getOrCreateElement((Element)DocumentHelper.getB3Partners((Document)doc), (String)"comments", (Namespace)Namespaces.B3P);
    }

    public static Element getMetadataPBL(Document doc) throws B3PCatalogException {
        return DocumentHelper.getOrCreateElement((Element)DocumentHelper.getB3Partners((Document)doc), (String)"metadataPBL", (Namespace)Namespaces.PBL);
    }

    public static Element getOrCreateElement(Element parent, String name) throws B3PCatalogException {
        return DocumentHelper.getOrCreateElement((Element)parent, (String)name, (Namespace)Namespace.NO_NAMESPACE);
    }

    public static Element getOrCreateElement(Element parent, String name, Namespace ns) throws B3PCatalogException {
        if (parent == null) {
            throw new B3PCatalogException("Parent element is null when trying to create element with name: " + name);
        }
        Element child = parent.getChild(name, ns);
        if (child == null) {
            child = new Element(name, ns);
            parent.addContent((Content)child);
        }
        return child;
    }
}

