/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.naming.NamingException;
import nl.b3p.catalog.arcgis.ArcSDE10JDBCHelper;
import nl.b3p.catalog.arcgis.ArcSDEJDBCDataset;
import nl.b3p.catalog.arcgis.ArcSDEJDBCHelper;
import nl.b3p.catalog.config.SDERoot;
import nl.b3p.catalog.filetree.Dir;
import nl.b3p.catalog.filetree.DirEntry;
import nl.b3p.catalog.xml.DocumentHelper;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.io.IOUtils;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ArcSDE10JDBCHelper
extends ArcSDEJDBCHelper {
    private static final String TABLE_ITEMS = "gdb_items";
    private static final String TABLE_ITEMRELATIONSHIPS = "gdb_itemrelationships";
    private static final String TYPE_FEATURE_DATASET = "74737149-DCB5-4257-8904-B9724E32A530";
    private static final String TYPE_FEATURE_CLASS = "70737809-852C-4A03-9E22-2CECEA5B9BFA";
    private static final String TYPE_RASTER = "5ED667A3-9CA9-44A2-8029-D95BF23704B9";

    public ArcSDE10JDBCHelper(SDERoot root) {
        super(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dir> getFeatureDatasets(String currentPath) throws NamingException, SQLException {
        Connection c = this.getConnection();
        try {
            String sql = "select i.objectid, i.name from " + this.getTableName(TABLE_ITEMS) + " i where type = ?";
            1 h = new /* Unavailable Anonymous Inner Class!! */;
            List list = (List)new QueryRunner().query(c, sql, (ResultSetHandler)h, new Object[]{TYPE_FEATURE_DATASET});
            return list;
        }
        finally {
            DbUtils.closeQuietly((Connection)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DirEntry> getFeatureClasses(String currentPath, ArcSDEJDBCDataset parent) throws NamingException, SQLException {
        Connection c = this.getConnection();
        try {
            String sql = "select i.objectid, i.name from " + this.getTableName(TABLE_ITEMS) + " i " + "join " + this.getTableName(TABLE_ITEMRELATIONSHIPS) + " r on (r.destid = i.uuid) " + "join " + this.getTableName(TABLE_ITEMS) + " parent_i on (parent_i.uuid = r.originid) " + "where i.type in (?,?) ";
            sql = parent == null ? sql + "and parent_i.path = '\\'" : sql + "and parent_i.objectid = ?";
            2 h = new /* Unavailable Anonymous Inner Class!! */;
            if (parent == null) {
                List list = (List)new QueryRunner().query(c, sql, (ResultSetHandler)h, new Object[]{TYPE_FEATURE_CLASS, TYPE_RASTER});
                return list;
            }
            List list = (List)new QueryRunner().query(c, sql, (ResultSetHandler)h, new Object[]{TYPE_FEATURE_CLASS, TYPE_RASTER, parent.getObjectID()});
            return list;
        }
        finally {
            DbUtils.closeQuietly((Connection)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetadata(ArcSDEJDBCDataset dataset) throws NamingException, SQLException, IOException {
        Connection c = this.getConnection();
        try {
            String sql = "select documentation from " + this.getTableName(TABLE_ITEMS) + " where objectid = ?";
            Clob xml = (Clob)new QueryRunner().query(c, sql, (ResultSetHandler)new ScalarHandler(), new Object[]{dataset.getObjectID()});
            if (xml == null) {
                String string = "empty";
                return string;
            }
            String string = IOUtils.toString((Reader)xml.getCharacterStream());
            return string;
        }
        finally {
            DbUtils.closeQuietly((Connection)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMetadata(ArcSDEJDBCDataset dataset, String metadata) throws Exception {
        Connection c = this.getConnection();
        PreparedStatement ps = null;
        try {
            Document doc = DocumentHelper.getMetadataDocument((String)metadata);
            metadata = new XMLOutputter(Format.getPrettyFormat().setOmitEncoding(true)).outputString(doc);
            String sql = "update " + this.getTableName(TABLE_ITEMS) + " set documentation = ? where objectid = ?";
            ps = c.prepareStatement(sql);
            ps.setCharacterStream(1, (Reader)new StringReader(metadata), metadata.length());
            ps.setObject(2, dataset.getObjectID());
            int rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                throw new Exception("Updating metadata should affect maximum one row; got rows affected count of " + rowsAffected);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(ps);
            DbUtils.closeQuietly((Connection)c);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)ps);
        DbUtils.closeQuietly((Connection)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAbsoluteDatasetName(ArcSDEJDBCDataset dataset) throws Exception {
        Connection c = this.getConnection();
        try {
            String sql = "select name from " + this.getTableName(TABLE_ITEMS) + " where objectid = ?";
            String name = (String)new QueryRunner().query(c, sql, (ResultSetHandler)new ScalarHandler(), new Object[]{dataset.getObjectID()});
            if (dataset.getParent() != null) {
                String parentName = (String)new QueryRunner().query(c, sql, (ResultSetHandler)new ScalarHandler(), new Object[]{dataset.getParent().getObjectID()});
                name = parentName + "/" + name;
            }
            String string = name;
            return string;
        }
        finally {
            DbUtils.closeQuietly((Connection)c);
        }
    }
}

