/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.resolution;

import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.StreamingResolution;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class ExtraHeadersResolution
extends StreamingResolution {
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected Map<String, String> extraHeaders;

    public ExtraHeadersResolution(String contentType, InputStream inputStream) {
        this(contentType, inputStream, null);
    }

    public ExtraHeadersResolution(String contentType, Reader reader) {
        this(contentType, reader, null);
    }

    public ExtraHeadersResolution(String contentType, String string) {
        this(contentType, string, null);
    }

    public ExtraHeadersResolution(String contentType, Document doc) {
        this(contentType, doc, null);
    }

    public ExtraHeadersResolution(String contentType, InputStream inputStream, Map<String, String> extraHeaders) {
        super(contentType, inputStream);
        this.init(extraHeaders);
    }

    public ExtraHeadersResolution(String contentType, Reader reader, Map<String, String> extraHeaders) {
        super(contentType, reader);
        this.init(extraHeaders);
    }

    public ExtraHeadersResolution(String contentType, String string, Map<String, String> extraHeaders) {
        super(contentType, string);
        this.init(extraHeaders);
    }

    public ExtraHeadersResolution(String contentType, Document doc, Map<String, String> extraHeaders) {
        super(contentType, new XMLOutputter().outputString(doc));
        this.init(extraHeaders);
    }

    protected void init(Map<String, String> extraHeaders) {
        this.setCharacterEncoding(DEFAULT_ENCODING);
        this.extraHeaders = extraHeaders;
    }

    protected void applyHeaders(HttpServletResponse response) {
        super.applyHeaders(response);
        if (this.extraHeaders != null) {
            for (Map.Entry entry : this.extraHeaders.entrySet()) {
                response.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

