/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.security;

import java.security.Principal;
import java.util.ArrayList;
import nl.b3p.catalog.security.ConfigServlet;
import nl.b3p.catalog.security.GisPrincipal;
import nl.b3p.commons.security.XmlSecurityDatabase;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.wms.capabilities.ServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.securityfilter.filter.SecurityRequestWrapper;
import org.securityfilter.realm.ExternalAuthenticatedRealm;
import org.securityfilter.realm.FlexibleRealmInterface;

/*
 * Exception performing whole class analysis ignored.
 */
public class GisSecurityRealm
implements FlexibleRealmInterface,
ExternalAuthenticatedRealm {
    private static final Log log = LogFactory.getLog(GisSecurityRealm.class);
    private static final String FORM_USERNAME = "j_username";
    private static final String FORM_PASSWORD = "j_password";
    private static final String FORM_CODE = "j_code";
    private static final String CAPABILITIES_QUERYSTRING = "REQUEST=GetCapabilities&VERSION=1.1.1&SERVICE=WMS";

    public Principal authenticate(SecurityRequestWrapper request) {
        String username = FormUtils.nullIfEmpty((String)request.getParameter("j_username"));
        String password = FormUtils.nullIfEmpty((String)request.getParameter("j_password"));
        String code = FormUtils.nullIfEmpty((String)request.getParameter("j_code"));
        String url = GisSecurityRealm.createCapabilitiesURL((String)code);
        return GisSecurityRealm.authenticateHttp((String)url, (String)username, (String)password, (String)code);
    }

    public Principal getAuthenticatedPrincipal(String username, String password) {
        return this.authenticate(username, password);
    }

    public boolean isUserInRole(Principal principal, String rolename) {
        if (principal == null) {
            return false;
        }
        boolean inRole = ((GisPrincipal)principal).isInRole(rolename);
        if (!inRole) {
            inRole = XmlSecurityDatabase.isUserInRole((String)principal.getName(), (String)rolename);
        }
        return inRole;
    }

    public static String createCapabilitiesURL(String code) {
        String url = ConfigServlet.createPersonalKbUrl((String)code);
        if (url != null) {
            if (url.indexOf(63) == -1) {
                url = url + "?";
            }
            url = url.indexOf(63) == url.length() - 1 ? url + "REQUEST=GetCapabilities&VERSION=1.1.1&SERVICE=WMS" : (url.lastIndexOf(38) == url.length() - 1 ? url + "REQUEST=GetCapabilities&VERSION=1.1.1&SERVICE=WMS" : url + "&REQUEST=GetCapabilities&VERSION=1.1.1&SERVICE=WMS");
        }
        return url;
    }

    protected static GisPrincipal authenticateFake(String username) {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add(ConfigServlet.GEBRUIKERS_ROL);
        roles.add(ConfigServlet.THEMABEHEERDERS_ROL);
        return new GisPrincipal(username, roles);
    }

    public static GisPrincipal authenticateHttp(String location, String username, String password, String code) {
        ServiceProvider sp = null;
        Throwable kbException = null;
        if (sp == null || sp.getAllRoles() == null || sp.getAllRoles().isEmpty()) {
            log.info((Object)"No ServiceProvider found, getting roles with XmlSecurityDatabase realm!");
            if (!XmlSecurityDatabase.booleanAuthenticate((String)username, (String)password)) {
                log.warn((Object)"Can't log in with XmlSecurityDatabase realm nor with WMSurl! Wrong username/password combo?");
                if (kbException != null) {
                    log.error((Object)"Can't log in with WMS url/Kb url", kbException);
                }
                return null;
            }
        }
        if (username == null || username.length() == 0) {
            username = ConfigServlet.ANONYMOUS_USER;
        }
        log.debug((Object)("login: " + username));
        return new GisPrincipal(username, password, code, sp);
    }

    public Principal authenticate(String username, String password) {
        String url = GisSecurityRealm.createCapabilitiesURL(null);
        return GisSecurityRealm.authenticateHttp((String)url, (String)username, (String)password, null);
    }

    public Principal getAuthenticatedPrincipal(String username) {
        return null;
    }
}

