/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import nl.b3p.catalog.arcgis.ArcObjectsInitializer;
import nl.b3p.catalog.arcgis.ArcObjectsLinker;
import nl.b3p.catalog.arcgis.ArcObjectsSynchronizerWorker;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

/*
 * Exception performing whole class analysis ignored.
 */
public class ArcObjectsSynchronizerMain {
    private static Log log;
    public static final String TYPE_FGDB = "fgdb";
    public static final String TYPE_SDE = "sde";
    public static final String TYPE_SDEFILE = "sdefile";

    private static Options buildOptions() {
        Options options = new Options();
        OptionBuilder.withDescription((String)"ArcObjects home directory");
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"home"));
        OptionBuilder.withDescription((String)"fgdb or sde");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"type"));
        OptionBuilder.withDescription((String)"target dataset");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"dataset"));
        OptionBuilder.withDescription((String)"SDE connection file");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"sdefile"));
        OptionBuilder.withDescription((String)"SDE connection string");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"sde"));
        OptionBuilder.withDescription((String)"Read XML metadata document with all elements to synchronise from stdin");
        options.addOption(OptionBuilder.create((String)"stdin"));
        return options;
    }

    private static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(ArcObjectsSynchronizerMain.class.getSimpleName(), options);
        System.err.println("\nTarget dataset format:\ntype fgdb: <path to fgdb dir>/[<feature dataset name>/]<dataset name>\ntype sde: [<feature dataset name>/]<dataset name>");
    }

    public static void main(String[] args) throws Exception {
        Logger root = Logger.getRootLogger();
        root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n"), "System.err"));
        log = LogFactory.getLog(ArcObjectsSynchronizerMain.class);
        Options options = ArcObjectsSynchronizerMain.buildOptions();
        CommandLine cl = null;
        try {
            PosixParser parser = new PosixParser();
            cl = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.printf("%s\n\n", e.getMessage());
            ArcObjectsSynchronizerMain.usage((Options)options);
            System.exit(1);
        }
        try {
            ArcObjectsLinker.link((String)cl.getOptionValue("home"));
            ArcObjectsInitializer.initializeViewLicense();
            ArcObjectsSynchronizerWorker.synchronize((CommandLine)cl);
            log.info((Object)"Completed");
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

