/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.naming.NamingException;
import nl.b3p.catalog.arcgis.ArcSDE9xJDBCHelper;
import nl.b3p.catalog.arcgis.ArcSDEJDBCDataset;
import nl.b3p.catalog.arcgis.ArcSDEJDBCHelper;
import nl.b3p.catalog.config.SDERoot;
import nl.b3p.catalog.filetree.Dir;
import nl.b3p.catalog.filetree.DirEntry;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

/*
 * Exception performing whole class analysis ignored.
 */
public class ArcSDE9xJDBCHelper
extends ArcSDEJDBCHelper {
    private static final String ENCODING = "UTF-8";
    private static final String TABLE_FEATUREDATASET = "gdb_featuredataset";
    private static final String TABLE_OBJECTCLASSES = "gdb_objectclasses";
    private static final String TABLE_USERMETADATA = "gdb_usermetadata";
    private static final String TABLE_FEATURECLASSES = "gdb_featureclasses";
    private static final String TABLE_RASTERCATALOGS = "gdb_rastercatalogs";

    public ArcSDE9xJDBCHelper(SDERoot root) {
        super(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dir> getFeatureDatasets(String currentPath) throws NamingException, SQLException {
        Connection c = this.getConnection();
        try {
            List list = (List)new QueryRunner().query(c, "select databasename, owner, name from " + this.getTableName("gdb_featuredataset"), (ResultSetHandler)new /* Unavailable Anonymous Inner Class!! */);
            return list;
        }
        finally {
            DbUtils.closeQuietly((Connection)c);
        }
    }

    private static String databaseNameSQL(ArcSDEJDBCDataset dataset) {
        return ArcSDE9xJDBCHelper.databaseNameSQL((ArcSDEJDBCDataset)dataset, null);
    }

    private static String databaseNameSQL(ArcSDEJDBCDataset dataset, String alias) {
        String string = alias = alias != null ? alias + "." : "";
        if (dataset.getDatabaseName() != null) {
            return " and " + alias + "databasename = ?";
        }
        return " and " + alias + "databasename is null";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DirEntry> getFeatureClasses(String currentPath, ArcSDEJDBCDataset parent) throws NamingException, SQLException {
        Connection c = this.getConnection();
        try {
            2 h = new /* Unavailable Anonymous Inner Class!! */;
            String sql = "select oc.databasename, oc.owner, oc.name from " + this.getTableName("gdb_objectclasses") + " oc ";
            if (parent == null) {
                sql = sql + "where datasetid is null or datasetid not in (select id from " + this.getTableName("gdb_featuredataset") + ")";
            } else {
                sql = sql + "join " + this.getTableName("gdb_featuredataset") + " ds on (ds.id = oc.datasetid) where ds.owner = ? and ds.name = ?";
                sql = sql + ArcSDE9xJDBCHelper.databaseNameSQL((ArcSDEJDBCDataset)parent, (String)"ds");
            }
            List l = parent != null ? (parent.getDatabaseName() != null ? (List)new QueryRunner().query(c, sql, (ResultSetHandler)h, new Object[]{parent.getOwner(), parent.getName(), parent.getDatabaseName()}) : (List)new QueryRunner().query(c, sql, (ResultSetHandler)h, new Object[]{parent.getOwner(), parent.getName()})) : (List)new QueryRunner().query(c, sql, (ResultSetHandler)h);
            List list = l;
            return list;
        }
        finally {
            DbUtils.closeQuietly((Connection)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetadata(ArcSDEJDBCDataset dataset) throws NamingException, SQLException, IOException {
        Connection c = this.getConnection();
        try {
            String sql = "select xml from " + this.getTableName("gdb_usermetadata") + " where name = ? and owner = ?";
            sql = sql + ArcSDE9xJDBCHelper.databaseNameSQL((ArcSDEJDBCDataset)dataset);
            3 h = new /* Unavailable Anonymous Inner Class!! */;
            if (dataset.getDatabaseName() != null) {
                String string = (String)new QueryRunner().query(c, sql, (ResultSetHandler)h, new Object[]{dataset.getName(), dataset.getOwner(), dataset.getDatabaseName()});
                return string;
            }
            String string = (String)new QueryRunner().query(c, sql, (ResultSetHandler)h, new Object[]{dataset.getName(), dataset.getOwner()});
            return string;
        }
        finally {
            DbUtils.closeQuietly((Connection)c);
        }
    }

    public void saveMetadata(ArcSDEJDBCDataset dataset, String metadata) throws Exception {
        Connection c = this.getConnection();
        PreparedStatement ps = null;
        try {
            c.setAutoCommit(false);
            String sql = "update " + this.getTableName("gdb_usermetadata") + " set xml = ? where name = ? and owner = ?";
            sql = sql + ArcSDE9xJDBCHelper.databaseNameSQL((ArcSDEJDBCDataset)dataset);
            ps = c.prepareStatement(sql);
            byte[] xml = metadata.getBytes("UTF-8");
            ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(xml), xml.length);
            ps.setString(2, dataset.getName());
            ps.setString(3, dataset.getOwner());
            if (dataset.getDatabaseName() != null) {
                ps.setString(4, dataset.getDatabaseName());
            }
            int rowsAffected = ps.executeUpdate();
            ps.close();
            ps = null;
            if (rowsAffected > 1) {
                throw new Exception("Updating metadata should affect maximum one row; got rows affected count of " + rowsAffected);
            }
            if (rowsAffected == 0) {
                QueryRunner runner = new QueryRunner();
                Object id = runner.query(c, "select coalesce(max(id)+1,1) from " + this.getTableName("gdb_usermetadata"), (ResultSetHandler)new ScalarHandler());
                Integer datasetType = this.determineDatasetType(c, dataset);
                ps = c.prepareStatement("insert into " + this.getTableName("gdb_usermetadata") + " (id, databasename, owner, name, datasettype, xml) values(?,?,?,?,?,?)");
                ps.setObject(1, id);
                ps.setObject(2, dataset.getDatabaseName());
                ps.setString(3, dataset.getOwner());
                ps.setString(4, dataset.getName());
                ps.setObject(5, datasetType);
                ps.setBinaryStream(6, (InputStream)new ByteArrayInputStream(xml), xml.length);
                ps.executeUpdate();
                ps.close();
                ps = null;
            }
            DbUtils.commitAndClose((Connection)c);
        }
        catch (Exception e) {
            try {
                DbUtils.rollbackAndCloseQuietly((Connection)c);
                throw e;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(ps);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)ps);
    }

    public String getAbsoluteDatasetName(ArcSDEJDBCDataset dataset) throws Exception {
        String name = dataset.getFullName();
        if (dataset.getParent() != null) {
            name = dataset.getParent().getFullName() + "/" + name;
        }
        return name;
    }

    private Integer determineDatasetType(Connection c, ArcSDEJDBCDataset dataset) throws Exception {
        Object[] objectArray;
        QueryRunner runner = new QueryRunner();
        Integer datasetType = null;
        if (dataset.getDatabaseName() != null) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = dataset.getOwner();
            objectArray2[1] = dataset.getName();
            objectArray = objectArray2;
            objectArray2[2] = dataset.getDatabaseName();
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = dataset.getOwner();
            objectArray = objectArray3;
            objectArray3[1] = dataset.getName();
        }
        Object[] datasetParams = objectArray;
        Object isDataset = runner.query(c, "select 1 from " + this.getTableName("gdb_featuredataset") + " where owner = ? and name = ?" + ArcSDE9xJDBCHelper.databaseNameSQL((ArcSDEJDBCDataset)dataset), (ResultSetHandler)new ScalarHandler(), datasetParams);
        if (isDataset != null) {
            return 4;
        }
        Integer featureType = (Integer)runner.query(c, "select fc.FeatureType from " + this.getTableName("gdb_objectclasses") + " oc " + "join " + this.getTableName("gdb_featureclasses") + " fc on (fc.ObjectClassId = oc.ID) " + "where oc.Owner = ? and oc.Name = ?" + ArcSDE9xJDBCHelper.databaseNameSQL((ArcSDEJDBCDataset)dataset, (String)"oc"), (ResultSetHandler)new ScalarHandler(), datasetParams);
        if (featureType == null) {
            throw new Exception("Cannot find row in gdb_featureclasses table for dataset " + dataset.getFullName());
        }
        if (featureType == 1) {
            datasetType = 5;
        } else if (featureType == 14) {
            Integer isRasterDataset = (Integer)runner.query(c, "select rc.isRasterDataset from " + this.getTableName("gdb_rastercatalogs") + " rc " + "join " + this.getTableName("gdb_objectclasses") + " oc on (rc.ObjectClassID = oc.ID) " + "where oc.Owner = ? and oc.Name = ?" + ArcSDE9xJDBCHelper.databaseNameSQL((ArcSDEJDBCDataset)dataset, (String)"oc"), (ResultSetHandler)new ScalarHandler(), datasetParams);
            if (isRasterDataset == null) {
                throw new Exception("Cannot find row in gdb_rastercatalogs table for dataset " + dataset.getFullName());
            }
            datasetType = isRasterDataset == 1 ? 12 : 16;
        } else {
            throw new Exception("Don't know the dataset type for feature type " + featureType + " for dataset " + dataset.getFullName());
        }
        return datasetType;
    }
}

