/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.stripes;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import nl.b3p.catalog.B3PCatalogException;
import nl.b3p.catalog.Roles;
import nl.b3p.catalog.resolution.HtmlErrorResolution;
import nl.b3p.catalog.stripes.DefaultAction;
import nl.b3p.catalog.stripes.OrganisationsAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdminAction
extends DefaultAction {
    private static final Log log = LogFactory.getLog(AdminAction.class);
    private String organisations;

    @DefaultHandler
    public Resolution loadOrganisations() {
        try {
            if (!Roles.isAdmin((ServletContext)this.getContext().getServletContext(), (HttpServletRequest)this.getContext().getRequest())) {
                throw new B3PCatalogException("User is not an admin");
            }
            this.organisations = OrganisationsAction.getOrganisations();
        }
        catch (Exception ex) {
            log.error((Object)"Cannot read organisations config file", (Throwable)ex);
            this.organisations = "";
        }
        return new ForwardResolution("/WEB-INF/jsp/main/organisations.jsp");
    }

    public Resolution saveOrganisations() {
        try {
            if (!Roles.isAdmin((ServletContext)this.getContext().getServletContext(), (HttpServletRequest)this.getContext().getRequest())) {
                throw new B3PCatalogException("User is not an admin");
            }
            OrganisationsAction.setOrganisations((String)this.organisations);
            return new StreamingResolution("text/plain", "success");
        }
        catch (Exception ex) {
            String message = "Fout bij opslaan organisaties";
            log.error((Object)message, (Throwable)ex);
            return new HtmlErrorResolution(message, ex);
        }
    }

    public String getOrganisations() {
        return this.organisations;
    }

    public void setOrganisations(String organisations) {
        this.organisations = organisations;
    }
}

