/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.stripes;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import nl.b3p.catalog.config.CatalogAppConfig;
import nl.b3p.catalog.stripes.DefaultAction;
import nl.b3p.catalog.xml.XPathHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class OrganisationsAction
extends DefaultAction {
    private static final Log log = LogFactory.getLog(OrganisationsAction.class);
    private static final String ENCODING = "UTF-8";
    private static final String DEFAULT_ORGANISATIONS_FILE = "organisations.json";

    @DefaultHandler
    public Resolution main() {
        String organisations = "organisations = " + OrganisationsAction.getOrganisations() + ";";
        return new StreamingResolution("text/javascript; charset=UTF-8", organisations);
    }

    public Resolution json() {
        String organisations = OrganisationsAction.getOrganisations();
        return new StreamingResolution("text/plain; charset=UTF-8", organisations);
    }

    public static JSONObject getOrganisationsJson() throws IOException, JSONException {
        String jsonFileContents = FileUtils.readFileToString((File)OrganisationsAction.getOrganisationsConfigFile(), (String)"UTF-8");
        return new JSONObject(jsonFileContents);
    }

    public static String getOrganisations() {
        try {
            JSONObject jsonObj = OrganisationsAction.getOrganisationsJson();
            return jsonObj.toString(4);
        }
        catch (Exception ex) {
            log.error((Object)("Cannot read organisations config file: " + ex.getMessage()));
            return "{\"error\": \"" + ex.getMessage() + "\"}";
        }
    }

    public static void setOrganisations(String organisations) throws IOException, JSONException {
        OrganisationsAction.setOrganisationsJson((JSONObject)new JSONObject(organisations));
    }

    public static void setOrganisationsJson(JSONObject organisations) throws IOException, JSONException {
        String OrganisationsString = organisations.toString(4);
        FileUtils.writeStringToFile((File)OrganisationsAction.getOrganisationsConfigFile(), (String)OrganisationsString, (String)"UTF-8");
    }

    private static File getOrganisationsConfigFile() {
        File f;
        CatalogAppConfig cfg = CatalogAppConfig.getConfig();
        String ojf = cfg.getOrganizationsJsonFile();
        if (ojf == null) {
            ojf = "organisations.json";
        }
        if (!(f = new File(ojf)).isAbsolute()) {
            f = new File(cfg.getConfigFilePath(), cfg.getOrganizationsJsonFile());
        }
        return f;
    }

    public static void saveOrganisations(Document md) throws JDOMException, JSONException, IOException {
        Element e4;
        Element e3;
        Element e2;
        Document mdCopy = new Document((Element)md.getRootElement().clone());
        ArrayList<Document> orgNodes = new ArrayList<Document>();
        Element e1 = XPathHelper.selectSingleElement((Object)mdCopy, (String)"/*/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:pointOfContact/gmd:CI_ResponsibleParty");
        if (e1 != null) {
            e1.detach();
            orgNodes.add(new Document(e1));
        }
        if ((e2 = XPathHelper.selectSingleElement((Object)mdCopy, (String)"/*/gmd:MD_Metadata/gmd:dataQualityInfo/gmd:DQ_DataQuality/gmd:lineage/gmd:LI_Lineage/gmd:source/gmd:LI_Source/gmd:sourceStep/gmd:LI_ProcessStep/gmd:processor/gmd:CI_ResponsibleParty")) != null) {
            e2.detach();
            orgNodes.add(new Document(e2));
        }
        if ((e3 = XPathHelper.selectSingleElement((Object)mdCopy, (String)"/*/gmd:MD_Metadata/gmd:contact/gmd:CI_ResponsibleParty")) != null) {
            e3.detach();
            orgNodes.add(new Document(e3));
        }
        if ((e4 = XPathHelper.selectSingleElement((Object)mdCopy, (String)"/*/gmd:MD_Metadata/gmd:identificationInfo/srv:SV_ServiceIdentification/gmd:pointOfContact/gmd:CI_ResponsibleParty")) != null) {
            e4.detach();
            orgNodes.add(new Document(e4));
        }
        JSONObject configOrgs = OrganisationsAction.getOrganisationsJson();
        HashMap<String, JSONObject> checkedOrgs = new HashMap<String, JSONObject>();
        for (Document d : orgNodes) {
            Element e = XPathHelper.selectSingleElement((Object)d, (String)"/gmd:CI_ResponsibleParty/gmd:organisationName/gco:CharacterString");
            if (e == null || e.getTextTrim().isEmpty()) continue;
            String name = e.getTextTrim();
            JSONObject mdOrg = OrganisationsAction.convertElement2Json((Document)d);
            List devis = OrganisationsAction.findDeviations((JSONObject)mdOrg, (JSONObject)OrganisationsAction.getConfigOrganisation((JSONObject)configOrgs, (String)name));
            if (devis == null || devis.isEmpty()) continue;
            int loopnum = 1;
            String loopname = name;
            while (checkedOrgs.containsKey(loopname)) {
                loopname = name.concat(Integer.toString(loopnum));
                ++loopnum;
            }
            checkedOrgs.put(loopname, mdOrg);
        }
        for (String name : checkedOrgs.keySet()) {
            JSONObject checkedOrg = (JSONObject)checkedOrgs.get(name);
            configOrgs = OrganisationsAction.mergeOrganisation((JSONObject)configOrgs, (String)name, (JSONObject)checkedOrg);
        }
        OrganisationsAction.setOrganisationsJson((JSONObject)configOrgs);
    }

    private static List findDeviations(JSONObject o1, JSONObject o2) throws JSONException {
        ArrayList<String> deviList = new ArrayList<String>();
        if (o1 == null) {
            return null;
        }
        if (o2 == null) {
            Iterator o1it = o1.keys();
            while (o1it.hasNext()) {
                String label = (String)o1it.next();
                if (label.equals("contacts")) {
                    JSONObject contacts1 = o1.optJSONObject(label);
                    if (contacts1 == null) continue;
                    Iterator contacts1it = contacts1.keys();
                    while (contacts1it.hasNext()) {
                        String sublabel = (String)contacts1it.next();
                        String value1 = contacts1.optString(sublabel);
                        if (value1.isEmpty()) continue;
                        deviList.add(label + "_" + sublabel);
                    }
                    continue;
                }
                String value1 = o1.optString(label);
                if (value1.isEmpty()) continue;
                deviList.add(label);
            }
        } else {
            Iterator o1it = o1.keys();
            while (o1it.hasNext()) {
                String value2;
                String label = (String)o1it.next();
                if (label.equals("contacts")) {
                    JSONObject contacts1 = o1.optJSONObject(label);
                    JSONObject contacts2 = o2.optJSONObject(label);
                    if (contacts1 == null) continue;
                    if (contacts2 == null) {
                        deviList.add(label);
                        continue;
                    }
                    Iterator contacts1it = contacts1.keys();
                    while (contacts1it.hasNext()) {
                        String value22;
                        String sublabel = (String)contacts1it.next();
                        String value1 = contacts1.optString(sublabel);
                        if (value1.equals(value22 = contacts2.optString(sublabel))) continue;
                        deviList.add(label + "_" + sublabel);
                    }
                    continue;
                }
                String value1 = o1.optString(label);
                if (value1.equals(value2 = o2.optString(label))) continue;
                deviList.add(label);
            }
        }
        return deviList;
    }

    private static JSONObject convertElement2Json(Document d) throws JDOMException, JSONException {
        JSONObject orgJson = new JSONObject();
        Element e = XPathHelper.selectSingleElement((Object)d, (String)"/gmd:CI_ResponsibleParty/gmd:contactInfo/gmd:CI_Contact/gmd:phone/gmd:CI_Telephone/gmd:voice/gco:CharacterString");
        if (e != null) {
            orgJson.putOpt("voice", (Object)e.getTextTrim());
        }
        if ((e = XPathHelper.selectSingleElement((Object)d, (String)"/gmd:CI_ResponsibleParty/gmd:contactInfo/gmd:CI_Contact/gmd:onlineResource/gmd:CI_OnlineResource/gmd:linkage/gmd:URL")) != null) {
            orgJson.putOpt("url", (Object)e.getTextTrim());
        }
        if ((e = XPathHelper.selectSingleElement((Object)d, (String)"/gmd:CI_ResponsibleParty/gmd:contactInfo/gmd:CI_Contact/gmd:address/gmd:CI_Address/gmd:deliveryPoint/gco:CharacterString")) != null) {
            orgJson.putOpt("address", (Object)e.getTextTrim());
        }
        if ((e = XPathHelper.selectSingleElement((Object)d, (String)"/gmd:CI_ResponsibleParty/gmd:contactInfo/gmd:CI_Contact/gmd:address/gmd:CI_Address/gmd:city/gco:CharacterString")) != null) {
            orgJson.putOpt("city", (Object)e.getTextTrim());
        }
        if ((e = XPathHelper.selectSingleElement((Object)d, (String)"/gmd:CI_ResponsibleParty/gmd:contactInfo/gmd:CI_Contact/gmd:address/gmd:CI_Address/gmd:administrativeArea/gco:CharacterString")) != null) {
            orgJson.putOpt("state", (Object)e.getTextTrim());
        }
        if ((e = XPathHelper.selectSingleElement((Object)d, (String)"/gmd:CI_ResponsibleParty/gmd:contactInfo/gmd:CI_Contact/gmd:address/gmd:CI_Address/gmd:postalCode/gco:CharacterString")) != null) {
            orgJson.putOpt("postalCode", (Object)e.getTextTrim());
        }
        if ((e = XPathHelper.selectSingleElement((Object)d, (String)"/gmd:CI_ResponsibleParty/gmd:contactInfo/gmd:CI_Contact/gmd:address/gmd:CI_Address/gmd:country/gco:CharacterString")) != null) {
            orgJson.putOpt("country", (Object)e.getTextTrim());
        }
        e = XPathHelper.selectSingleElement((Object)d, (String)"/gmd:CI_ResponsibleParty/gmd:contactInfo/gmd:CI_Contact/gmd:address/gmd:CI_Address/gmd:electronicMailAddress/gco:CharacterString");
        String email = null;
        if (e != null) {
            email = e.getTextTrim();
        }
        if ((e = XPathHelper.selectSingleElement((Object)d, (String)"/gmd:CI_ResponsibleParty/gmd:individualName/gco:CharacterString")) != null && !e.getTextTrim().isEmpty() && email != null) {
            JSONObject contactJson = new JSONObject();
            JSONObject emailJson = new JSONObject();
            emailJson.putOpt("email", (Object)email);
            contactJson.putOpt(e.getTextTrim(), (Object)emailJson);
            orgJson.putOpt("contacts", (Object)contactJson);
        } else {
            orgJson.putOpt("email", (Object)email);
        }
        return orgJson;
    }

    private static JSONObject getConfigOrganisation(JSONObject configOrgs, String mdOrgName) throws JSONException, IOException {
        if (configOrgs.has(mdOrgName)) {
            return (JSONObject)configOrgs.get(mdOrgName);
        }
        return null;
    }

    private static JSONObject mergeOrganisation(JSONObject configOrgs, String mdOrgName, JSONObject mdOrg) throws JSONException, IOException {
        if (configOrgs.has(mdOrgName)) {
            JSONObject mdContacts;
            JSONObject configOrg = configOrgs.optJSONObject(mdOrgName);
            JSONObject configContacts = configOrg.optJSONObject("contacts");
            if (configContacts == null) {
                configContacts = new JSONObject();
            }
            if ((mdContacts = mdOrg.optJSONObject("contacts")) != null) {
                Iterator mdContactsKeys = mdContacts.keys();
                while (mdContactsKeys.hasNext()) {
                    String mdContactName = (String)mdContactsKeys.next();
                    JSONObject mdContact = mdContacts.optJSONObject(mdContactName);
                    configContacts.put(mdContactName, (Object)mdContact);
                }
            }
            mdOrg.put("contacts", (Object)configContacts);
        }
        configOrgs.put(mdOrgName, (Object)mdOrg);
        return configOrgs;
    }
}

