/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.xml;

import nl.b3p.catalog.xml.Namespaces;
import nl.b3p.catalog.xml.XPathHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * Exception performing whole class analysis ignored.
 */
public class ShapefileSynchronizer {
    private static final Log log = LogFactory.getLog(ShapefileSynchronizer.class);

    public static void synchronizeFromLocalAccessJSON(Document doc, String json) throws JDOMException, JSONException {
        XPathHelper.applyXPathValuePair((Object)doc, (String)"/*/gmd:MD_Metadata/gmd:distributionInfo/gmd:MD_Distribution/gmd:distributionFormat[1]/gmd:MD_Format/gmd:name/gco:CharacterString", (String)"ESRI Shapefile");
        XPathHelper.applyXPathValuePair((Object)doc, (String)"/*/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:spatialRepresentationType/gmd:MD_SpatialRepresentationTypeCode", (String)"vector");
        JSONObject md = new JSONObject(json);
        if (md.has("title")) {
            String title = md.getString("title");
            XPathHelper.applyXPathValuePair((Object)doc, (String)"/*/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:title/gco:CharacterString", (String)title);
            XPathHelper.applyXPathValuePair((Object)doc, (String)"/*/gfc:FC_FeatureCatalogue/gmx:name/gco:CharacterString", (String)title);
        }
        double minX = md.getDouble("minX");
        double minY = md.getDouble("minY");
        double maxX = md.getDouble("maxX");
        double maxY = md.getDouble("maxY");
        String prj = md.optString("prj");
        if (prj != null) {
            try {
                CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)prj);
                CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:4326");
                ReferencedEnvelope envelope = new ReferencedEnvelope(minX, maxX, minY, maxY, sourceCRS);
                log.debug((Object)("Transforming shapefile envelope " + envelope.toString()));
                envelope = envelope.transform(targetCRS, true, 50);
                log.debug((Object)("Transformed shapefile envelope " + envelope.toString()));
                minX = envelope.getMinimum(1);
                minY = envelope.getMinimum(0);
                maxX = envelope.getMaximum(1);
                maxY = envelope.getMaximum(0);
                Integer epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)sourceCRS, (boolean)true);
                if (epsgCode != null) {
                    XPathHelper.applyXPathValuePair((Object)doc, (String)"/*/gmd:MD_Metadata/gmd:referenceSystemInfo/gmd:MD_ReferenceSystem/gmd:referenceSystemIdentifier/gmd:RS_Identifier/gmd:codeSpace/gco:CharacterString", (String)"EPSG");
                    XPathHelper.applyXPathValuePair((Object)doc, (String)"/*/gmd:MD_Metadata/gmd:referenceSystemInfo/gmd:MD_ReferenceSystem/gmd:referenceSystemIdentifier/gmd:RS_Identifier/gmd:code/gco:CharacterString", (String)("" + epsgCode));
                    log.debug((Object)String.format("looked up EPSG code %d for WKT string %s", epsgCode, prj));
                } else {
                    log.info((Object)String.format("Failed to lookup EPSG code for WKT string %s", prj));
                }
            }
            catch (Exception e) {
                log.error((Object)("Fout transformeren bbox shapefile van projectie string " + prj), (Throwable)e);
            }
        }
        XPathHelper.applyXPathValuePair((Object)doc, (String)"/*/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/gmd:westBoundLongitude/gco:Decimal", (String)("" + minX));
        XPathHelper.applyXPathValuePair((Object)doc, (String)"/*//gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/gmd:eastBoundLongitude/gco:Decimal", (String)("" + maxX));
        XPathHelper.applyXPathValuePair((Object)doc, (String)"/*/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/gmd:southBoundLatitude/gco:Decimal", (String)("" + minY));
        XPathHelper.applyXPathValuePair((Object)doc, (String)"/*/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/gmd:northBoundLatitude/gco:Decimal", (String)("" + maxY));
        if (md.has("dbf")) {
            JSONArray fields = md.getJSONObject("dbf").getJSONArray("fields");
            Element gfc_FC_FeatureCatalogue = XPathHelper.selectSingleElement((Object)doc, (String)"/*/gfc:FC_FeatureCatalogue");
            if (gfc_FC_FeatureCatalogue == null) {
                gfc_FC_FeatureCatalogue = new Element("FC_FeatureCatalogue", Namespaces.GFC);
                doc.getRootElement().addContent((Content)gfc_FC_FeatureCatalogue);
            } else {
                gfc_FC_FeatureCatalogue.removeChildren("featureType", Namespaces.GFC);
            }
            Element gfc_featureType = new Element("featureType", Namespaces.GFC);
            Element gfc_FC_FeatureType = new Element("FC_FeatureType", Namespaces.GFC);
            gfc_featureType.addContent((Content)gfc_FC_FeatureType);
            gfc_FC_FeatureCatalogue.addContent((Content)gfc_featureType);
            ShapefileSynchronizer.addAttribute((Element)gfc_FC_FeatureType, (String)"SHAPE", (String)md.getString("type"));
            for (int i = 0; i < fields.length(); ++i) {
                JSONObject field = fields.getJSONObject(i);
                String name = field.getString("name");
                String type = field.getString("class");
                if (type.startsWith("java.lang.")) {
                    type = type.substring("java.lang.".length());
                }
                ShapefileSynchronizer.addAttribute((Element)gfc_FC_FeatureType, (String)name, (String)type);
            }
        }
    }

    public static void addAttribute(Element gfc_FC_FeatureType, String name, String type) {
        Element gfc_carrierOfCharacteristics = new Element("carrierOfCharacteristics", Namespaces.GFC);
        Element gfc_FC_FeatureAttribute = new Element("FC_FeatureAttribute", Namespaces.GFC);
        Element gfc_memberName = new Element("memberName", Namespaces.GFC);
        Element field_gco_LocalName = new Element("LocalName", Namespaces.GCO);
        field_gco_LocalName.setText(name);
        gfc_memberName.addContent((Content)field_gco_LocalName);
        gfc_FC_FeatureAttribute.addContent((Content)gfc_memberName);
        Element gfc_valueType = new Element("valueType", Namespaces.GFC);
        Element gco_TypeName = new Element("TypeName", Namespaces.GCO);
        Element gco_aName = new Element("aName", Namespaces.GCO);
        Element gco_CharacterString = new Element("CharacterString", Namespaces.GCO);
        gco_CharacterString.setText(type);
        gco_aName.addContent((Content)gco_CharacterString);
        gco_TypeName.addContent((Content)gco_aName);
        gfc_valueType.addContent((Content)gco_TypeName);
        gfc_FC_FeatureAttribute.addContent((Content)gfc_valueType);
        gfc_carrierOfCharacteristics.addContent((Content)gfc_FC_FeatureAttribute);
        gfc_FC_FeatureType.addContent((Content)gfc_carrierOfCharacteristics);
    }
}

