/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import com.esri.arcgis.geodatabase.FeatureClass;
import com.esri.arcgis.geodatabase.IDataset;
import com.esri.arcgis.geodatabase.IFeatureClass;
import com.esri.arcgis.geodatabase.IField;
import com.esri.arcgis.geodatabase.IFields;
import com.esri.arcgis.geodatabase.IGeoDataset;
import com.esri.arcgis.geodatabase.IMetadata;
import com.esri.arcgis.geodatabase.IObjectClass;
import com.esri.arcgis.geodatabase.Workspace;
import com.esri.arcgis.geodatabase.XmlPropertySet;
import com.esri.arcgis.geometry.IEnvelopeGEN;
import com.esri.arcgis.geometry.IGeographicCoordinateSystem;
import com.esri.arcgis.geometry.IPoint;
import com.esri.arcgis.geometry.ISpatialReference;
import com.esri.arcgis.geometry.SpatialReferenceEnvironment;
import com.esri.arcgis.system.IName;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import nl.b3p.catalog.B3PCatalogException;
import nl.b3p.catalog.arcgis.DatasetHelper;
import nl.b3p.catalog.arcgis.IFeatureClassList;
import nl.b3p.catalog.xml.Namespaces;
import nl.b3p.catalog.xml.XPathHelper;
import nl.b3p.catalog.xml.mdeXml2Html;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class ArcGISSynchronizer {
    private static final Log log = LogFactory.getLog(ArcGISSynchronizer.class);
    public static final String FORMAT_NAME_FGDB = "ESRI file geodatabase (FGDB)";
    public static final String FORMAT_NAME_SDE = "ESRI ArcSDE";
    public static final String FORMAT_NAME_SHAPE = "ESRI shapefile";

    private static Document getMetadata(IDataset ds) throws Exception {
        IName name = DatasetHelper.getIDataset((IDataset)ds).getFullName();
        IMetadata im = (IMetadata)name;
        XmlPropertySet xmlPropertySet = (XmlPropertySet)im.getMetadata();
        String xml = xmlPropertySet.getXml("/");
        return new SAXBuilder().build((Reader)new StringReader(xml));
    }

    public static Document synchronize(IDataset dataset, String formatName) throws Exception {
        Document xml = ArcGISSynchronizer.getMetadata((IDataset)dataset);
        ArcGISSynchronizer.synchronize((Document)xml, (Object)dataset, (String)formatName);
        return xml;
    }

    public static void synchronize(Document doc, Object ds, String formatName) throws Exception {
        IDataset dataset = (IDataset)ds;
        Workspace workspace = new Workspace((Object)dataset.getWorkspace());
        XPathHelper.applyXPathValuePair((Object)doc, (String)"/*/gmd:MD_Metadata/gmd:distributionInfo/gmd:MD_Distribution/gmd:distributionFormat[1]/gmd:MD_Format/gmd:name/gco:CharacterString", (String)formatName);
        String version = "Onbekend";
        if (!"ESRI shapefile".equals(formatName)) {
            XPathHelper.applyXPathValuePair((Object)doc, (String)"/*/gmd:MD_Metadata/gmd:distributionInfo/gmd:MD_Distribution/gmd:distributionFormat[1]/gmd:MD_Format/gmd:version/gco:CharacterString", (String)(workspace.getMajorVersion() + "." + workspace.getMinorVersion()));
        }
        XPathHelper.applyXPathValuePair((Object)doc, (String)"/*/gmd:MD_Metadata/gmd:distributionInfo/gmd:MD_Distribution/gmd:distributionFormat[1]/gmd:MD_Format/gmd:version/gco:CharacterString", (String)version);
        ArcGISSynchronizer.sync((Document)doc, (IDataset)dataset);
    }

    private static void sync(Document xmlDoc, IDataset dataset) throws IOException, B3PCatalogException, JDOMException {
        dataset = DatasetHelper.getIDataset((IDataset)dataset);
        if (mdeXml2Html.getXSLParam((String)"synchroniseDC_init").booleanValue()) {
            Element dcTitle = XPathHelper.selectSingleElement((Object)xmlDoc, (String)"/metadata/b3p:B3Partners/pbl:metadataPBL/dc:title");
            if (dcTitle.getText().isEmpty()) {
                XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:title/gco:CharacterString", (String)dataset.getBrowseName());
            }
        } else {
            Element dsTitle = XPathHelper.selectSingleElement((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:title/gco:CharacterString");
            if (dsTitle.getText().isEmpty()) {
                XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:title/gco:CharacterString", (String)dataset.getBrowseName());
            }
        }
        if (dataset instanceof IObjectClass) {
            XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:alternateTitle/gco:CharacterString", (String)((IObjectClass)dataset).getAliasName());
        }
        XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:spatialRepresentationType/gmd:MD_SpatialRepresentationTypeCode", (String)ArcGISSynchronizer.getSpatialRepresentation((IDataset)dataset));
        if (dataset instanceof IGeoDataset) {
            IGeoDataset geoDataset = (IGeoDataset)dataset;
            IEnvelopeGEN envelope = (IEnvelopeGEN)geoDataset.getExtent();
            IPoint ll = envelope.getLowerLeft();
            IPoint ur = envelope.getUpperRight();
            SpatialReferenceEnvironment refEnv = new SpatialReferenceEnvironment();
            IGeographicCoordinateSystem wgs84 = refEnv.createGeographicCoordinateSystem(4326);
            ll.project((ISpatialReference)wgs84);
            ur.project((ISpatialReference)wgs84);
            try {
                XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/gmd:westBoundLongitude/gco:Decimal", (String)("" + ll.getX()), (boolean)true);
                XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*//gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/gmd:eastBoundLongitude/gco:Decimal", (String)("" + ur.getX()), (boolean)true);
                XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/gmd:southBoundLatitude/gco:Decimal", (String)("" + ll.getY()), (boolean)true);
                XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:extent/gmd:EX_Extent/gmd:geographicElement/gmd:EX_GeographicBoundingBox/gmd:northBoundLatitude/gco:Decimal", (String)("" + ur.getY()), (boolean)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ISpatialReference spatialRef = geoDataset.getSpatialReference();
            XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:referenceSystemInfo/gmd:MD_ReferenceSystem/gmd:referenceSystemIdentifier/gmd:RS_Identifier/gmd:codeSpace/gco:CharacterString", (String)"EPSG");
            XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:referenceSystemInfo/gmd:MD_ReferenceSystem/gmd:referenceSystemIdentifier/gmd:RS_Identifier/gmd:code/gco:CharacterString", (String)("" + spatialRef.getFactoryCode()));
        }
        ArcGISSynchronizer.syncFeatureCatalog((Document)xmlDoc, (IDataset)dataset);
    }

    private static void syncFeatureCatalog(Document xmlDoc, IDataset dataset) throws JDOMException, IOException {
        Element gfc_FC_FeatureCatalogue = XPathHelper.selectSingleElement((Object)xmlDoc, (String)"/*/gfc:FC_FeatureCatalogue");
        if (gfc_FC_FeatureCatalogue == null) {
            gfc_FC_FeatureCatalogue = new Element("FC_FeatureCatalogue", Namespaces.GFC);
            xmlDoc.getRootElement().addContent((Content)gfc_FC_FeatureCatalogue);
        } else {
            gfc_FC_FeatureCatalogue.removeChildren("featureType", Namespaces.GFC);
        }
        XPathHelper.applyXPathValuePair((Object)xmlDoc, (String)"/*/gfc:FC_FeatureCatalogue/gmx:name/gco:CharacterString", (String)dataset.getBrowseName());
        try {
            for (IFeatureClass iFeatureClass : new IFeatureClassList(dataset)) {
                FeatureClass featureClass = new FeatureClass((Object)iFeatureClass);
                Element gfc_featureType = new Element("featureType", Namespaces.GFC);
                Element gfc_FC_FeatureType = new Element("FC_FeatureType", Namespaces.GFC);
                IFields fields = featureClass.getFields();
                for (int i = 0; i < fields.getFieldCount(); ++i) {
                    IField field = fields.getField(i);
                    Element gfc_carrierOfCharacteristics = new Element("carrierOfCharacteristics", Namespaces.GFC);
                    Element gfc_FC_FeatureAttribute = new Element("FC_FeatureAttribute", Namespaces.GFC);
                    Element gfc_memberName = new Element("memberName", Namespaces.GFC);
                    Element field_gco_LocalName = new Element("LocalName", Namespaces.GCO);
                    field_gco_LocalName.setText(field.getAliasName());
                    gfc_memberName.addContent((Content)field_gco_LocalName);
                    gfc_FC_FeatureAttribute.addContent((Content)gfc_memberName);
                    Element gfc_valueType = new Element("valueType", Namespaces.GFC);
                    Element gco_TypeName = new Element("TypeName", Namespaces.GCO);
                    Element gco_aName = new Element("aName", Namespaces.GCO);
                    Element gco_CharacterString = new Element("CharacterString", Namespaces.GCO);
                    gco_CharacterString.setText(ArcGISSynchronizer.getValueType((int)field.getType(), (IFeatureClass)featureClass));
                    gco_aName.addContent((Content)gco_CharacterString);
                    gco_TypeName.addContent((Content)gco_aName);
                    gfc_valueType.addContent((Content)gco_TypeName);
                    gfc_FC_FeatureAttribute.addContent((Content)gfc_valueType);
                    gfc_carrierOfCharacteristics.addContent((Content)gfc_FC_FeatureAttribute);
                    gfc_FC_FeatureType.addContent((Content)gfc_carrierOfCharacteristics);
                }
                gfc_featureType.addContent((Content)gfc_FC_FeatureType);
                gfc_FC_FeatureCatalogue.addContent((Content)gfc_featureType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getSpatialRepresentation(IDataset dataset) throws IOException {
        switch (dataset.getType()) {
            case 4: 
            case 5: {
                return "vector";
            }
            case 22: {
                return "";
            }
            case 2: 
            case 3: 
            case 7: {
                return "";
            }
            case 19: 
            case 27: {
                return "";
            }
            case 12: 
            case 13: 
            case 16: {
                return "grid";
            }
            case 11: {
                return "";
            }
            case 21: {
                return "";
            }
            case 23: {
                return "";
            }
            case 10: {
                return "textTable";
            }
            case 20: {
                return "";
            }
            case 14: {
                return "tin";
            }
            case 8: {
                return "";
            }
        }
        return "";
    }

    private static String getFeatureClassShapeType(IFeatureClass featureClass) throws IOException {
        switch (featureClass.getShapeType()) {
            case 7: {
                return "Any";
            }
            case 17: {
                return "Bag";
            }
            case 15: {
                return "Bezier 3Curve";
            }
            case 14: {
                return "Circular Arc";
            }
            case 16: {
                return "Elliptic Arc";
            }
            case 5: {
                return "Envelope";
            }
            case 13: {
                return "Line";
            }
            case 9: {
                return "MultiPatch";
            }
            case 2: {
                return "Multipoint";
            }
            case 0: {
                return "Null";
            }
            case 6: {
                return "Path";
            }
            case 1: {
                return "Point";
            }
            case 4: {
                return "Polygon";
            }
            case 3: {
                return "Polyline";
            }
            case 20: {
                return "Ray";
            }
            case 11: {
                return "Ring";
            }
            case 21: {
                return "Sphere";
            }
            case 19: {
                return "Triangle Fan";
            }
            case 18: {
                return "Triangle Strip";
            }
            case 22: {
                return "Triangles";
            }
        }
        return "Unknown";
    }

    private static String getValueType(int varType, IFeatureClass featureClass) throws IOException {
        switch (varType) {
            case 8: {
                return "Blob";
            }
            case 5: {
                return "Date";
            }
            case 3: {
                return "Double";
            }
            case 10: {
                return "GUID";
            }
            case 7: {
                return ArcGISSynchronizer.getFeatureClassShapeType((IFeatureClass)featureClass);
            }
            case 11: {
                return "GlobalID";
            }
            case 1: {
                return "Integer 32bit";
            }
            case 6: {
                return "Object ID";
            }
            case 9: {
                return "Raster";
            }
            case 2: {
                return "Float";
            }
            case 0: {
                return "Integer 16bit";
            }
            case 4: {
                return "String";
            }
            case 12: {
                return "XML";
            }
        }
        return "";
    }
}

