/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ArcObjectsLinker {
    private static final Log log = LogFactory.getLog(ArcObjectsLinker.class);
    private static List<String> homeEnvVars = Arrays.asList("AGSSERVERJAVA", "AGSENGINEJAVA", "AGSDESKTOPJAVA", "ARCGISHOME");

    public static void link() throws Exception {
        ArcObjectsLinker.link(null);
    }

    public static void link(String arcObjectsHome) throws Exception {
        String jarPath;
        if (arcObjectsHome == null) {
            for (String s : homeEnvVars) {
                arcObjectsHome = System.getenv(s);
                if (arcObjectsHome == null) continue;
                log.info((Object)("Using environment variable " + s + " to find ArcObjects"));
                break;
            }
        }
        if (arcObjectsHome == null) {
            throw new Exception("Could not find ArcObjects home in environment variables " + homeEnvVars + ". " + (System.getProperty("os.name").toLowerCase().indexOf("win") > -1 ? "ArcGIS Engine Runtime or ArcGIS Desktop must be installed" : "ArcGIS Engine Runtime must be installed"));
        }
        File jarFile = null;
        if (arcObjectsHome.endsWith(".jar")) {
            jarFile = new File(arcObjectsHome);
            if (jarFile.exists()) {
                log.info((Object)String.format("Using full path to ArcObjects JAR file: %s", jarFile.getAbsolutePath()));
            } else {
                jarFile = null;
            }
        }
        if (jarFile == null) {
            jarPath = arcObjectsHome + File.separator + "arcobjects.jar";
            jarFile = new File(jarPath);
            if (jarFile.exists()) {
                log.info((Object)String.format("Using arcobjects.jar found in directory: %s", jarFile.getAbsolutePath()));
            } else {
                jarFile = null;
            }
        }
        if (jarFile == null) {
            jarPath = arcObjectsHome + File.separator + "java" + File.separator + "lib" + File.separator + "arcobjects.jar";
            jarFile = new File(jarPath);
            if (!jarFile.exists()) {
                throw new Exception("Error: could not find arcobjects.jar at path \"" + jarFile.getAbsolutePath() + "\"");
            }
            log.info((Object)String.format("Using ArcObjects home \"%s\"", arcObjectsHome));
        }
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, jarFile.toURI().toURL());
        }
        catch (Throwable throwable) {
            throw new Exception("Could not add arcobjects.jar to system classloader", throwable);
        }
    }
}

