/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import com.esri.arcgis.datasourcesGDB.SdeWorkspaceFactory;
import com.esri.arcgis.geodatabase.IDataset;
import com.esri.arcgis.geodatabase.IEnumDataset;
import com.esri.arcgis.geodatabase.Workspace;
import java.io.File;
import java.io.OutputStream;
import java.util.regex.Pattern;
import nl.b3p.catalog.arcgis.ArcGISSynchronizer;
import nl.b3p.catalog.arcgis.FGDBHelper;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * Exception performing whole class analysis ignored.
 */
public class ArcObjectsSynchronizerWorker {
    private static final Log log = LogFactory.getLog(ArcObjectsSynchronizerWorker.class);

    public static void synchronize(CommandLine cl) throws Exception {
        Document doc;
        String type = cl.getOptionValue("type");
        String dataset = cl.getOptionValue("dataset");
        IDataset ds = null;
        String formatName = null;
        Document metadataAllElements = null;
        if (cl.hasOption("stdin")) {
            System.err.println("Reading XML document from stdin");
            metadataAllElements = new SAXBuilder().build(System.in);
        }
        if ("sde".equals(type) || "sdefile".equals(type)) {
            Workspace ws;
            formatName = "ESRI ArcSDE";
            if ("sde".equals(type)) {
                String connectionString = cl.getOptionValue("sde");
                if (connectionString == null) {
                    throw new IllegalArgumentException("sde option is required");
                }
                log.info((Object)("Opening SDE workspace using connection string " + connectionString));
                SdeWorkspaceFactory factory = new SdeWorkspaceFactory();
                ws = new Workspace((Object)factory.openFromString(connectionString, 0));
            } else {
                String file = cl.getOptionValue("sdefile");
                if (file == null) {
                    throw new IllegalArgumentException("sdefile option is required");
                }
                log.info((Object)("Opening SDE workspace from connection file " + file));
                SdeWorkspaceFactory factory = new SdeWorkspaceFactory();
                ws = new Workspace((Object)factory.openFromFile(file, 0));
            }
            log.info((Object)("SDE workspace open, looking for dataset " + dataset));
            ds = ArcObjectsSynchronizerWorker.findSDEDataset((Workspace)ws, (String)dataset);
        } else if ("fgdb".equals(type)) {
            formatName = "ESRI file geodatabase (FGDB)";
            ds = FGDBHelper.getTargetDataset((File)new File(dataset), (int)5);
        } else {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        log.info((Object)"Dataset found, synchronizing");
        if (metadataAllElements == null) {
            doc = ArcGISSynchronizer.synchronize((IDataset)ds, (String)formatName);
        } else {
            System.err.println("Synchronizing using stdin document");
            ArcGISSynchronizer.synchronize((Document)metadataAllElements, (Object)ds, (String)formatName);
            doc = metadataAllElements;
        }
        new XMLOutputter(Format.getPrettyFormat()).output(doc, (OutputStream)System.out);
    }

    private static IDataset findSDEDataset(Workspace ws, String datasetName) throws Exception {
        IEnumDataset eds = ws.getSubsets();
        String[] parts = datasetName.split(Pattern.quote("/"));
        if (parts.length > 2) {
            throw new IllegalArgumentException("Invalid dataset: " + datasetName);
        }
        String featureDataset = null;
        String dataset = parts[0];
        if (parts.length == 2) {
            featureDataset = parts[0];
            dataset = parts[1];
            log.info((Object)("Looking for feature dataset \"" + featureDataset + "\""));
            eds = ArcObjectsSynchronizerWorker.findFeatureDataset((IEnumDataset)eds, (String)featureDataset);
            if (eds == null) {
                throw new IllegalArgumentException("Feature dataset \"" + featureDataset + "\" not found");
            }
        }
        log.info((Object)("Looking for dataset \"" + dataset + "\""));
        IDataset ds = ArcObjectsSynchronizerWorker.findFeatureClass((IEnumDataset)eds, (String)dataset);
        if (ds == null) {
            throw new IllegalArgumentException("Dataset \"" + dataset + "\" not found");
        }
        return ds;
    }

    private static IDataset findFeatureClass(IEnumDataset eds, String name) throws Exception {
        IDataset ds;
        while ((ds = eds.next()) != null) {
            if (ds.getType() == 4 || !ds.getName().equals(name)) continue;
            return ds;
        }
        return null;
    }

    private static IEnumDataset findFeatureDataset(IEnumDataset eds, String name) throws Exception {
        IDataset ds;
        while ((ds = eds.next()) != null) {
            if (ds.getType() != 4 || !ds.getName().equals(name)) continue;
            return ds.getSubsets();
        }
        return null;
    }
}

