/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import com.esri.arcgis.datasourcesGDB.SdeWorkspaceFactory;
import com.esri.arcgis.geodatabase.IDataset;
import com.esri.arcgis.geodatabase.IEnumDataset;
import com.esri.arcgis.geodatabase.IMetadata;
import com.esri.arcgis.geodatabase.Workspace;
import com.esri.arcgis.geodatabase.XmlPropertySet;
import com.esri.arcgis.system.IPropertySet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import nl.b3p.catalog.config.Root;
import nl.b3p.catalog.config.SDERoot;
import nl.b3p.catalog.filetree.Dir;
import nl.b3p.catalog.filetree.DirContent;
import nl.b3p.catalog.filetree.DirEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ArcSDEHelper {
    private static final Log log = LogFactory.getLog(ArcSDEHelper.class);

    public static DirContent getDirContent(SDERoot root, String fullPath) throws Exception {
        DirContent dc = new DirContent();
        String path = Root.getPathPart((String)fullPath);
        if ("".equals(path)) {
            dc.setDirs(ArcSDEHelper.getFeatureDatasets((SDERoot)root, (String)fullPath));
            dc.setFiles(ArcSDEHelper.getFeatureClasses((SDERoot)root, (String)fullPath));
        } else {
            dc.setFiles(ArcSDEHelper.getFeatureClassesInDataset((SDERoot)root, (String)(fullPath + "/"), (String)path));
        }
        return dc;
    }

    public static IDataset getDataset(Root r, String path) throws Exception {
        IDataset ds;
        SDERoot root = (SDERoot)r;
        String[] paths = path.split(Pattern.quote("/"));
        String containingFeatureDatasetName = null;
        String datasetName = null;
        if (paths.length == 1) {
            datasetName = paths[0];
            log.debug((Object)("Getting ArcObjects dataset for name " + datasetName));
        } else {
            containingFeatureDatasetName = paths[0];
            datasetName = paths[1];
            log.debug((Object)("Getting ArcObjects dataset for name " + datasetName + ", in containing feature dataset " + containingFeatureDatasetName));
        }
        if (datasetName == null) {
            throw new IllegalArgumentException("Invalid dataset specified");
        }
        Workspace ws = ArcSDEHelper.getWorkspace((SDERoot)root);
        IEnumDataset enumDataset = ws.getSubsets();
        if (containingFeatureDatasetName != null) {
            while ((ds = enumDataset.next()) != null) {
                if (ds.getType() != 4 || !ds.getName().equals(containingFeatureDatasetName)) continue;
                log.info((Object)("Found containing feature dataset " + containingFeatureDatasetName));
                enumDataset = ds.getSubsets();
                break;
            }
            if (ds == null) {
                throw new IllegalArgumentException("Feature dataset \"" + containingFeatureDatasetName + "\" not found");
            }
        }
        while ((ds = enumDataset.next()) != null) {
            log.debug((Object)("Checking dataset name " + ds.getName() + ", type " + ds.getType()));
            if (ds.getType() == 4 || !ds.getName().equals(datasetName)) continue;
            return ds;
        }
        throw new IllegalArgumentException("Feature class \"" + datasetName + "\" not found");
    }

    private static Workspace getWorkspace(SDERoot root) throws Exception {
        if (root.getArcobjectsConnection() == null) {
            throw new Exception("ArcObjects niet geconfigureerd voor deze SDE root");
        }
        SdeWorkspaceFactory factory = new SdeWorkspaceFactory();
        return new Workspace((Object)factory.openFromString(root.getArcobjectsConnection(), 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Dir> getFeatureDatasets(SDERoot root, String currentPath) throws Exception {
        Workspace ws = ArcSDEHelper.getWorkspace((SDERoot)root);
        try {
            IDataset ds;
            ArrayList<Dir> dirs = new ArrayList<Dir>();
            IEnumDataset enumDataset = ws.getSubsets();
            while ((ds = enumDataset.next()) != null) {
                if (ds.getType() != 4) continue;
                Dir d = new Dir(ds.getName(), currentPath + ds.getName());
                dirs.add(d);
            }
            ArrayList<Dir> arrayList = dirs;
            return arrayList;
        }
        finally {
            ws.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DirEntry> getFeatureClasses(SDERoot root, String currentPath) throws Exception {
        Workspace ws = ArcSDEHelper.getWorkspace((SDERoot)root);
        try {
            List list = ArcSDEHelper.getDatasetEnumFeatureClassFiles((IEnumDataset)ws.getSubsets(), (String)currentPath);
            return list;
        }
        finally {
            ws.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DirEntry> getFeatureClassesInDataset(SDERoot root, String currentPath, String dataset) throws Exception {
        if (dataset == null) {
            throw new IllegalArgumentException("Invalid feature dataset specified");
        }
        Workspace ws = ArcSDEHelper.getWorkspace((SDERoot)root);
        try {
            IDataset ds;
            IEnumDataset enumDataset = ws.getSubsets();
            while (!((ds = enumDataset.next()) == null || ds.getType() == 4 && ds.getName().equals(dataset))) {
            }
            if (ds == null) {
                throw new IllegalArgumentException("Dataset \"" + dataset + "\" not found");
            }
            List list = ArcSDEHelper.getDatasetEnumFeatureClassFiles((IEnumDataset)ds.getSubsets(), (String)currentPath);
            return list;
        }
        finally {
            ws.release();
        }
    }

    private static List<DirEntry> getDatasetEnumFeatureClassFiles(IEnumDataset enumDataset, String currentPath) throws IOException {
        IDataset ds;
        ArrayList<DirEntry> files = new ArrayList<DirEntry>();
        while ((ds = enumDataset.next()) != null) {
            if (ds.getType() == 4) continue;
            DirEntry f = new DirEntry(ds.getName(), currentPath + ds.getName());
            f.setIsGeo(true);
            files.add(f);
        }
        return files;
    }

    public static String getMetadata(Object dataset) throws IOException {
        IMetadata imd = (IMetadata)((IDataset)dataset).getFullName();
        return ((XmlPropertySet)imd.getMetadata()).getXml("/");
    }

    public static void saveMetadata(Object dataset, String metadata) throws IOException {
        IMetadata imd = (IMetadata)((IDataset)dataset).getFullName();
        XmlPropertySet mdPS = (XmlPropertySet)imd.getMetadata();
        mdPS.setXml(metadata);
        imd.setMetadata((IPropertySet)mdPS);
    }
}

