/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import nl.b3p.catalog.arcgis.ArcSDEJDBCDataset;
import nl.b3p.catalog.config.Root;
import nl.b3p.catalog.config.SDERoot;
import nl.b3p.catalog.filetree.Dir;
import nl.b3p.catalog.filetree.DirContent;
import nl.b3p.catalog.filetree.DirEntry;

public abstract class ArcSDEJDBCHelper {
    protected SDERoot root;

    public ArcSDEJDBCHelper(SDERoot root) {
        this.root = root;
    }

    protected Connection getConnection() throws NamingException, SQLException {
        InitialContext initCtx = new InitialContext();
        DataSource ds = (DataSource)initCtx.lookup(this.root.getJndiDataSource());
        return ds.getConnection();
    }

    protected String getTableName(String name) {
        String prefix = this.root.getTablePrefix();
        if (prefix == null || prefix.trim().length() == 0) {
            return name;
        }
        return prefix.trim() + "." + name;
    }

    public DirContent getDirContent(String fullPath) throws NamingException, SQLException {
        DirContent dc = new DirContent();
        String path = Root.getPathPart((String)fullPath);
        if ("".equals(path)) {
            dc.setDirs(this.getFeatureDatasets(fullPath));
            dc.setFiles(this.getFeatureClasses(fullPath, null));
        } else {
            dc.setFiles(this.getFeatureClasses(fullPath + "/", new ArcSDEJDBCDataset(this.root, path)));
        }
        return dc;
    }

    public ArcSDEJDBCDataset getDataset(String fullPath) {
        return new ArcSDEJDBCDataset(this.root, fullPath);
    }

    public static String getMetadata(SDERoot root, String fullPath) throws NamingException, SQLException, IOException {
        return root.getJDBCHelper().getMetadata(fullPath);
    }

    public String getMetadata(String fullPath) throws NamingException, SQLException, IOException {
        return this.getMetadata(this.getDataset(fullPath));
    }

    public abstract List<Dir> getFeatureDatasets(String var1) throws NamingException, SQLException;

    public abstract List<DirEntry> getFeatureClasses(String var1, ArcSDEJDBCDataset var2) throws NamingException, SQLException;

    public abstract String getMetadata(ArcSDEJDBCDataset var1) throws NamingException, SQLException, IOException;

    public abstract void saveMetadata(ArcSDEJDBCDataset var1, String var2) throws Exception;

    public abstract String getAbsoluteDatasetName(ArcSDEJDBCDataset var1) throws Exception;
}

