/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.filetree;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import nl.b3p.catalog.arcgis.FGDBHelperProxy;
import nl.b3p.catalog.config.CatalogAppConfig;
import nl.b3p.catalog.config.FileRoot;
import nl.b3p.catalog.config.Root;
import nl.b3p.catalog.filetree.Dir;
import nl.b3p.catalog.filetree.DirContent;
import nl.b3p.catalog.filetree.DirEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileListHelper {
    private static final Log log = LogFactory.getLog(FileListHelper.class);

    public static File getFileForPath(Root r, String path) throws FileNotFoundException {
        FileRoot root = (FileRoot)r;
        if ((path = Root.getPathPart((String)path)).indexOf("..") != -1) {
            throw new IllegalArgumentException("Illegal path");
        }
        String osPath = path.replace("/".charAt(0), File.separatorChar);
        File p = new File(osPath);
        if (p.isAbsolute()) {
            throw new IllegalArgumentException("Illegal path");
        }
        File f = new File(root.getPath(), osPath);
        return f;
    }

    public static DirContent getDirContent(FileRoot root, String fullPath) throws Exception {
        File dir = FileListHelper.getFileForPath((Root)root, (String)fullPath);
        String pathPart = Root.getPathPart((String)fullPath);
        return FileListHelper.getDirContent((File)dir, (String)(fullPath + (pathPart.equals("") ? "" : "/")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirContent getDirContent(File directory, String currentPath) throws Exception {
        if (FGDBHelperProxy.isFGDBDirOrInsideFGDBDir((File)directory)) {
            try {
                FGDBHelperProxy.cleanerTrackObjectsInCurrentThread();
                DirContent dirContent = FileListHelper.getFGDBDirContent((File)directory, (String)currentPath);
                return dirContent;
            }
            finally {
                FGDBHelperProxy.cleanerReleaseAllInCurrentThread();
            }
        }
        return FileListHelper.getNormalDirContent((File)directory, (String)currentPath);
    }

    private static DirContent getNormalDirContent(File directory, String currentPath) throws IOException {
        DirContent dc = new DirContent();
        File[] dirs = directory.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        File[] files = directory.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        if (dirs != null) {
            for (File dir : dirs) {
                Dir newDir = new Dir();
                newDir.setName(dir.getName());
                newDir.setPath(currentPath + dir.getName());
                newDir.setIsFGDB(FGDBHelperProxy.isFGDBDirOrInsideFGDBDir((File)dir));
                dc.getDirs().add(newDir);
            }
        }
        if (files != null) {
            for (File file : files) {
                DirEntry newFile = new DirEntry();
                newFile.setName(file.getName());
                newFile.setPath(currentPath + file.getName());
                boolean isGeo = true;
                Set geoFileExtensions = CatalogAppConfig.getConfig().getGeoFileExtensions();
                if (!geoFileExtensions.isEmpty() && !geoFileExtensions.contains(newFile.getExtension())) {
                    isGeo = false;
                }
                newFile.setIsGeo(isGeo);
                dc.getFiles().add(newFile);
            }
        }
        DirEntry newFile = new DirEntry();
        newFile.setName(".metadata");
        newFile.setPath(currentPath + "metadata");
        newFile.setIsGeo(true);
        dc.getFiles().add(newFile);
        FileListHelper.filterOutFilesToHide((DirContent)dc);
        return dc;
    }

    private static DirContent getFGDBDirContent(File directory, String currentPath) throws Exception {
        log.debug((Object)String.format("Get FGDB content from %s (currentPath %s)", directory, currentPath));
        DirContent dc = new DirContent();
        List dirsList = FGDBHelperProxy.getAllDirDatasets((File)directory, (String)currentPath);
        List filesList = FGDBHelperProxy.getAllFileDatasets((File)directory, (String)currentPath);
        dc.setDirs(dirsList);
        dc.setFiles(filesList);
        return dc;
    }

    private static void filterOutFilesToHide(DirContent dc) {
        FileListHelper.filterOutMetadataFiles((DirContent)dc);
        FileListHelper.filterOutShapeExtraFiles((DirContent)dc);
    }

    private static void filterOutMetadataFiles(DirContent dc) {
        ArrayList<DirEntry> toBeIgnoredFiles = new ArrayList<DirEntry>();
        dc.sort();
        List filesList = dc.getFiles();
        String lastFilename = null;
        for (DirEntry file : filesList) {
            String filename = file.getName();
            if (filename.equalsIgnoreCase("metadata.xml")) {
                toBeIgnoredFiles.add(file);
                continue;
            }
            if (lastFilename == null || !filename.startsWith(lastFilename)) {
                lastFilename = filename;
                continue;
            }
            if (filename.length() != lastFilename.length() + 4 || !filename.endsWith(".xml")) continue;
            toBeIgnoredFiles.add(file);
        }
        filesList.removeAll(toBeIgnoredFiles);
    }

    private static void filterOutShapeExtraFiles(DirContent dc) {
        ArrayList<String> shapeNames = new ArrayList<String>();
        for (DirEntry file : dc.getFiles()) {
            if (!file.getName().endsWith(".shp")) continue;
            shapeNames.add(file.getName().substring(0, file.getName().length() - ".shp".length()));
        }
        for (String shapeName : shapeNames) {
            ArrayList<DirEntry> toBeIgnoredFiles = new ArrayList<DirEntry>();
            for (DirEntry file : dc.getFiles()) {
                if (!file.getName().startsWith(shapeName) || file.getName().endsWith(".shp")) continue;
                toBeIgnoredFiles.add(file);
            }
            dc.getFiles().removeAll(toBeIgnoredFiles);
        }
    }
}

