/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.kaartenbalie;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import nl.b3p.catalog.config.KBRoot;
import nl.b3p.catalog.config.Root;
import nl.b3p.catalog.filetree.Dir;
import nl.b3p.catalog.filetree.DirContent;
import nl.b3p.catalog.filetree.DirEntry;
import nl.b3p.catalog.kaartenbalie.KbJDBCHelper;
import nl.b3p.catalog.xml.DocumentHelper;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class KbJDBCHelper {
    protected KBRoot root;

    public KbJDBCHelper(KBRoot root) {
        this.root = root;
    }

    protected Connection getConnection() throws NamingException, SQLException {
        InitialContext initCtx = new InitialContext();
        DataSource ds = (DataSource)initCtx.lookup(this.root.getJndiDataSource());
        return ds.getConnection();
    }

    protected String getTableName(String name) {
        return name;
    }

    public DirContent getDirContent(String fullPath) throws Exception {
        DirContent dc = new DirContent();
        String path = Root.getPathPart((String)fullPath);
        if ("".equals(path)) {
            ArrayList<Dir> dirs = new ArrayList<Dir>();
            Dir d = new Dir("WMS", fullPath + "WMS");
            dirs.add(d);
            d = new Dir("WFS", fullPath + "WFS");
            dirs.add(d);
            dc.setDirs(dirs);
        } else if ("WMS".equals(path)) {
            dc.setDirs(this.getFeatureDatasets(fullPath + "/", "WMS"));
        } else if ("WFS".equals(path)) {
            dc.setDirs(this.getFeatureDatasets(fullPath + "/", "WFS"));
        } else {
            dc.setFiles(this.getFeatureClasses(fullPath + "/"));
        }
        return dc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dir> getFeatureDatasets(String currentPath, String type) throws Exception {
        Connection c = this.getConnection();
        try {
            String sql = "";
            if ("WMS".equals(type)) {
                sql = "select id, abbr from service_provider ";
            } else if ("WFS".equals(type)) {
                sql = "select id, abbr from wfs_service_provider ";
            } else {
                ArrayList<Dir> dirs = new ArrayList<Dir>();
                Dir d = new Dir("", currentPath + "?");
                dirs.add(d);
                ArrayList<Dir> arrayList = dirs;
                return arrayList;
            }
            1 h = new /* Unavailable Anonymous Inner Class!! */;
            List list = (List)new QueryRunner().query(c, sql, (ResultSetHandler)h);
            return list;
        }
        finally {
            DbUtils.closeQuietly((Connection)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DirEntry> getFeatureClasses(String fullPath) throws Exception {
        String path = Root.getPathPart((String)fullPath);
        String[] paths = path.split(Pattern.quote("/"));
        String service = "";
        String sp_id = "";
        if (paths.length != 2) {
            ArrayList<DirEntry> l = new ArrayList<DirEntry>();
            DirEntry de = new DirEntry("", fullPath + "?");
            l.add(de);
            return l;
        }
        service = paths[0];
        sp_id = paths[1];
        Connection c = this.getConnection();
        try {
            String sql = "";
            if ("WMS".equals(service)) {
                sql = "select layer.id, layer.name, service_provider.abbr from layer join service_provider on (layer.service_provider = service_provider.id) where layer.name is not null and service_provider.id = ? ";
            } else if ("WFS".equals(service)) {
                sql = "select wfs_layer.id, wfs_layer.name, wfs_service_provider.abbr from wfs_layer join wfs_service_provider on (wfs_layer.wfs_service_provider = wfs_service_provider.id) where wfs_layer.name is not null and wfs_service_provider.id = ? ";
            } else {
                ArrayList<DirEntry> l = new ArrayList<DirEntry>();
                DirEntry de = new DirEntry("", fullPath + "?");
                l.add(de);
                ArrayList<DirEntry> arrayList = l;
                return arrayList;
            }
            2 h = new /* Unavailable Anonymous Inner Class!! */;
            List list = (List)new QueryRunner().query(c, sql, (ResultSetHandler)h, new Object[]{new Integer(sp_id)});
            return list;
        }
        finally {
            DbUtils.closeQuietly((Connection)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMetadataOrNull(String currentPath) throws Exception {
        String path = Root.getPathPart((String)currentPath);
        String[] paths = path.split(Pattern.quote("/"));
        String service = "";
        String sp_id = "";
        String layer_id = "";
        if (paths.length != 3) {
            return null;
        }
        service = paths[0];
        sp_id = paths[1];
        layer_id = paths[2];
        Connection c = this.getConnection();
        try {
            if ("WMS".equals(service)) {
                String sql = "select metadata from layer_metadata where layer = ?";
                String string = (String)new QueryRunner().query(c, sql, (ResultSetHandler)new ScalarHandler(), new Object[]{new Integer(layer_id)});
                return string;
            }
            if ("WFS".equals(service)) {
                String sql = "select metadata from wfs_layer_metadata where layer = ?";
                throw new Exception("WFS get metadata not supported!");
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)c);
        }
        return null;
    }

    public String getMetadata(String currentPath) throws Exception {
        String xml = this.getMetadataOrNull(currentPath);
        if (xml == null) {
            return "empty";
        }
        return xml;
    }

    public void saveMetadata(String currentPath, String metadata) throws Exception {
        String path = Root.getPathPart((String)currentPath);
        String[] paths = path.split(Pattern.quote("/"));
        String service = "";
        String sp_id = "";
        String layer_id = "";
        if (paths.length != 3) {
            throw new Exception("Invalid save path!");
        }
        service = paths[0];
        sp_id = paths[1];
        layer_id = paths[2];
        String oldXml = this.getMetadataOrNull(currentPath);
        if (oldXml == null) {
            this.insertMetadata(service, layer_id, metadata);
        } else {
            this.updateMetadata(service, layer_id, metadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMetadata(String service, String layer_id, String metadata) throws Exception {
        Connection c = this.getConnection();
        PreparedStatement ps = null;
        try {
            Document doc = DocumentHelper.getMetadataDocument((String)metadata);
            metadata = new XMLOutputter(Format.getPrettyFormat().setOmitEncoding(true)).outputString(doc);
            String sql = "";
            if ("WMS".equals(service)) {
                sql = "update layer_metadata set metadata = ? where layer = ?";
            } else if ("WFS".equals(service)) {
                sql = "update wfs_layer_metadata set metadata = ? where layer = ?";
                throw new Exception("WFS metadata update not supported!");
            }
            ps = c.prepareStatement(sql);
            ps.setString(1, metadata);
            ps.setInt(2, new Integer(layer_id));
            int rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                throw new Exception("Updating metadata should affect maximum one row; got rows affected count of " + rowsAffected);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(ps);
            DbUtils.closeQuietly((Connection)c);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)ps);
        DbUtils.closeQuietly((Connection)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertMetadata(String service, String layer_id, String metadata) throws Exception {
        Connection c = this.getConnection();
        PreparedStatement ps = null;
        try {
            Document doc = DocumentHelper.getMetadataDocument((String)metadata);
            metadata = new XMLOutputter(Format.getPrettyFormat().setOmitEncoding(true)).outputString(doc);
            String sql = "";
            if ("WMS".equals(service)) {
                sql = "insert into layer_metadata (layer, metadata) values (?, ?) ";
            } else if ("WFS".equals(service)) {
                sql = "insert into wfs_layer_metadata (layer, metadata) values (?, ?) ";
                throw new Exception("WFS metadata insert not supported!");
            }
            ps = c.prepareStatement(sql);
            ps.setString(2, metadata);
            ps.setInt(1, new Integer(layer_id));
            int rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                throw new Exception("Inserting metadata should affect maximum one row; got rows affected count of " + rowsAffected);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(ps);
            DbUtils.closeQuietly((Connection)c);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)ps);
        DbUtils.closeQuietly((Connection)c);
    }

    public String syncMetadata(String fullPath, String metadata) throws Exception {
        String path = Root.getPathPart((String)fullPath);
        String[] paths = path.split(Pattern.quote("/"));
        String service = "";
        String sp_id = "";
        String layer_id = "";
        if (paths.length != 3) {
            throw new Exception("Invalid sync path!");
        }
        service = paths[0];
        sp_id = paths[1];
        layer_id = paths[2];
        return metadata;
    }
}

