/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import nl.b3p.catalog.security.ConfigServlet;
import nl.b3p.catalog.security.GisSecurityRealm;
import nl.b3p.wms.capabilities.Roles;
import nl.b3p.wms.capabilities.ServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.securityfilter.filter.SecurityRequestWrapper;

public class GisPrincipal
implements Principal {
    public static final String URL_AUTH = "code";
    private static final Log log = LogFactory.getLog(GisPrincipal.class);
    private String name;
    private String password;
    private String code;
    private Set roles;
    private ServiceProvider sp;

    public GisPrincipal(String name, List roles) {
        this.name = name;
        this.roles = new HashSet();
        this.roles.addAll(roles);
    }

    public GisPrincipal(String name, String password, String code, ServiceProvider sp) {
        this.name = name;
        this.password = password;
        this.code = code;
        this.sp = sp;
        if (sp == null) {
            return;
        }
        this.roles = new HashSet();
        Set sproles = sp.getAllRoles();
        if (sproles == null || sproles.isEmpty()) {
            return;
        }
        for (Roles role : sproles) {
            String sprole = role.getRole();
            if (sprole == null || sprole.length() <= 0) continue;
            this.roles.add(sprole);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean isInRole(String role) {
        if (this.roles == null) {
            return false;
        }
        return this.roles.contains(role);
    }

    public Set getRoles() {
        return this.roles;
    }

    @Override
    public String toString() {
        return "GisPrincipal[name=" + this.name + "]";
    }

    public ServiceProvider getSp() {
        return this.sp;
    }

    public void setSp(ServiceProvider sp) {
        this.sp = sp;
    }

    public static GisPrincipal getGisPrincipal(HttpServletRequest request) {
        Principal user = request.getUserPrincipal();
        if (!(user instanceof GisPrincipal) || !(request instanceof SecurityRequestWrapper)) {
            return null;
        }
        GisPrincipal gp = (GisPrincipal)user;
        String code = request.getParameter(URL_AUTH);
        if (code != null && code.length() != 0) {
            if (gp != null && code.equals(gp.getCode())) {
                return gp;
            }
            HttpSession session = request.getSession();
            session.invalidate();
            String url = GisSecurityRealm.createCapabilitiesURL((String)code);
            gp = GisSecurityRealm.authenticateHttp((String)url, (String)ConfigServlet.ANONYMOUS_USER, null, (String)code);
        }
        if (gp != null) {
            SecurityRequestWrapper srw = (SecurityRequestWrapper)request;
            srw.setUserPrincipal((Principal)gp);
            log.debug((Object)("Automatic login for user: " + gp.name));
        }
        return gp;
    }
}

