/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletContext;
import nl.b3p.catalog.arcgis.ArcObjectsSynchronizerForker;
import nl.b3p.catalog.arcgis.ArcObjectsSynchronizerMain;
import nl.b3p.catalog.xml.DocumentHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;

/*
 * Exception performing whole class analysis ignored.
 */
public class ArcObjectsSynchronizerForker {
    private static final Log log = LogFactory.getLog(ArcObjectsSynchronizerForker.class);

    public static Document synchronize(ServletContext context, String dataset, String type, String sdeConnectionString, String metadata) throws Exception {
        int result;
        String workingDir = context.getRealPath("/WEB-INF");
        String cp = ArcObjectsSynchronizerForker.buildClasspath((ServletContext)context);
        String mainClass = ArcObjectsSynchronizerMain.class.getName();
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("java", "-classpath", cp, mainClass, "-type", type, "-dataset", dataset));
        if (metadata != null && !"".equals(metadata)) {
            args.add("-stdin");
        }
        if ("sde".equals(type)) {
            if (sdeConnectionString == null) {
                throw new IllegalArgumentException("SDE connection string is required");
            }
            args.add("-sde");
            args.add(sdeConnectionString);
        }
        StringWriter output = new StringWriter();
        StringWriter errors = new StringWriter();
        errors.write(String.format("Werkdirectory: %s\nUitvoeren synchronizer proces: %s\n\n", workingDir, StringUtils.join(args, (char)' ')));
        try {
            Process p = Runtime.getRuntime().exec(args.toArray(new String[0]), null, new File(workingDir));
            BufferedReader stderr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            BufferedReader stdout = new BufferedReader(new InputStreamReader(p.getInputStream()));
            if (metadata != null && !"".equals(metadata)) {
                try {
                    p.getOutputStream().write(metadata.getBytes("UTF-8"));
                    p.getOutputStream().flush();
                    p.getOutputStream().close();
                }
                catch (Exception e) {
                    errors.write("Fout tijdens schrijven metadata XML met alle elementen naar stdin: " + e.getClass() + ": " + e.getMessage() + "\n");
                }
            }
            1 stderrReader = new /* Unavailable Anonymous Inner Class!! */;
            2 stdoutReader = new /* Unavailable Anonymous Inner Class!! */;
            stderrReader.start();
            stdoutReader.start();
            result = p.waitFor();
            stderrReader.join();
            stdoutReader.join();
            errors.write("Resultaat: " + (result == 0 ? "succesvol gesynchroniseerd" : "fout opgetreden") + "\n\n");
        }
        catch (Exception e) {
            throw new Exception("Fout tijdens aanroepen extern proces voor synchroniseren, output: \n" + errors.toString(), e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Synchroniseren via apart proces succesvol; output: " + errors.toString()));
        }
        if (result == 0) {
            return DocumentHelper.getMetadataDocument((String)output.toString());
        }
        throw new Exception("Synchroniseren via apart process geeft error code " + result + "; output: \n" + errors.toString());
    }

    private static String buildClasspath(ServletContext context) {
        File[] jarFiles;
        StringBuilder cp = new StringBuilder();
        cp.append("classes");
        File lib = new File(context.getRealPath("/WEB-INF/lib"));
        for (File f : jarFiles = lib.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */)) {
            cp.append(File.pathSeparator);
            cp.append("lib");
            cp.append(File.separatorChar);
            cp.append(f.getName());
        }
        return cp.toString();
    }
}

