/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import java.util.regex.Pattern;
import nl.b3p.catalog.config.Root;
import nl.b3p.catalog.config.SDERoot;

public class ArcSDEJDBCDataset {
    private SDERoot root;
    private ArcSDEJDBCDataset parent;
    private String fullName;
    private String databaseName;
    private String owner;
    private String name;

    public ArcSDEJDBCDataset(SDERoot root, String fullPath) {
        this.root = root;
        String path = Root.getPathPart((String)fullPath);
        String[] paths = path.split(Pattern.quote("/"), 2);
        this.fullName = paths[paths.length - 1];
        if ("9.x".equals(root.getSchemaVersion())) {
            String[] nameParts = this.fullName.split(Pattern.quote("."));
            if (nameParts.length == 2) {
                this.owner = nameParts[0];
                this.name = nameParts[1];
            } else if (nameParts.length == 3) {
                this.databaseName = nameParts[0];
                this.owner = nameParts[1];
                this.name = nameParts[2];
            } else {
                throw new IllegalStateException("Full dataset name \"" + this.fullName + "\" must contain one or two dots");
            }
        }
        if (paths.length > 1) {
            this.parent = new ArcSDEJDBCDataset(root, paths[paths.length - 2]);
        }
    }

    public String getFullName() {
        return this.fullName;
    }

    public Integer getObjectID() {
        return Integer.parseInt(this.fullName);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    static String constructFullName(String databaseName, String owner, String name) {
        if (databaseName == null) {
            return owner + "." + name;
        }
        return databaseName + "." + owner + "." + name;
    }

    public ArcSDEJDBCDataset getParent() {
        return this.parent;
    }

    public SDERoot getRoot() {
        return this.root;
    }

    public void setRoot(SDERoot root) {
        this.root = root;
    }

    public String getAbsoluteName() throws Exception {
        return this.root.getJDBCHelper().getAbsoluteDatasetName(this);
    }
}

