/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import com.esri.arcgis.datasourcesGDB.FileGDBWorkspaceFactory;
import com.esri.arcgis.geodatabase.IDataset;
import com.esri.arcgis.geodatabase.IEnumDataset;
import com.esri.arcgis.geodatabase.IMetadata;
import com.esri.arcgis.geodatabase.IWorkspaceFactoryLockControlProxy;
import com.esri.arcgis.geodatabase.Workspace;
import com.esri.arcgis.geodatabase.XmlPropertySet;
import com.esri.arcgis.geodatabase.esriDatasetType;
import com.esri.arcgis.system.Cleaner;
import com.esri.arcgis.system.IPropertySet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import nl.b3p.catalog.B3PCatalogException;
import nl.b3p.catalog.arcgis.DatasetHelper;
import nl.b3p.catalog.arcgis.FGDBHelperProxy;
import nl.b3p.catalog.filetree.Dir;
import nl.b3p.catalog.filetree.DirEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FGDBHelper {
    private static final Log log = LogFactory.getLog(FGDBHelper.class);

    public static String getMetadata(File fileGDBPath, int datasetType) throws IOException, B3PCatalogException {
        IMetadata iMetadata = FGDBHelper.getIMetadata((File)fileGDBPath, (int)datasetType);
        XmlPropertySet xmlPropertySet = (XmlPropertySet)iMetadata.getMetadata();
        return xmlPropertySet.getXml("/");
    }

    public static void setMetadata(File fileGDBPath, int datasetType, String metadata) throws IOException, B3PCatalogException {
        IMetadata iMetadata = FGDBHelper.getIMetadata((File)fileGDBPath, (int)datasetType);
        XmlPropertySet xmlPropertySet = (XmlPropertySet)iMetadata.getMetadata();
        xmlPropertySet.setXml(metadata);
        iMetadata.setMetadata((IPropertySet)xmlPropertySet);
    }

    private static IMetadata getIMetadata(File fileGDBPath, int datasetType) throws IOException, B3PCatalogException {
        IDataset ds = FGDBHelper.getTargetDataset((File)fileGDBPath, (int)datasetType);
        return (IMetadata)DatasetHelper.getIDataset((IDataset)ds).getFullName();
    }

    public static List<Dir> getAllDirDatasets(File fileGDBPath, String currentPath) throws Exception {
        IDataset ds;
        ArrayList<Dir> files = new ArrayList<Dir>();
        log.debug((Object)("Opening FGDB dataset: " + fileGDBPath));
        IDataset targetDataset = FGDBHelper.getTargetDataset((File)fileGDBPath, (int)-1);
        IEnumDataset enumDataset = targetDataset.getSubsets();
        while ((ds = enumDataset.next()) != null) {
            if (ds.getType() != 4) continue;
            Dir dir = new Dir();
            dir.setName(ds.getName());
            dir.setPath(currentPath + ds.getName());
            files.add(dir);
        }
        return files;
    }

    public static List<DirEntry> getAllFileDatasets(File fileGDBPath, String currentPath) throws Exception {
        IDataset ds;
        ArrayList<DirEntry> files = new ArrayList<DirEntry>();
        log.debug((Object)("Opening FGDB dataset: " + fileGDBPath));
        IDataset targetDataset = FGDBHelper.getTargetDataset((File)fileGDBPath, (int)-1);
        IEnumDataset enumDataset = targetDataset.getSubsets();
        while ((ds = enumDataset.next()) != null) {
            if (ds.getType() == 4) continue;
            DirEntry file = new DirEntry();
            file.setName(ds.getName());
            file.setPath(currentPath + ds.getName());
            file.setType(DatasetHelper.getConstantFieldName(esriDatasetType.class, (Object)ds.getType()));
            file.setIsGeo(true);
            files.add(file);
        }
        return files;
    }

    public static IDataset getTargetDataset(File fileGDBPath, int dataType) throws IOException {
        Workspace targetDataset = null;
        if (FGDBHelperProxy.isFGDBDir((File)fileGDBPath)) {
            targetDataset = FGDBHelper.getWorkspace((String)fileGDBPath.getCanonicalPath());
        } else if (FGDBHelperProxy.isInsideFGDBDir((File)fileGDBPath)) {
            File fgdb = FGDBHelperProxy.getRootFGDBDir((File)fileGDBPath);
            File currentDirFile = fileGDBPath;
            LinkedList<String> subDirList = new LinkedList<String>();
            while (!currentDirFile.getCanonicalFile().equals(fgdb.getCanonicalFile())) {
                subDirList.add(0, currentDirFile.getName());
                currentDirFile = currentDirFile.getParentFile();
            }
            if (subDirList.size() > 2) {
                throw new IllegalStateException("Feature datasets inside feature datasets not supported");
            }
            targetDataset = FGDBHelper.getWorkspace((String)fgdb.getCanonicalPath());
            for (String subDir : subDirList) {
                if (!subDir.equals(subDirList.get(subDirList.size() - 1))) {
                    targetDataset = DatasetHelper.getDataSubset((IDataset)targetDataset, (String)subDir, (int)-1);
                    continue;
                }
                targetDataset = DatasetHelper.getDataSubset((IDataset)targetDataset, (String)subDir, (int)dataType);
            }
        } else {
            throw new IOException("Not a FGDB or inside a FGDB: " + fileGDBPath.getAbsolutePath());
        }
        return targetDataset;
    }

    private static Workspace getWorkspace(String fileGDBPath) throws IOException {
        FileGDBWorkspaceFactory factory = new FileGDBWorkspaceFactory();
        new IWorkspaceFactoryLockControlProxy((Object)factory).disableSchemaLocking();
        return new Workspace((Object)factory.openFromFile(fileGDBPath, 0));
    }

    public static void cleanerTrackObjectsInCurrentThread() {
        Cleaner.trackObjectsInCurrentThread();
    }

    public static void cleanerReleaseAllInCurrentThread() {
        Cleaner.releaseAllInCurrentThread();
    }
}

