/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import nl.b3p.catalog.B3PCatalogException;
import nl.b3p.catalog.arcgis.ArcObjectsNotFoundException;
import nl.b3p.catalog.arcgis.FGDBHelper;
import nl.b3p.catalog.filetree.Dir;
import nl.b3p.catalog.filetree.DirEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FGDBHelperProxy {
    private static final Log log = LogFactory.getLog(FGDBHelperProxy.class);

    private static void rethrow(NoClassDefFoundError ncdfex) throws B3PCatalogException {
        String message = "ArcObjects is niet goed geinitialiseerd. Om metadata te bekijken en weg te schrijven in deze ESRI file geodatabase (FGDB) is dit nodig.";
        log.warn((Object)message, (Throwable)ncdfex);
        throw new ArcObjectsNotFoundException(message, (Throwable)ncdfex);
    }

    public static File getRootFGDBDir(File file) {
        while (file != null) {
            if (FGDBHelperProxy.isFGDBDir((File)file)) {
                return file;
            }
            file = file.getParentFile();
        }
        return null;
    }

    public static String getRootFGDBDirname(File file) {
        File root = FGDBHelperProxy.getRootFGDBDir((File)file);
        if (root == null) {
            return null;
        }
        return root.getAbsolutePath();
    }

    public static boolean isFGDBDirOrInsideFGDBDir(File file) {
        while (file != null) {
            if (FGDBHelperProxy.isFGDBDir((File)file)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    public static boolean isInsideFGDBDir(File file) {
        if (file == null) {
            return false;
        }
        file = file.getParentFile();
        return FGDBHelperProxy.isFGDBDirOrInsideFGDBDir((File)file);
    }

    public static boolean isFGDBDir(File file) {
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        String[] gdbFiles = file.list((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        if (gdbFiles == null) {
            return false;
        }
        return gdbFiles.length >= 1;
    }

    public static Object getTargetDataset(File fileGDBPath, int dataType) throws IOException, B3PCatalogException {
        try {
            return FGDBHelper.getTargetDataset((File)fileGDBPath, (int)dataType);
        }
        catch (NoClassDefFoundError ncdfex) {
            FGDBHelperProxy.rethrow((NoClassDefFoundError)ncdfex);
            return null;
        }
    }

    public static String getMetadata(File fileGDBPath, int datasetType) throws IOException, B3PCatalogException {
        try {
            return FGDBHelper.getMetadata((File)fileGDBPath, (int)datasetType);
        }
        catch (NoClassDefFoundError ncdfex) {
            FGDBHelperProxy.rethrow((NoClassDefFoundError)ncdfex);
            return null;
        }
    }

    public static void setMetadata(File fileGDBPath, int datasetType, String metadata) throws IOException, B3PCatalogException {
        try {
            FGDBHelper.setMetadata((File)fileGDBPath, (int)datasetType, (String)metadata);
        }
        catch (NoClassDefFoundError ncdfex) {
            FGDBHelperProxy.rethrow((NoClassDefFoundError)ncdfex);
        }
    }

    public static List<Dir> getAllDirDatasets(File fileGDBPath, String currentPath) throws Exception {
        try {
            return FGDBHelper.getAllDirDatasets((File)fileGDBPath, (String)currentPath);
        }
        catch (NoClassDefFoundError ncdfex) {
            FGDBHelperProxy.rethrow((NoClassDefFoundError)ncdfex);
            return null;
        }
    }

    public static List<DirEntry> getAllFileDatasets(File fileGDBPath, String currentPath) throws Exception {
        try {
            return FGDBHelper.getAllFileDatasets((File)fileGDBPath, (String)currentPath);
        }
        catch (NoClassDefFoundError ncdfex) {
            FGDBHelperProxy.rethrow((NoClassDefFoundError)ncdfex);
            return null;
        }
    }

    public static void cleanerTrackObjectsInCurrentThread() throws B3PCatalogException {
        try {
            FGDBHelper.cleanerTrackObjectsInCurrentThread();
        }
        catch (NoClassDefFoundError ncdfex) {
            FGDBHelperProxy.rethrow((NoClassDefFoundError)ncdfex);
        }
    }

    public static void cleanerReleaseAllInCurrentThread() throws B3PCatalogException {
        try {
            FGDBHelper.cleanerReleaseAllInCurrentThread();
        }
        catch (NoClassDefFoundError ncdfex) {
            FGDBHelperProxy.rethrow((NoClassDefFoundError)ncdfex);
        }
    }
}

