/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.arcgis;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Scanner;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Shapefiles {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMetadata(String file) throws IOException, JSONException {
        if (!file.toLowerCase().endsWith(".shp")) {
            throw new IllegalArgumentException("File does not end with .shp: " + file);
        }
        JSONObject j = new JSONObject();
        String localFilename = new File(file).getName();
        String title = "";
        int dotIndex = localFilename.lastIndexOf(".");
        if (dotIndex > 0) {
            title = localFilename.substring(0, dotIndex);
        } else if (dotIndex == 0) {
            title = localFilename.substring(1);
        }
        j.put("title", (Object)title);
        FileChannel channel = new FileInputStream(file).getChannel();
        ShapefileHeader header = new ShapefileHeader();
        MappedByteBuffer bb = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        header.read((ByteBuffer)bb, true);
        channel.close();
        channel = null;
        file = file.substring(0, file.length() - 4) + ".dbf";
        j.put("type", (Object)header.getShapeType().name);
        j.put("version", header.getVersion());
        j.put("minX", header.minX());
        j.put("minY", header.minY());
        j.put("maxX", header.maxX());
        j.put("maxY", header.maxY());
        JSONObject dbf = new JSONObject();
        j.put("dbf", (Object)dbf);
        try {
            channel = new FileInputStream(file).getChannel();
            DbaseFileHeader dheader = new DbaseFileHeader();
            bb = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            dheader.readHeader((ByteBuffer)bb);
            dbf.put("numRecords", dheader.getNumRecords());
            JSONArray fields = new JSONArray();
            dbf.put("fields", (Object)fields);
            for (int i = 0; i < dheader.getNumFields(); ++i) {
                JSONObject field = new JSONObject();
                fields.put((Object)field);
                field.put("name", (Object)dheader.getFieldName(i));
                field.put("length", dheader.getFieldLength(i));
                field.put("decimalCount", dheader.getFieldDecimalCount(i));
                field.put("class", (Object)dheader.getFieldClass(i).getName().toString());
                field.put("type", (Object)(dheader.getFieldType(i) + ""));
            }
        }
        catch (Exception e) {
            dbf.put("error", (Object)e.toString());
        }
        finally {
            if (channel != null) {
                channel.close();
            }
        }
        file = file.substring(0, file.length() - 4) + ".prj";
        File f = new File(file);
        String prj = null;
        if (f.exists()) {
            Scanner s = new Scanner(f);
            prj = "";
            try {
                while (s.hasNextLine()) {
                    if (prj.length() > 0) {
                        prj = prj + "\n";
                    }
                    prj = prj + s.nextLine();
                }
            }
            finally {
                s.close();
            }
        }
        j.put("prj", prj);
        return j.toString();
    }
}

