/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import nl.b3p.catalog.B3PCatalogException;
import nl.b3p.catalog.config.Acl;
import nl.b3p.catalog.config.AclAccess;
import nl.b3p.catalog.config.CatalogAppConfig;
import nl.b3p.catalog.config.RoleAccess;
import nl.b3p.catalog.filetree.DirContent;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class Root {
    public static final String SEPARATOR = "/";
    @XmlAttribute
    private String name;
    private List<Acl> acl = new ArrayList();

    @XmlTransient
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Acl> getAcl() {
        return this.acl;
    }

    public void setAcl(List<Acl> acl) {
        this.acl = acl;
    }

    private List<RoleAccess> getDefaultAccessList() {
        return Arrays.asList(new RoleAccess("*", AclAccess.WRITE));
    }

    @XmlTransient
    public List<RoleAccess> getRoleAccessList() {
        if (this.acl.isEmpty()) {
            return this.getDefaultAccessList();
        }
        HashMap<String, AclAccess> m = new HashMap<String, AclAccess>();
        for (Acl thisAcl : this.acl) {
            for (String role : thisAcl.getRoles()) {
                AclAccess a = (AclAccess)m.get(role);
                if (a != null && thisAcl.getAccess().getSecurityLevel() <= a.getSecurityLevel()) continue;
                m.put(role, thisAcl.getAccess());
            }
        }
        ArrayList<RoleAccess> l = new ArrayList<RoleAccess>();
        for (Map.Entry e : m.entrySet()) {
            l.add(new RoleAccess((String)e.getKey(), (AclAccess)e.getValue()));
        }
        Collections.sort(l);
        return Collections.unmodifiableList(l);
    }

    public boolean isRequestUserAuthorizedFor(HttpServletRequest request, AclAccess minimumAccessLevel) {
        AclAccess highest = this.getRequestUserHighestAccessLevel(request);
        return highest.getSecurityLevel() >= minimumAccessLevel.getSecurityLevel();
    }

    public AclAccess getRequestUserHighestAccessLevel(HttpServletRequest request) {
        for (RoleAccess ra : this.getRoleAccessList()) {
            if ("none".equals(ra.getRole())) {
                return ra.getAccess();
            }
            if ("*".equals(ra.getRole()) && request.getUserPrincipal() != null) {
                return ra.getAccess();
            }
            if (!request.isUserInRole(ra.getRole())) continue;
            return ra.getAccess();
        }
        return AclAccess.NONE;
    }

    public abstract DirContent getDirContent(String var1) throws Exception;

    public static String getPathPart(String fullPath) {
        return fullPath.substring(fullPath.indexOf("/") + 1);
    }

    public static String getRootPart(String fullPath) {
        return fullPath.substring(0, fullPath.indexOf("/") + 1);
    }

    public static Root getRootForPath(String fullPath) throws B3PCatalogException {
        int i = fullPath.indexOf("/");
        if (i < 1) {
            throw new B3PCatalogException("Path needs root number e.g. 0/file.txt");
        }
        int index = Integer.parseInt(fullPath.substring(0, i));
        return (Root)CatalogAppConfig.getConfig().getRoots().get(index);
    }

    public static Root getRootForPath(String fullPath, HttpServletRequest request, AclAccess minimumAccessLevel) throws B3PCatalogException {
        Root r = Root.getRootForPath((String)fullPath);
        if (r.isRequestUserAuthorizedFor(request, minimumAccessLevel)) {
            return r;
        }
        throw new B3PCatalogException("Not authorized for required minimum access level " + minimumAccessLevel.name());
    }
}

