/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.stripes;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.catalog.config.AclAccess;
import nl.b3p.catalog.config.CatalogAppConfig;
import nl.b3p.catalog.config.FileRoot;
import nl.b3p.catalog.config.KBRoot;
import nl.b3p.catalog.config.Root;
import nl.b3p.catalog.config.SDERoot;
import nl.b3p.catalog.filetree.Dir;
import nl.b3p.catalog.filetree.DirContent;
import nl.b3p.catalog.resolution.HtmlErrorResolution;
import nl.b3p.catalog.stripes.DefaultAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@StrictBinding
public class FiletreeAction
extends DefaultAction {
    private static final Log log = LogFactory.getLog(FiletreeAction.class);
    private static final String DIRCONTENTS_JSP = "/WEB-INF/jsp/main/file/filetreeConnector.jsp";
    private DirContent dirContent;
    @Validate
    private String dir;

    public Resolution listDir() {
        log.debug((Object)("listDir: " + this.dir));
        return this.list(FileRoot.class);
    }

    public Resolution listSDEDir() {
        log.debug((Object)("listDir: " + this.dir));
        return this.list(SDERoot.class);
    }

    public Resolution listKBDir() {
        log.debug((Object)("listDir: " + this.dir));
        return this.list(KBRoot.class);
    }

    private Resolution list(Class clazz) {
        try {
            if (this.dir == null) {
                this.dirContent = this.getRoots(clazz);
            } else {
                Root r = Root.getRootForPath((String)this.dir, (HttpServletRequest)this.getContext().getRequest(), (AclAccess)AclAccess.READ);
                this.dirContent = r.getDirContent(this.dir);
                this.dirContent.sort();
            }
            return new ForwardResolution(DIRCONTENTS_JSP);
        }
        catch (Exception ex) {
            String message = "Niet gelukt directory inhoud te tonen";
            log.error((Object)message, (Throwable)ex);
            return new HtmlErrorResolution(message, ex);
        }
    }

    private DirContent getRoots(Class clazz) {
        DirContent dc = new DirContent();
        List roots = CatalogAppConfig.getConfig().getRoots();
        for (int i = 0; i < roots.size(); ++i) {
            Root r = (Root)roots.get(i);
            if (!r.getClass().equals(clazz) || !r.isRequestUserAuthorizedFor(this.getContext().getRequest(), AclAccess.READ)) continue;
            Dir d = new Dir();
            d.setPath(i + "/");
            d.setName(((Root)roots.get(i)).getName());
            dc.getDirs().add(d);
        }
        return dc;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public DirContent getDirContent() {
        return this.dirContent;
    }

    public void setDirContent(DirContent dirContent) {
        this.dirContent = dirContent;
    }
}

