/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.catalog.config.CSWServerConfig;
import nl.b3p.catalog.config.CatalogAppConfig;
import nl.b3p.catalog.resolution.HtmlResolution;
import nl.b3p.catalog.stripes.MetadataAction;
import nl.b3p.catalog.xml.DocumentHelper;
import nl.b3p.catalog.xml.mdeXml2Html;
import nl.b3p.csw.client.CswClient;
import nl.b3p.csw.client.InputById;
import nl.b3p.csw.client.OutputById;
import nl.b3p.csw.jaxb.csw.TransactionResponse;
import nl.b3p.csw.jaxb.csw.TransactionResponseType;
import nl.b3p.csw.server.CswServable;
import nl.b3p.csw.server.GeoNetworkCswServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.json.JSONObject;
import org.xml.sax.InputSource;

@StrictBinding
public class PublishActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(PublishActionBean.class);
    private ActionBeanContext context;
    private static final String EXPORT_TYPE_ALL = "all";
    private static final String EXPORT_TYPE_DATASETS = "datasets";
    private static final String EXPORT_TYPE_SERVICES = "services";
    @Validate(required=true, on={"publish"})
    private String exportType = "datasets";
    @Validate
    private String cswServerName;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getExportType() {
        return this.exportType;
    }

    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    public String getCswServerName() {
        return this.cswServerName;
    }

    public void setCswServerName(String cswServerName) {
        this.cswServerName = cswServerName;
    }

    private CswClient getCswClient() {
        CSWServerConfig cfg = null;
        if (this.cswServerName != null && !this.cswServerName.isEmpty()) {
            List lcfgs = CatalogAppConfig.getConfig().getCswServers();
            for (CSWServerConfig lcfg : lcfgs) {
                if (!this.cswServerName.equals(lcfg.getCswName())) continue;
                cfg = lcfg;
                break;
            }
        }
        if (cfg == null) {
            cfg = CatalogAppConfig.getConfig().getDefaultCswServer();
        }
        return new CswClient((CswServable)new GeoNetworkCswServer(cfg.getLoginUrl(), cfg.getUrl(), cfg.getUsername(), cfg.getPassword()));
    }

    public Resolution optionsList() throws Exception {
        List lcfgs = CatalogAppConfig.getConfig().getCswServers();
        StringBuilder sb = new StringBuilder();
        for (CSWServerConfig lcfg : lcfgs) {
            sb.append("<option value=\"");
            sb.append(lcfg.getCswName());
            sb.append("\">");
            sb.append(lcfg.getCswName());
            sb.append("</option>");
        }
        return new HtmlResolution(sb.toString());
    }

    public Resolution publish() throws Exception {
        Document md = this.getMDDocument(this.exportType);
        String fileIdentifier = new OutputById(null).getUUID(md.getRootElement());
        JSONObject jo = new JSONObject();
        jo.put("fileIdentifier", (Object)fileIdentifier);
        CswClient csw = this.getCswClient();
        if (csw == null) {
            return new ErrorResolution(404);
        }
        OutputById out = csw.search(new InputById(fileIdentifier));
        boolean exists = !out.getSearchResultsW3C().isEmpty();
        jo.put("exists", exists);
        String mdString = new XMLOutputter(Format.getPrettyFormat()).outputString(md);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        org.w3c.dom.Document doc = db.parse(new InputSource(new StringReader(mdString)));
        TransactionResponse response = exists ? csw.update(fileIdentifier, doc) : csw.insert(doc);
        jo.put("totalInserted", (Object)((TransactionResponseType)response.getValue()).getTransactionSummary().getTotalInserted());
        jo.put("totalUpdated", (Object)((TransactionResponseType)response.getValue()).getTransactionSummary().getTotalUpdated());
        return new StreamingResolution("application/json", (Reader)new StringReader(jo.toString()));
    }

    private Document getMDDocument(String exportType) throws Exception {
        Document md = (Document)this.getContext().getRequest().getSession().getAttribute(MetadataAction.SESSION_KEY_METADATA_XML);
        if (md == null) {
            throw new IllegalStateException("Geen metadatadocument geopend in deze sessie");
        }
        Boolean serviceMode = mdeXml2Html.getXSLParam((String)"serviceMode_init");
        Boolean datasetMode = mdeXml2Html.getXSLParam((String)"datasetMode_init");
        if (EXPORT_TYPE_DATASETS.equals(exportType)) {
            serviceMode = Boolean.FALSE;
            datasetMode = Boolean.TRUE;
        } else if (EXPORT_TYPE_SERVICES.equals(exportType)) {
            serviceMode = Boolean.TRUE;
            datasetMode = Boolean.FALSE;
        } else if (EXPORT_TYPE_ALL.equals(exportType)) {
            serviceMode = Boolean.TRUE;
            datasetMode = Boolean.TRUE;
        }
        Document mdCopy = new Document((Element)md.getRootElement().clone());
        mdeXml2Html.cleanUpMetadata((Document)mdCopy, (boolean)(serviceMode == null ? false : serviceMode), (boolean)(datasetMode == null ? false : datasetMode));
        mdeXml2Html.removeEmptyNodes((Document)mdCopy);
        if (EXPORT_TYPE_DATASETS.equals(exportType) || EXPORT_TYPE_SERVICES.equals(exportType)) {
            Element MD_Metadata = DocumentHelper.getMD_Metadata((Document)mdCopy);
            MD_Metadata.detach();
            mdCopy = new Document(MD_Metadata);
        }
        return mdCopy;
    }
}

