/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.catalog.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import nl.b3p.catalog.B3PCatalogException;
import nl.b3p.catalog.config.CatalogAppConfig;
import nl.b3p.catalog.xml.DocumentHelper;
import nl.b3p.catalog.xml.Namespaces;
import nl.b3p.catalog.xml.XPathHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;
import org.jdom.xpath.XPath;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class mdeXml2Html {
    private static final Log log = LogFactory.getLog(mdeXml2Html.class);
    private static TransformerFactory transformerFactory;
    private static Map<String, Templates> transformerTemplates;

    public static Boolean getXSLParam(String param) throws B3PCatalogException {
        Map params = CatalogAppConfig.getConfig().getMdeConfig();
        if (params == null) {
            throw new B3PCatalogException("Transformer params missing from configuration!");
        }
        String paramValue = (String)params.get(param);
        if (paramValue == null) {
            return null;
        }
        return Boolean.valueOf(paramValue);
    }

    private static InputStream getXslStream(String xslName) throws TransformerConfigurationException, FileNotFoundException {
        CatalogAppConfig cfg = CatalogAppConfig.getConfig();
        Map params = cfg.getMdeConfig();
        if (params == null) {
            throw new TransformerConfigurationException("Transformers are missing from configuration!");
        }
        String xslPath = (String)params.get(xslName);
        if (xslPath == null) {
            return null;
        }
        File f = new File(xslPath);
        if (!f.isAbsolute()) {
            f = new File(cfg.getConfigFilePath(), xslPath);
        }
        return new FileInputStream(f);
    }

    private static Document transformIntern(Document doc, String xslName, Boolean viewMode, boolean ignoreAllowed) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        log.debug((Object)("XML before transformation with '" + xslName + "':\n" + DocumentHelper.getDocumentString((Document)doc)));
        Templates aTemplates = null;
        if (!transformerTemplates.containsKey(xslName)) {
            InputStream is = mdeXml2Html.getXslStream((String)xslName);
            if (is != null) {
                if (transformerFactory == null) {
                    transformerFactory = TransformerFactory.newInstance();
                }
                aTemplates = transformerFactory.newTemplates(new StreamSource(is));
            }
            transformerTemplates.put(xslName, aTemplates);
        } else {
            aTemplates = (Templates)transformerTemplates.get(xslName);
        }
        if (aTemplates == null) {
            if (ignoreAllowed) {
                return doc;
            }
            throw new TransformerConfigurationException("Transformer [" + xslName + "] is missing from configuration!");
        }
        Transformer t = aTemplates.newTransformer();
        Map params = CatalogAppConfig.getConfig().getMdeConfig();
        if (params != null) {
            for (Map.Entry param : params.entrySet()) {
                t.setParameter((String)param.getKey(), param.getValue());
            }
            if (viewMode != null) {
                t.setParameter("globalReadonly_init", viewMode.toString());
            }
        }
        JDOMResult result = new JDOMResult();
        t.transform((Source)new JDOMSource(doc), (Result)result);
        log.debug((Object)("XML after transformation with '" + xslName + "':\n" + DocumentHelper.getDocumentString((Document)result.getDocument())));
        return result.getDocument();
    }

    public static Document transform(Document doc) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.transform((Document)doc, null);
    }

    public static Document transform(Document doc, Boolean viewMode) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.transformIntern((Document)doc, (String)"mdemain", (Boolean)viewMode, (boolean)false);
    }

    public static Document preprocess(Document doc) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.preprocess((Document)doc, null);
    }

    public static Document preprocess(Document doc, Boolean viewMode) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.transformIntern((Document)doc, (String)"mdeXmlPreprocessor", (Boolean)viewMode, (boolean)false);
    }

    public static Document iSO19115toDCSynchronizer(Document doc) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.iSO19115toDCSynchronizer((Document)doc, null);
    }

    public static Document iSO19115toDCSynchronizer(Document doc, Boolean viewMode) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.transformIntern((Document)doc, (String)"ISO19115toDC", (Boolean)viewMode, (boolean)true);
    }

    public static Document dCtoISO19115Synchronizer(Document doc) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.dCtoISO19115Synchronizer((Document)doc, null);
    }

    public static Document dCtoISO19115Synchronizer(Document doc, Boolean viewMode) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.transformIntern((Document)doc, (String)"DCtoISO19115", (Boolean)viewMode, (boolean)true);
    }

    public static Document extraSync1(Document doc) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.extraSync1((Document)doc, null);
    }

    public static Document extraSync1(Document doc, Boolean viewMode) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.transformIntern((Document)doc, (String)"extrasync1", (Boolean)viewMode, (boolean)true);
    }

    public static Document extraSync2(Document doc) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.extraSync2((Document)doc, null);
    }

    public static Document extraSync2(Document doc, Boolean viewMode) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.transformIntern((Document)doc, (String)"extrasync2", (Boolean)viewMode, (boolean)true);
    }

    public static Document extraPreprocessor1(Document doc) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.extraPreprocessor1((Document)doc, null);
    }

    public static Document extraPreprocessor1(Document doc, Boolean viewMode) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.transformIntern((Document)doc, (String)"extrapreprocessor1", (Boolean)viewMode, (boolean)true);
    }

    public static Document extraPreprocessor2(Document doc) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.extraPreprocessor2((Document)doc, null);
    }

    public static Document extraPreprocessor2(Document doc, Boolean viewMode) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.transformIntern((Document)doc, (String)"extrapreprocessor2", (Boolean)viewMode, (boolean)true);
    }

    public static Document extraPostprocessor1(Document doc) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.extraPostprocessor1((Document)doc, null);
    }

    public static Document extraPostprocessor1(Document doc, Boolean viewMode) throws JDOMException, IOException, TransformerConfigurationException, TransformerException {
        return mdeXml2Html.transformIntern((Document)doc, (String)"extrapostprocessor1", (Boolean)viewMode, (boolean)true);
    }

    public static void addUUID(Document xmlDoc, boolean overwriteUUIDs) throws JDOMException {
        Element mdNode = XPathHelper.selectSingleElement((Object)xmlDoc, (String)"/*/gmd:MD_Metadata");
        if (mdNode == null) {
            return;
        }
        List mdChildren = mdNode.getChildren("fileIdentifier", Namespaces.GMD);
        boolean foundIdentifier = false;
        for (Element e : mdChildren) {
            if (foundIdentifier) {
                mdNode.removeContent((Content)e);
                continue;
            }
            foundIdentifier = true;
            Element fics = e.getChild("CharacterString", Namespaces.GCO);
            if (!overwriteUUIDs && !fics.getTextNormalize().isEmpty()) continue;
            fics.setText(UUID.randomUUID().toString().toLowerCase());
        }
    }

    public static void addDateStamp(Document xmlDoc, boolean overwrite) throws JDOMException {
        Element dateNode = XPathHelper.selectSingleElement((Object)xmlDoc, (String)"/*/gmd:MD_Metadata/gmd:dateStamp/gco:Date");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (overwrite || dateNode.getTextNormalize().isEmpty()) {
            dateNode.setText(sdf.format(new Date()));
        }
    }

    public static Element createPath(String path, String endPath) throws Exception {
        String toBeCreatedPath;
        Element startNode = null;
        Element currentNode = null;
        if (path != null && endPath != null && path.equals(endPath.substring(0, path.length())) && (toBeCreatedPath = endPath.substring(path.length())).length() > 0) {
            if (toBeCreatedPath.indexOf("/") == 0) {
                toBeCreatedPath = toBeCreatedPath.substring(1);
            }
            String[] pathList = toBeCreatedPath.split("/");
            for (int i = 0; i < (pathList.length == 1 ? 1 : pathList.length - 1); ++i) {
                String tempNodeName = pathList[i];
                if (tempNodeName.contains("[")) {
                    tempNodeName = tempNodeName.substring(0, tempNodeName.indexOf("["));
                }
                if (tempNodeName == null) continue;
                Namespace tns = Namespaces.getFullNameSpace((String)tempNodeName);
                Element tNode = new Element(Namespaces.getLocalName((String)tempNodeName), tns);
                if (currentNode == null) {
                    startNode = tNode;
                } else {
                    currentNode.addContent((Content)tNode);
                }
                currentNode = tNode;
            }
        }
        return startNode;
    }

    public static void cleanUpMetadata(Document doc, boolean serviceMode, boolean datasetMode) throws B3PCatalogException {
        Element mdNode = DocumentHelper.getMD_Metadata((Document)doc);
        ArrayList<String> elementsToBeRemoved = new ArrayList<String>();
        if (!serviceMode) {
            elementsToBeRemoved.add("SV_ServiceIdentification");
        }
        if (!datasetMode) {
            elementsToBeRemoved.add("MD_DataIdentification");
        }
        mdeXml2Html.cleanUpMetadata((Element)mdNode, elementsToBeRemoved);
    }

    public static void cleanUpMetadata(Element mdNode, List<String> elementsToBeRemoved) throws B3PCatalogException {
        List mdChildren = mdNode.getChildren();
        ArrayList<Element> childrenToBeRemoved = new ArrayList<Element>();
        for (Element e : mdChildren) {
            String localName = e.getName();
            boolean removed = false;
            for (String etbr : elementsToBeRemoved) {
                if (!localName.equals(etbr)) continue;
                childrenToBeRemoved.add(e);
                removed = true;
            }
            if (removed) continue;
            mdeXml2Html.cleanUpMetadata((Element)e, elementsToBeRemoved);
        }
        for (Element re : childrenToBeRemoved) {
            mdNode.removeContent((Content)re);
        }
    }

    public static void applySectionChange(Document xmlDoc, JSONObject change) throws Exception {
        String action = change.getString("action");
        String path = change.getString("path");
        if ("add".equals(action)) {
            boolean above = change.getBoolean("above");
            String endPath = change.getString("endPath");
            mdeXml2Html.addElementOrSection((Document)xmlDoc, (String)path, (String)endPath, (boolean)above);
        } else {
            mdeXml2Html.deleteElementOrSection((Document)xmlDoc, (String)path);
        }
    }

    public static Element addElementOrSection(Document xmlDoc, String path, String endPath, boolean above) throws JDOMException, Exception {
        Element parent = mdeXml2Html.getParentElement((Document)xmlDoc, (String)path);
        if (parent == null) {
            return null;
        }
        Element toBeDuplicatedNode = XPathHelper.selectSingleElement((Object)xmlDoc, (String)path);
        if (toBeDuplicatedNode == null) {
            log.debug((Object)("Path: '" + path + "' not found."));
            return null;
        }
        Element newNode = mdeXml2Html.createPath((String)mdeXml2Html.calcParentPath((String)path), (String)endPath);
        log.debug((Object)"Inserting node...");
        int currentIndex = 0;
        for (int i = 0; i < parent.getContentSize(); ++i) {
            Content c = parent.getContent(i);
            if (!c.equals((Object)toBeDuplicatedNode)) continue;
            currentIndex = i;
            break;
        }
        if (!above) {
            ++currentIndex;
        }
        parent.addContent(currentIndex, (Content)newNode);
        return parent;
    }

    public static Element deleteElementOrSection(Document xmlDoc, String elementOrSectionPath) throws JDOMException, Exception {
        Element parent = mdeXml2Html.getParentElement((Document)xmlDoc, (String)elementOrSectionPath);
        if (parent == null) {
            return null;
        }
        Element toBeDeletedNode = XPathHelper.selectSingleElement((Object)xmlDoc, (String)elementOrSectionPath);
        String eName = toBeDeletedNode.getName();
        List elems = parent.getChildren(eName, toBeDeletedNode.getNamespace());
        if (elems.size() < 2) {
            throw new Exception("Laatste element mag niet worden verwijderd op pad " + elementOrSectionPath);
        }
        parent.removeContent((Content)toBeDeletedNode);
        return parent;
    }

    public static String getSavedValueOnServerSide(Document xmlDoc, String thePath, String attrName) throws JDOMException {
        String codeListValue;
        Attribute a;
        Element xmlElement = XPathHelper.selectSingleElement((Object)xmlDoc, (String)thePath);
        String savedValue = xmlElement.getValue();
        String attributeValue = null;
        if (attrName != null && (a = xmlElement.getAttribute(attrName)) != null) {
            attributeValue = a.getValue();
        }
        if ((codeListValue = xmlElement.getAttribute("codeListValue").getValue()) != null) {
            savedValue = codeListValue;
        } else if (attributeValue != null) {
            savedValue = attributeValue;
        }
        return savedValue;
    }

    public static void applyElementChanges(Document xmlDoc, JSONArray changes) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("applyElementChanges(): before xml = " + DocumentHelper.getDocumentString((Document)xmlDoc)));
        }
        for (int i = 0; i < changes.length(); ++i) {
            JSONObject change = changes.getJSONObject(i);
            mdeXml2Html.updateElement((Document)xmlDoc, (String)change.getString("path"), (String)change.getString("attrName"), (String)change.getString("newValue"), (String)change.getString("newText"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("applyElementChanges(): after xml = " + DocumentHelper.getDocumentString((Document)xmlDoc)));
        }
    }

    public static void updateElement(Document xmlDoc, String xpath, String attrName, String newValue, String newText) throws JDOMException, Exception {
        Element targetNode = XPathHelper.selectSingleElement((Object)xmlDoc, (String)xpath);
        if (targetNode == null) {
            throw new Exception("Save path \"" + xpath + "\" in XML document not found");
        }
        if (targetNode.getAttribute("codeListValue") != null) {
            targetNode.setAttribute("codeListValue", newValue);
            if (newText == null) {
                newText = newValue;
            }
            targetNode.setText(newText);
        } else if (targetNode.getAttribute(attrName) != null) {
            targetNode.setAttribute(attrName, newValue);
        } else {
            targetNode.setText(newValue);
        }
    }

    private static boolean removeEmptyNode(Element node) {
        String value;
        List ecs;
        List oecs;
        Element oe;
        String value2;
        boolean deleteOK = true;
        List children = node.getChildren();
        ArrayList<Element> childrenToBeRemoved = new ArrayList<Element>();
        for (Element e : children) {
            if (mdeXml2Html.removeEmptyNode((Element)e)) {
                childrenToBeRemoved.add(e);
                continue;
            }
            deleteOK = false;
        }
        for (Element re : childrenToBeRemoved) {
            node.removeContent((Content)re);
        }
        if (deleteOK && (value2 = StringUtils.deleteWhitespace((String)node.getText())) != null && !value2.isEmpty()) {
            deleteOK = false;
        }
        if (deleteOK) {
            List attrs = node.getAttributes();
            for (Attribute a : attrs) {
                String n = a.getName();
                if (n.equals("codeList") || n.equals("uom") || n.startsWith("xmlns:")) continue;
                String value3 = a.getValue();
                if (n.equals("codeListValue") && (value3 == null || value3.isEmpty())) continue;
                deleteOK = false;
                break;
            }
        }
        if (!deleteOK && node.getName().equals("CI_RoleCode")) {
            deleteOK = true;
            oe = node.getParentElement().getParentElement();
            oecs = oe.getChildren();
            block3: for (Element e : oecs) {
                if (!e.getName().equals("organisationName")) continue;
                ecs = e.getChildren();
                for (Element o : ecs) {
                    if (!o.getName().equals("CharacterString") || (value = StringUtils.deleteWhitespace((String)o.getText())) == null || value.isEmpty()) continue;
                    deleteOK = false;
                    continue block3;
                }
            }
        }
        if (!deleteOK && node.getName().equals("CI_DateTypeCode")) {
            deleteOK = true;
            oe = node.getParentElement().getParentElement();
            oecs = oe.getChildren();
            block5: for (Element e : oecs) {
                if (!e.getName().equals("date")) continue;
                ecs = e.getChildren();
                for (Element o : ecs) {
                    if (!o.getName().equals("Date") && !o.getName().equals("DateTime") || (value = StringUtils.deleteWhitespace((String)o.getText())) == null || value.isEmpty()) continue;
                    deleteOK = false;
                    continue block5;
                }
            }
        }
        return deleteOK;
    }

    public static void removeEmptyNodes(Document xmlDoc) {
        Element e = xmlDoc.getRootElement();
        boolean deleteOK = mdeXml2Html.removeEmptyNode((Element)e);
        if (deleteOK) {
            // empty if block
        }
    }

    public static String calcParentPath(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        int pos = path.lastIndexOf("/");
        if (pos < 0) {
            return null;
        }
        return path.substring(0, pos);
    }

    public static Element getParentElement(Document xmlDoc, String path) throws JDOMException {
        String parentPath = mdeXml2Html.calcParentPath((String)path);
        if (parentPath == null) {
            return null;
        }
        return XPathHelper.selectSingleElement((Object)xmlDoc, (String)parentPath);
    }

    public static Document convertElem2Doc(Element e) {
        Document xmlDoc = e.getDocument();
        e.detach();
        xmlDoc.setRootElement(e);
        return xmlDoc;
    }

    public static String convertElement2Html(Element e) throws JDOMException, Exception {
        return mdeXml2Html.convertElement2Html((Element)e, null);
    }

    public static String convertElement2Html(Element e, Boolean viewMode) throws JDOMException, Exception {
        if (e == null) {
            return null;
        }
        Document eDoc = mdeXml2Html.convertElem2Doc((Element)e);
        Document htmlDoc = mdeXml2Html.transform((Document)eDoc, (Boolean)viewMode);
        return DocumentHelper.getDocumentString((Document)htmlDoc);
    }

    public static String buildXPath(Element e) {
        Element e2 = e;
        String fullName = e.getName();
        if (e.getNamespacePrefix() != null && !e.getNamespacePrefix().isEmpty()) {
            fullName = e.getNamespacePrefix() + ":" + fullName;
        }
        StringBuffer sb = new StringBuffer(fullName);
        for (Parent p = e.getParent(); p != null && p instanceof Element; p = p.getParent()) {
            int i = p.indexOf((Content)e2);
            if (i > 0) {
                sb.append("[" + (i + 1) + "]");
            }
            sb.insert(0, "/");
            e2 = (Element)p;
            fullName = e2.getName();
            if (e2.getNamespacePrefix() != null && !e2.getNamespacePrefix().isEmpty()) {
                fullName = e2.getNamespacePrefix() + ":" + fullName;
            }
            sb.insert(0, fullName);
        }
        sb.insert(0, "/");
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        Document mdDoc = DocumentHelper.getMetadataDocument((String)"empty");
        Document ppDoc = mdeXml2Html.preprocess((Document)mdDoc);
        mdeXml2Html.addDateStamp((Document)ppDoc, (boolean)false);
        mdeXml2Html.addUUID((Document)ppDoc, (boolean)true);
        Element parent = null;
        parent = mdeXml2Html.addElementOrSection((Document)ppDoc, (String)"/metadata/gmd:MD_Metadata/gmd:fileIdentifier", (String)"/metadata/gmd:MD_Metadata/gmd:fileIdentifier/gco:CharacterString", (boolean)false);
        parent = mdeXml2Html.addElementOrSection((Document)ppDoc, (String)"/metadata/gmd:MD_Metadata/gmd:fileIdentifier", (String)"/metadata/gmd:MD_Metadata/gmd:fileIdentifier/gco:CharacterString", (boolean)false);
        ppDoc = mdeXml2Html.preprocess((Document)ppDoc);
        parent = mdeXml2Html.deleteElementOrSection((Document)ppDoc, (String)"/metadata/gmd:MD_Metadata/gmd:fileIdentifier[2]");
        String attrName = null;
        String newValue = "brabants";
        String newText = null;
        mdeXml2Html.updateElement((Document)ppDoc, (String)"/metadata/gmd:MD_Metadata/gmd:language/gmd:LanguageCode", attrName, (String)newValue, newText);
        String value = mdeXml2Html.getSavedValueOnServerSide((Document)ppDoc, (String)"/metadata/gmd:MD_Metadata/gmd:language/gmd:LanguageCode", attrName);
        Document htmlDoc = mdeXml2Html.transform((Document)ppDoc);
        String xpathString = "//div[@id=\"algemeen\" and @class=\"ui-mde-tab-definition\"]";
        XPath xpath = XPath.newInstance((String)xpathString);
        Object o = xpath.selectSingleNode((Object)htmlDoc);
        String s = null;
        if (o != null) {
            s = new XMLOutputter(Format.getPrettyFormat()).outputString((Element)o);
        }
        System.out.println("-----------------START--------------------");
        System.out.println(s);
        System.out.println("-----------------END----------------------");
    }

    static {
        transformerTemplates = new HashMap();
    }
}

