/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imagetool;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.commons.services.HttpClientConfigured;
import nl.b3p.imagetool.ArcImsImageCollector;
import nl.b3p.imagetool.ArcServerImageCollector;
import nl.b3p.imagetool.CombineArcIMSUrl;
import nl.b3p.imagetool.CombineArcServerUrl;
import nl.b3p.imagetool.CombineImageUrl;
import nl.b3p.imagetool.CombineStaticImageUrl;
import nl.b3p.imagetool.CombineWmsUrl;
import nl.b3p.imagetool.ImageCollector;
import nl.b3p.imagetool.ReferencedImage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageManager {
    private static final Log log = LogFactory.getLog(ImageManager.class);
    private static final int MAX_TREADS = 8;
    private static int instanceCount = 0;
    private final List<ImageCollector> ics = new ArrayList<ImageCollector>();
    private HttpClientConfigured hcc = null;
    private ExecutorService threadPool = null;
    private CompletionService<ImageCollector> pool = null;
    private final int instanceNumber = ++instanceCount;
    protected static final String host = null;
    protected static final int port = -1;

    public ImageManager(List urls, int maxResponseTime) {
        this(urls, maxResponseTime, null, null);
    }

    public ImageManager(List<CombineImageUrl> urls, int maxResponseTime, String uname, String pw) {
        if (urls == null || urls.size() <= 0) {
            throw new IllegalArgumentException();
        }
        log.info((Object)String.format("%s initialized with %d urls, max response time %dms", this.getClass().getName(), urls.size(), maxResponseTime));
        this.threadPool = Executors.newFixedThreadPool(8);
        this.pool = new ExecutorCompletionService<ImageCollector>(this.threadPool);
        B3PCredentials credentials = new B3PCredentials();
        credentials.setUserName(uname);
        credentials.setPassword(pw);
        credentials.setPreemptive(false);
        this.hcc = new HttpClientConfigured(credentials, maxResponseTime);
        for (CombineImageUrl ciu : urls) {
            ImageCollector ic = null;
            ic = ciu instanceof CombineWmsUrl ? new ImageCollector(this, ciu, this.hcc) : (ciu instanceof CombineArcIMSUrl ? new ArcImsImageCollector(this, ciu, this.hcc) : (ciu instanceof CombineArcServerUrl ? new ArcServerImageCollector(this, ciu, this.hcc) : new ImageCollector(this, ciu, this.hcc)));
            this.ics.add(ic);
        }
    }

    public void process() throws Exception {
        for (ImageCollector ic : this.ics) {
            if (ic.getStatus() != 0) continue;
            this.pool.submit(ic);
        }
        for (int i = 0; i < this.ics.size(); ++i) {
            this.pool.poll(5L, TimeUnit.MINUTES).get();
        }
    }

    public List<ReferencedImage> getCombinedImages() throws Exception {
        ImageCollector ic = null;
        Iterator<ImageCollector> it = this.ics.iterator();
        ArrayList<ReferencedImage> allImages = new ArrayList<ReferencedImage>();
        while (it.hasNext()) {
            ic = it.next();
            int status = ic.getStatus();
            if (status != 2) continue;
            ReferencedImage image = new ReferencedImage(ic);
            CombineImageUrl ciu = ic.getCombinedImageUrl();
            image.setAlpha(ciu.getAlpha());
            if (ciu instanceof CombineStaticImageUrl) {
                CombineStaticImageUrl csiu = (CombineStaticImageUrl)ciu;
                image.setHeight(csiu.getHeight());
                image.setWidth(csiu.getWidth());
                image.setX(csiu.getX());
                image.setY(csiu.getY());
            }
            allImages.add(image);
        }
        if (allImages.size() > 0) {
            return allImages;
        }
        return null;
    }

    public void close() {
        if (this.hcc != null) {
            this.hcc.close();
        }
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }
}

