/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imagetool;

import java.util.ArrayList;
import java.util.List;
import nl.b3p.imagetool.Bbox;
import nl.b3p.imagetool.CombineImageUrl;
import nl.b3p.imagetool.CombineStaticImageUrl;
import nl.b3p.imagetool.ImageBbox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CombineTileImageUrl
extends CombineImageUrl {
    private Bbox serviceBbox = null;
    private Double[] resolutions = null;
    private Integer tileWidth = 256;
    private Integer tileHeight = 256;
    private Integer nextPosX = null;
    private Integer nextPosY = null;
    private boolean correctTiles = true;
    protected String extension;
    protected static double epsilon = 1.0E-10;

    public CombineTileImageUrl(CombineTileImageUrl ctiu) {
        super(ctiu);
    }

    public CombineTileImageUrl() {
    }

    public Integer getClosestZoomlevel(ImageBbox requestBbox) {
        Double res = null;
        if (requestBbox != null) {
            res = requestBbox.getUnitsPixelX();
        }
        Integer zoomlevel = this.resolutions.length - 1;
        if (this.resolutions != null) {
            for (int i = 0; i < this.resolutions.length; ++i) {
                Double testRes = this.resolutions[i];
                if (res - testRes < 1.0E-10 && res - testRes > -1.0E-10) {
                    zoomlevel = i;
                    break;
                }
                if (!(res >= testRes)) continue;
                zoomlevel = i;
                break;
            }
        }
        return zoomlevel;
    }

    @Override
    public List<CombineImageUrl> calculateNewUrl(ImageBbox imbbox) {
        ArrayList<CombineImageUrl> tileImages = new ArrayList<CombineImageUrl>();
        Integer zoomlevel = this.getClosestZoomlevel(imbbox);
        Double closestResolution = this.resolutions[zoomlevel];
        Double tileWidthMapUnits = null;
        Double tileHeightMapUnits = null;
        if (this.getTileWidth() != null && closestResolution != null) {
            tileWidthMapUnits = (double)this.getTileWidth().intValue() * closestResolution;
        }
        if (this.getTileWidth() != null && closestResolution != null) {
            tileHeightMapUnits = (double)this.getTileWidth().intValue() * closestResolution;
        }
        Integer minTileIndexX = null;
        Integer maxTileIndexX = null;
        Integer minTileIndexY = null;
        Integer maxTileIndexY = null;
        Bbox bbox = imbbox.getBbox();
        if (tileWidthMapUnits != null && tileWidthMapUnits > 0.0 && tileHeightMapUnits != null && tileHeightMapUnits > 0.0) {
            minTileIndexX = this.getTileIndexX(bbox.getMinx(), closestResolution, false);
            maxTileIndexX = this.getTileIndexX(bbox.getMaxx(), closestResolution, true);
            minTileIndexY = this.getTileIndexY(bbox.getMiny(), closestResolution, false);
            maxTileIndexY = this.getTileIndexY(bbox.getMaxy(), closestResolution, true);
        }
        for (int ix = minTileIndexX.intValue(); ix <= maxTileIndexX; ++ix) {
            this.nextPosY = null;
            for (int iy = minTileIndexY.intValue(); iy <= maxTileIndexY; ++iy) {
                double[] tempBbox;
                tempBbox = new double[]{this.serviceBbox.getMinx() + (double)ix * tileWidthMapUnits, this.serviceBbox.getMiny() + (double)iy * tileHeightMapUnits, tempBbox[0] + tileWidthMapUnits, tempBbox[1] + tileHeightMapUnits};
                Bbox tileBbox = new Bbox(tempBbox);
                CombineStaticImageUrl tile = this.createTile(imbbox, tileBbox, ix, iy, zoomlevel);
                Integer tempNextY = tile.getY() + this.getTileDirectionY() * tile.getHeight();
                Integer tempNextX = null;
                if (iy == maxTileIndexY) {
                    tempNextX = tile.getX() + this.getTileDirectionX() * tile.getWidth();
                }
                if (this.correctTiles) {
                    tile = this.correctTile(tile);
                }
                this.nextPosY = tempNextY;
                if (tempNextX != null) {
                    this.nextPosX = tempNextX;
                }
                tileImages.add(tile);
            }
        }
        return tileImages;
    }

    public CombineStaticImageUrl createTile(ImageBbox imageBbox, Bbox tileBbox, int indexX, int indexY, int zoomlevel) {
        CombineStaticImageUrl tile = new CombineStaticImageUrl();
        tile.setBbox(tileBbox);
        tile.setUrl(this.url);
        Bbox requestBbox = imageBbox.getBbox();
        Double msx = (requestBbox.getMaxx() - requestBbox.getMinx()) / (double)imageBbox.getWidth().intValue();
        Double msy = (requestBbox.getMaxy() - requestBbox.getMiny()) / (double)imageBbox.getHeight().intValue();
        Long posX = Math.round((tileBbox.getMinx() - requestBbox.getMinx()) / msx);
        Long posY = Math.round((requestBbox.getMaxy() - tileBbox.getMaxy()) / msy);
        Long width = Math.round((tileBbox.getMaxx() - tileBbox.getMinx()) / msx);
        Long height = Math.round((tileBbox.getMaxy() - tileBbox.getMiny()) / msy);
        tile.setX(posX.intValue());
        tile.setY(posY.intValue());
        tile.setWidth(width.intValue());
        tile.setHeight(height.intValue());
        tile.setUrl(this.createUrl(imageBbox, tileBbox, indexX, indexY, zoomlevel));
        return tile;
    }

    public Integer getTileIndexX(Double xCoord, Double res, boolean max) {
        Double tileSpanX = res * (double)this.getTileWidth().intValue();
        Double tileIndexX = Math.floor((xCoord - this.serviceBbox.getMinx()) / (tileSpanX + epsilon));
        if (tileIndexX < 0.0) {
            tileIndexX = 0.0;
        }
        Double maxBboxX = Math.floor((this.serviceBbox.getMaxx() - this.serviceBbox.getMinx()) / (tileSpanX + epsilon));
        if (tileIndexX > maxBboxX) {
            tileIndexX = maxBboxX;
        }
        return tileIndexX.intValue();
    }

    public Integer getTileIndexY(double yCoord, Double res, boolean max) {
        Double tileSpanY = res * (double)this.getTileHeight().intValue();
        Double tileIndexY = Math.floor((yCoord - this.serviceBbox.getMiny()) / (tileSpanY + epsilon));
        if (tileIndexY < 0.0) {
            tileIndexY = 0.0;
        }
        Double maxBboxY = Math.floor((this.serviceBbox.getMaxy() - this.serviceBbox.getMiny()) / (tileSpanY + epsilon));
        if (tileIndexY > maxBboxY) {
            tileIndexY = maxBboxY;
        }
        return tileIndexY.intValue();
    }

    private CombineStaticImageUrl correctTile(CombineStaticImageUrl tile) {
        Integer diff;
        if (this.nextPosX != null && !this.nextPosX.equals(tile.getX())) {
            diff = this.nextPosX - tile.getX();
            if (this.getTileDirectionX() < 0) {
                tile.setWidth(tile.getWidth() + diff);
            } else {
                tile.setX(tile.getX() + diff);
                tile.setWidth(tile.getWidth() - diff);
            }
        }
        if (this.nextPosY != null && !this.nextPosY.equals(tile.getY())) {
            diff = this.nextPosY - tile.getY();
            if (this.getTileDirectionY() < 0) {
                tile.setHeight(tile.getHeight() + diff);
            } else {
                tile.setY(tile.getY() + diff);
                tile.setHeight(tile.getHeight() - diff);
            }
        }
        return tile;
    }

    public Bbox getServiceBbox() {
        return this.serviceBbox;
    }

    public void setServiceBbox(Bbox bbox) {
        this.serviceBbox = bbox;
    }

    public Double[] getResolutions() {
        return this.resolutions;
    }

    public void setResolutions(Double[] resolutions) {
        this.resolutions = resolutions;
    }

    public Integer getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(Integer tileWidth) {
        this.tileWidth = tileWidth;
    }

    public Integer getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(Integer tileHeight) {
        this.tileHeight = tileHeight;
    }

    public boolean isCorrectTiles() {
        return this.correctTiles;
    }

    public void setCorrectTiles(boolean correctTiles) {
        this.correctTiles = correctTiles;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    protected abstract String createUrl(ImageBbox var1, Bbox var2, int var3, int var4, int var5);

    protected abstract int getTileDirectionX();

    protected abstract int getTileDirectionY();
}

