/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.imagetool;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import nl.b3p.commons.services.HttpClientConfigured;
import nl.b3p.imagetool.CombineImageUrl;
import nl.b3p.imagetool.ImageManager;
import nl.b3p.imagetool.ImageTool;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageCollector
implements Callable<ImageCollector> {
    private static final Log log = LogFactory.getLog(ImageCollector.class);
    private static int instanceCount = 0;
    private final int instanceNumber = ++instanceCount;
    protected final String preLog;
    public static final int NEW = 0;
    public static final int ACTIVE = 1;
    public static final int COMPLETED = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    private final ImageManager manager;
    private int status = 0;
    private BufferedImage bufferedImage;
    private CombineImageUrl combinedImageUrl = null;
    protected HttpClientConfigured client = null;
    private File tempFile;
    private String mime;
    private boolean imageLoaded = false;

    public ImageCollector(ImageManager manager, CombineImageUrl ciu, HttpClientConfigured client) {
        this.manager = manager;
        this.combinedImageUrl = ciu;
        this.client = client;
        this.preLog = "im #" + manager.getInstanceNumber() + ",ic #" + this.instanceNumber + " " + this.getClass().getName() + ": ";
    }

    @Override
    public ImageCollector call() throws Exception {
        this.status = 1;
        try {
            log.info((Object)(this.preLog + "starting download from URL " + this.combinedImageUrl));
            this.downloadImage(this.combinedImageUrl.getUrl());
            this.status = 2;
        }
        catch (Exception ex) {
            log.error((Object)String.format(this.preLog + "exception downloading image from URL %s: %s: %s", this.combinedImageUrl.toString(), ex.getClass().getName(), ex.getMessage()));
            log.debug((Object)"Full stacktrace for exception downloading image", (Throwable)ex);
            this.status = 4;
        }
        return this;
    }

    protected void downloadImage(String url) throws Exception {
        FileOutputStream out = null;
        HttpResponse response = null;
        try {
            HttpGet request = new HttpGet(url);
            response = this.client.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new Exception("HTTP status code: " + statusCode);
            }
            HttpEntity entity = response.getEntity();
            Header header = entity.getContentType();
            this.mime = null;
            this.mime = header == null || header.getValue().isEmpty() ? "image/png" : header.getValue();
            this.tempFile = File.createTempFile("imagetool-im-" + this.manager.getInstanceNumber() + "-ic-" + this.instanceNumber, null);
            this.tempFile.deleteOnExit();
            out = new FileOutputStream(this.tempFile);
            entity.writeTo((OutputStream)out);
            log.info((Object)String.format(this.preLog + "succesfully downloaded, stored %d bytes in temporary file %s", this.tempFile.length(), this.tempFile.getAbsolutePath()));
        }
        catch (Exception e) {
            try {
                if (this.tempFile != null) {
                    try {
                        log.debug((Object)(this.preLog + "exception writing downloaded image to temp file, deleting " + this.tempFile));
                        this.tempFile.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                this.client.close(response);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        this.client.close(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImage() throws Exception {
        this.imageLoaded = true;
        FileInputStream fis = null;
        try {
            log.info((Object)(this.preLog + "reading image from temporary file " + this.tempFile));
            fis = new FileInputStream(this.tempFile);
            this.bufferedImage = ImageTool.readImage(fis, this.mime);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            if (!this.tempFile.delete()) {
                log.error((Object)(this.preLog + "loadImage(): could not delete temporary file " + this.tempFile.getAbsolutePath()));
            } else {
                log.debug((Object)(this.preLog + "loadImage(): deleted temporary file"));
                this.tempFile = null;
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
        if (!this.tempFile.delete()) {
            log.error((Object)(this.preLog + "loadImage(): could not delete temporary file " + this.tempFile.getAbsolutePath()));
        } else {
            log.debug((Object)(this.preLog + "loadImage(): deleted temporary file"));
            this.tempFile = null;
        }
    }

    public void dispose() {
        this.bufferedImage = null;
        if (this.tempFile != null) {
            if (!this.tempFile.delete()) {
                log.error((Object)(this.preLog + "dispose(): could not delete temporary file " + this.tempFile.getAbsolutePath()));
            } else {
                log.debug((Object)(this.preLog + "dispose(): deleted temporary file"));
            }
        }
    }

    public BufferedImage getBufferedImage() throws Exception {
        if (this.status != 2) {
            return null;
        }
        if (!this.imageLoaded) {
            this.loadImage();
        }
        return this.bufferedImage;
    }

    public int getStatus() {
        return this.status;
    }

    public CombineImageUrl getCombinedImageUrl() {
        return this.combinedImageUrl;
    }

    public ImageManager getManager() {
        return this.manager;
    }
}

