/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.combineimages;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.imagetool.CombineImageSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class CombineImagesServlet
extends HttpServlet {
    private static String WIDTH = "width";
    private static String HEIGHT = "height";
    private static String MIMETYPE = "mimetype";
    private static String BBOX = "bbox";
    private static String htmlTitle = "Plaatje";
    private static String HTMLOUTPUT = "htmloutput";
    private static String htmlOutput = "<html><head><title>[HTMLTITLE]</title></head><body><img src=\"[IMAGESOURCE]\"/></body></html>";
    private static ArrayList extraUrls;
    private static final Log log;
    private static Random rg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            JSONObject jsonSettings = new JSONObject(request.getParameter("params"));
            CombineImageSettings settings = CombineImageSettings.fromJson(jsonSettings);
            String imageId = CombineImagesServlet.uniqueName("");
            request.getSession().setAttribute(imageId, (Object)settings);
            String servletUrl = request.getRequestURL().toString();
            String servletName = this.getServletName().substring(0, this.getServletName().length() - 7);
            servletUrl = servletUrl.substring(0, servletUrl.length() - servletName.length()) + "CreateImage";
            String imageSource = servletUrl + "?imageId=" + imageId;
            String html = htmlOutput;
            if (html.indexOf("[HTMLTITLE]") >= 0) {
                html = html.replaceAll("\\[HTMLTITLE\\]", htmlTitle);
            }
            html = html.indexOf("[IMAGESOURCE]") >= 0 ? html.replaceAll("\\[IMAGESOURCE\\]", imageSource) : html + imageSource;
            out.println(html);
        }
        catch (Exception e) {
            log.error((Object)"Error combining image: ", (Throwable)e);
            out.write(e.getMessage());
        }
        finally {
            out.close();
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (config.getInitParameter("extraUrls") != null && config.getInitParameter("extraUrls").length() > 0) {
            extraUrls = new ArrayList();
            String[] allUrls = config.getInitParameter("extraUrls").split(";");
            for (int i = 0; i < allUrls.length; ++i) {
                extraUrls.add(allUrls[i]);
            }
        }
        if (config.getInitParameter("htmlTitle") != null && config.getInitParameter("htmlTitle").length() > 0) {
            htmlTitle = config.getInitParameter("htmlTitle");
        }
        if (config.getInitParameter("htmlOutput") != null && config.getInitParameter("htmlOutput").length() > 0) {
            htmlOutput = config.getInitParameter("htmlOutput");
        }
        rg = new Random();
    }

    public static String uniqueName(String extension) {
        long now = new Date().getTime();
        String val1 = Long.toString(now, 36).toUpperCase();
        if (rg == null) {
            rg = new Random();
        }
        long rnum = rg.nextInt(1000);
        String val2 = Long.toString(rnum, 36).toUpperCase();
        String thePath = "";
        return val1 + val2 + extension;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    static {
        log = LogFactory.getLog(CombineImagesServlet.class);
        rg = null;
    }
}

