/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.combineimages;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.imagetool.CombineImageSettings;
import nl.b3p.imagetool.CombineImagesHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateImageServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(CreateImageServlet.class);
    private int maxResponseTime = -1;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream os = response.getOutputStream();
        try {
            String imageId = request.getParameter("imageId");
            if (imageId != null && request.getSession().getAttribute(imageId) != null) {
                CombineImageSettings settings = (CombineImageSettings)request.getSession().getAttribute(imageId);
                response.setContentType(settings.getMimeType());
                response.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
                String keepAlive = request.getParameter("keepAlive");
                if (keepAlive == null || keepAlive.length() == 0) {
                    request.getSession().removeAttribute(imageId);
                }
                CombineImagesHandler.combineImage((OutputStream)response.getOutputStream(), settings, settings.getMimeType(), this.maxResponseTime);
            }
        }
        catch (Exception e) {
            log.error((Object)"Fout opgetreden: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            os.close();
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (config.getInitParameter("maxResponseTime") != null) {
            try {
                int mrt;
                this.maxResponseTime = mrt = Integer.parseInt(config.getInitParameter("maxResponseTime"));
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"Fout bij laden init parameter maxResponseTime: Geen nummer", (Throwable)nfe);
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

