/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.clieop3.record;

import java.text.SimpleDateFormat;
import java.util.Date;
import nl.b3p.commons.clieop3.ClieOp3OutputStream;
import nl.b3p.commons.clieop3.PadUtils;
import nl.b3p.commons.clieop3.record.Record;

public class Opdrachtgever
extends Record {
    private static final String RECORDCODE = "0030";
    private static final char VARIANTCODE = 'B';
    public static final char NAW_GEWENST = '2';
    public static final char NAW_NIETGEWENST = '1';
    public static final char NAW_NVT = '1';
    public static final char TESTCODE_PRODUCTIE = 'P';
    public static final char TESTCODE_TEST = 'T';
    private char nawCode;
    private Date verwerkingsDatum;
    private String naam;
    private char testCode;

    public Opdrachtgever(char nawCode, Date verwerkingsDatum, String naam, char testCode) {
        super(RECORDCODE, 'B');
        this.nawCode = nawCode;
        this.verwerkingsDatum = verwerkingsDatum;
        this.naam = ClieOp3OutputStream.cleanClieOp3String(naam);
        this.testCode = testCode;
    }

    public char getNawCode() {
        return this.nawCode;
    }

    public Date getVerwerkingsDatum() {
        return this.verwerkingsDatum;
    }

    public String getNaam() {
        return this.naam;
    }

    public char getTestCode() {
        return this.testCode;
    }

    protected void appendRecordContents(StringBuffer buf) {
        buf.append(this.nawCode);
        if (this.verwerkingsDatum == null) {
            buf.append("000000");
        } else {
            SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
            String date = df.format(this.verwerkingsDatum);
            buf.append(date);
        }
        PadUtils.padText(this.naam, 35, buf);
        buf.append(this.testCode);
    }
}

