/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.jpa;

import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.commons.jpa.TransactionalAjax;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.AjaxFilterChain;
import org.directwebremoting.annotations.GlobalFilter;

@GlobalFilter
public class DwrJpaTransactionFilter
implements AjaxFilter {
    private static final Log log = LogFactory.getLog(DwrJpaTransactionFilter.class);

    public Object doFilter(Object obj, Method method, Object[] params, AjaxFilterChain chain) throws Exception {
        TransactionalAjax annotation = method.getAnnotation(TransactionalAjax.class);
        if (annotation == null) {
            annotation = method.getDeclaringClass().getAnnotation(TransactionalAjax.class);
        }
        String persistenceUnit = null;
        EntityManager em = null;
        EntityTransaction tx = null;
        if (annotation != null) {
            persistenceUnit = annotation.persistenceUnit();
            em = persistenceUnit.equals("[default]") ? JpaUtilServlet.getThreadEntityManager() : JpaUtilServlet.getThreadEntityManager(persistenceUnit);
            log.debug((Object)("Starting transaction for persistence unit " + persistenceUnit));
            tx = em.getTransaction();
            tx.begin();
        }
        try {
            Object ret = chain.doFilter(obj, method, params);
            if (tx != null && tx.isActive()) {
                log.debug((Object)"Committing active transaction");
                tx.commit();
            }
            Object object = ret;
            return object;
        }
        catch (Exception e) {
            log.error((Object)("Exception occured during DWR call" + (tx.isActive() ? ", rolling back transaction" : " - no transaction active")), (Throwable)e);
            if (tx.isActive()) {
                try {
                    tx.rollback();
                }
                catch (Exception e2) {
                    log.error((Object)"Exception rolling back transaction", (Throwable)e2);
                }
            }
            throw e;
        }
        finally {
            if (persistenceUnit != null) {
                log.debug((Object)("Closing EntityManager for persistence unit " + persistenceUnit));
                if (persistenceUnit.equals("[default]")) {
                    JpaUtilServlet.closeThreadEntityManager();
                } else {
                    JpaUtilServlet.closeThreadEntityManager(persistenceUnit);
                }
            }
        }
    }
}

