/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.oai;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.oai.dataprovider20.DataProvider;
import nl.b3p.commons.oai.dataprovider20.Identity;
import nl.b3p.commons.oai.dataprovider20.RecordFactory;
import nl.b3p.commons.oai.dataprovider20.error.BadArgument;
import nl.b3p.commons.oai.dataprovider20.error.BadVerb;
import nl.b3p.commons.oai.dataprovider20.error.OAIError;
import nl.b3p.commons.oai.util.xml.XMLTool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OAI
extends HttpServlet {
    private static final long serialVersionUID = -6065554885961025291L;
    protected static Identity config = null;
    protected static RecordFactory rf = null;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.work(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.work(request, response);
    }

    public void work(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        OAIError oaierror;
        Document doc;
        Element elem;
        PrintWriter out;
        block18: {
            response.setContentType("text/xml;charset=UTF-8");
            out = response.getWriter();
            String formname = request.getParameter("verb");
            String token = request.getParameter("resumptionToken");
            elem = null;
            doc = XMLTool.createDocumentRoot();
            DataProvider dp = new DataProvider(OAI.getConfig(), OAI.getRf(), doc);
            oaierror = null;
            if (token == null || token.trim().equals("")) {
                token = null;
            }
            try {
                if (formname == null || formname.trim().equals("")) {
                    throw new BadVerb("no verb specified!");
                }
                int numofparameters = 0;
                Hashtable<String, String> params = new Hashtable<String, String>();
                String queryString = request.getQueryString();
                if (queryString != null) {
                    StringTokenizer st = new StringTokenizer(queryString, "&");
                    while (st.hasMoreTokens()) {
                        String o = params.put(st.nextToken(), "anything");
                        if (o != null) {
                            throw new BadArgument("Duplicate Argument");
                        }
                        ++numofparameters;
                    }
                }
                if (token != null && numofparameters > 2) {
                    throw new BadArgument("The wrong argument with resumptionToken");
                }
                if (formname.equals("Identify")) {
                    if (numofparameters != 1) {
                        throw new BadArgument("bad argument for Identify");
                    }
                    elem = dp.identify();
                    break block18;
                }
                if (formname.equals("ListIdentifiers")) {
                    elem = token == null ? dp.listIdentifiers(this.clear(request.getParameter("from")), this.clear(request.getParameter("until")), this.clear(request.getParameter("set")), this.clear(request.getParameter("metadataPrefix"))) : dp.listIdentifiers(token);
                    break block18;
                }
                if (formname.equals("GetRecord")) {
                    elem = dp.getRecord(this.clear(request.getParameter("identifier")), this.clear(request.getParameter("metadataPrefix")));
                    break block18;
                }
                if (formname.equals("ListRecords")) {
                    elem = token == null ? dp.listRecords(this.clear(request.getParameter("from")), this.clear(request.getParameter("until")), this.clear(request.getParameter("set")), this.clear(request.getParameter("metadataPrefix"))) : dp.listRecords(token);
                    break block18;
                }
                if (formname.equals("ListSets")) {
                    elem = token == null ? dp.listSets() : dp.listSets(token);
                    break block18;
                }
                if (formname.equals("ListMetadataFormats")) {
                    elem = dp.listMetadataFormats(this.clear(request.getParameter("identifier")));
                    break block18;
                }
                throw new BadVerb("badVerb");
            }
            catch (OAIError err) {
                oaierror = err;
                elem = doc.createElement("error");
                elem.setAttribute("code", err.getCode());
                elem.appendChild(doc.createTextNode(err.toString()));
            }
        }
        Element root = doc.createElement("OAI-PMH");
        root.setAttribute("xmlns", "http://www.openarchives.org/OAI/2.0/");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:schemaLocation", "http://www.openarchives.org/OAI/2.0/     http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd");
        Element date = doc.createElement("responseDate");
        SimpleDateFormat simple = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
        simple.setTimeZone(TimeZone.getTimeZone("GMT"));
        String datestring = simple.format(new Date()) + "Z";
        date.appendChild(doc.createTextNode(datestring));
        root.appendChild(date);
        Element url = doc.createElement("request");
        if (oaierror != null && (oaierror.getCode().equals("badVerb") || oaierror.getCode().equals("badArgument"))) {
            url.appendChild(doc.createTextNode(request.getRequestURL().toString()));
        } else {
            Enumeration enume = request.getParameterNames();
            while (enume.hasMoreElements()) {
                String key = (String)enume.nextElement();
                String value = request.getParameter(key);
                url.setAttribute(key, value);
            }
            url.appendChild(doc.createTextNode(request.getRequestURL().toString()));
        }
        root.appendChild(url);
        root.appendChild(elem);
        doc.appendChild(root);
        XMLTool.Dom2Stream(doc, out);
        out.close();
    }

    private String clear(String in) {
        if (in == null) {
            return null;
        }
        if (in.trim().equals("")) {
            return null;
        }
        return in;
    }

    public static String encodeAMP(String input) {
        String result = new String();
        StringTokenizer st = new StringTokenizer(input, "&");
        while (st.hasMoreTokens()) {
            result = result + st.nextToken() + "&amp;";
        }
        result = result.substring(0, result.length() - 5);
        return result;
    }

    public static Identity getConfig() {
        return config;
    }

    public static void setConfig(Identity aConfig) {
        config = aConfig;
    }

    public static RecordFactory getRf() {
        return rf;
    }

    public static void setRf(RecordFactory aRf) {
        rf = aRf;
    }
}

