/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.security.aselect;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import nl.b3p.commons.security.aselect.ASelectClient;
import nl.b3p.commons.security.aselect.ASelectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ASelectAgentClient
implements ASelectClient {
    private static Log log = LogFactory.getLog(ASelectAgentClient.class);
    private static final String ASELECT_AGENT_EOL = "\r\n";
    private static final int ASELECT_AGENT_DEFAULTPORT = 1495;
    private String host;
    private int port;
    private boolean agentDecodeBug = false;
    private String charset = "UTF-8";

    public ASelectAgentClient(Properties config) {
        this.host = config.getProperty("agent_host", "localhost");
        this.port = 1495;
        try {
            String agentPortString = config.getProperty("agent_port");
            if (agentPortString != null) {
                this.port = Integer.parseInt(agentPortString);
                if (this.port < 0 || this.port > 65535) {
                    throw new IllegalArgumentException("invalid port number");
                }
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("agent_port must be number");
        }
        String agentDecodeBugString = config.getProperty("agent_has_decode_bug");
        if (agentDecodeBugString != null) {
            this.agentDecodeBug = agentDecodeBugString.toLowerCase().equals("true");
        }
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map performRequest(Map params) throws IOException {
        Map result;
        StringBuffer request = new StringBuffer("");
        Iterator i = params.entrySet().iterator();
        boolean first = true;
        while (i.hasNext()) {
            if (!first) {
                request.append("&");
            } else {
                first = false;
            }
            Map.Entry entry = i.next();
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (!this.agentDecodeBug) {
                key = URLEncoder.encode(key, this.charset);
                value = URLEncoder.encode(key, this.charset);
            }
            request.append(key).append("=").append(value);
        }
        request.append(ASELECT_AGENT_EOL);
        String requestString = request.toString();
        log.debug((Object)"connecting to agent");
        Socket socket = new Socket(this.host, this.port);
        try {
            log.debug((Object)("request: " + requestString));
            socket.getOutputStream().write(requestString.getBytes());
            String response = new BufferedReader(new InputStreamReader(socket.getInputStream(), this.charset)).readLine();
            log.debug((Object)("response: " + response));
            result = ASelectUtils.parseQueryString(response, this.charset);
            result.put("complete_response", response);
        }
        finally {
            socket.close();
        }
        return result;
    }
}

