/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.security.aselect;

import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import nl.b3p.commons.security.aselect.ASelectAgentClient;
import nl.b3p.commons.security.aselect.ASelectAuthorizationException;
import nl.b3p.commons.security.aselect.ASelectConstants;
import nl.b3p.commons.security.aselect.ASelectTicket;

public class ASelectAgentTicket
extends ASelectTicket
implements ASelectConstants {
    private ASelectAgentClient client;

    ASelectAgentTicket(String ticket, String appId, Date startTime, Date expTime, String uid, String organization, String authSPLevel, String authSP, String attributes, ASelectAgentClient client) {
        super(ticket, appId, startTime, expTime, uid, organization, authSPLevel, authSP, attributes);
        this.client = client;
    }

    protected void doVerify() throws IOException, ASelectAuthorizationException {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("request", "verify_ticket");
        params.put("ticket", this.getTicketId());
        params.put("uid", this.getUid());
        params.put("organization", this.getOrganization());
        params.put("app_id", this.getAppId());
        Map asResponse = null;
        asResponse = this.client.performRequest(params);
        String asResult = (String)asResponse.get("result_code");
        if (!"0000".equals(asResult)) {
            if ("010b".equals(asResult) || "010a".equals(asResult)) {
                throw new ASelectAuthorizationException("Ticket expired or unknown");
            }
            if ("0109".equals(asResult)) {
                throw new ASelectAuthorizationException("Invalid ticket");
            }
            throw new ASelectAuthorizationException("A-Select Agent error code verifying ticket: " + asResult);
        }
    }

    protected void doKill() throws IOException {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("request", "kill_ticket");
        params.put("ticket", this.getTicketId());
        Map asResponse = null;
        asResponse = this.client.performRequest(params);
        String asResult = (String)asResponse.get("result_code");
        if (!"0000".equals(asResult)) {
            // empty if block
        }
    }
}

