/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProxySelector;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.StreamCopy;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;

public class FileManagerServlet
extends HttpServlet {
    private static final String host = null;
    private static final int port = -1;
    private static final int RTIMEOUT = 20000;
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static final String PARENT_PATH = "..";
    private static Log log = LogFactory.getLog(FileManagerServlet.class);
    protected String locationPrefix;
    protected String fileParam;
    protected int directoryKeepDepth;
    protected FetchMethod fetchMethod;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String dd = FileManagerServlet.getConfigValue(config, "directoryKeepDepth", "1");
        try {
            this.directoryKeepDepth = Integer.parseInt(dd);
        }
        catch (NumberFormatException nfe) {
            throw new ServletException("Ongeldige directoryKeepDepth init-param");
        }
        this.locationPrefix = FileManagerServlet.getConfigValue(config, "locationPrefix", "");
        String fm = FileManagerServlet.getConfigValue(config, "fetchMethod", "HTTP");
        this.fetchMethod = fm.equalsIgnoreCase("HTTP") ? FetchMethod.HTTP : FetchMethod.FILE;
        this.fileParam = FileManagerServlet.getConfigValue(config, "fileParam", "filename");
    }

    private static String getConfigValue(ServletConfig config, String parameter, String defaultValue) {
        String tmpval = config.getInitParameter(parameter);
        if (tmpval == null || tmpval.trim().length() == 0) {
            tmpval = defaultValue;
        }
        log.debug((Object)("ConfigValue(" + parameter + ", " + tmpval + ")"));
        return tmpval.trim();
    }

    private static String extractFileName(String fileName) {
        int dirSepPos = Math.max(fileName.lastIndexOf(92), fileName.lastIndexOf(47));
        if (dirSepPos != -1) {
            return fileName.substring(dirSepPos + 1);
        }
        return fileName;
    }

    private static String extractFullPath(String fileName) {
        int dirSepPos = Math.max(fileName.lastIndexOf(92), fileName.lastIndexOf(47));
        if (dirSepPos != -1) {
            return fileName.substring(0, dirSepPos);
        }
        return "";
    }

    private String reformatServletPath(String path) {
        int dirSepPos = Math.max(path.lastIndexOf(92), path.lastIndexOf(47));
        if (dirSepPos == path.length() && dirSepPos > 1) {
            return path.substring(0, dirSepPos - 1);
        }
        return path;
    }

    private String reformatFilename(String filename) {
        String[] paths;
        String reformatedFilename = filename;
        if (this.directoryKeepDepth != -1 && (paths = filename.split("(/|\\\\)")).length > 0) {
            int start;
            reformatedFilename = "";
            for (int i = start = Math.max(0, paths.length - 1 - this.directoryKeepDepth); i < paths.length; ++i) {
                reformatedFilename = reformatedFilename + "/" + paths[i];
            }
        }
        return reformatedFilename;
    }

    private String transformFilename(String filename) {
        String debugStr = "transformFilename(): origineel=\"" + filename + "\"; getransformeerd=\"";
        String transformedFilename = this.locationPrefix + this.reformatFilename(filename);
        debugStr = debugStr + transformedFilename + "\"";
        log.debug((Object)debugStr);
        return transformedFilename;
    }

    protected void checkPostLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        throw new Exception("Post not allowed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block8: {
            String fileName = null;
            try {
                if (this.fetchMethod.equals((Object)FetchMethod.HTTP)) {
                    throw new Exception("POST niet toegestaan bij instelling: '" + (Object)((Object)FetchMethod.HTTP) + "'.");
                }
                this.checkPostLogin(request, response);
                List items = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()).parseRequest(request);
                InputStream in = null;
                String workspace = null;
                for (FileItem item : items) {
                    if (item.isFormField()) {
                        if (!this.fileParam.equals(item.getFieldName())) continue;
                        workspace = item.getString();
                        continue;
                    }
                    in = item.getInputStream();
                }
                if (workspace == null || in == null) break block8;
                fileName = this.reformatFilename(workspace);
                File dir = new File(FileManagerServlet.extractFullPath(this.locationPrefix + fileName));
                FileUtils.forceMkdir((File)dir);
                FileOutputStream out = new FileOutputStream(this.locationPrefix + fileName, false);
                try {
                    StreamCopy.copy(in, out);
                }
                finally {
                    in.close();
                    out.close();
                }
                String base = FileManagerServlet.createBaseUrl(request);
                String url = base + this.reformatServletPath(request.getServletPath()) + fileName;
                response.getWriter().write(url);
            }
            catch (Exception e) {
                log.error((Object)("Exception bij opslaan document voor " + fileName), (Throwable)e);
                response.sendError(500, "Fout tijdens opslaan document: " + e.getClass() + ": " + e.getMessage());
            }
        }
    }

    protected void checkGetLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileName = null;
        try {
            String uri = request.getPathInfo();
            if (uri.contains(PARENT_PATH)) {
                throw new Exception(".. niet toegestaan in url.");
            }
            fileName = this.transformFilename(uri);
            log.debug((Object)("Uri: " + uri));
            log.debug((Object)("Filename: " + fileName));
            this.checkGetLogin(request, response);
            switch (this.fetchMethod) {
                case FILE: {
                    this.getDocByFS(fileName, response);
                    break;
                }
                default: {
                    this.getDocByHttp(fileName, response);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception bij ophalen document voor " + fileName), (Throwable)e);
            response.sendError(500, "Fout tijdens ophalen document: " + e.getClass() + ": " + e.getMessage());
        }
    }

    protected static String createBaseUrl(HttpServletRequest request) {
        String scheme = request.getScheme();
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        String contextPath = request.getContextPath();
        StringBuffer theUrl = new StringBuffer();
        theUrl.append(scheme);
        theUrl.append("://");
        theUrl.append(serverName);
        if (scheme.equals("http") && serverPort != 80 || scheme.equals("https") && serverPort != 443) {
            theUrl.append(":");
            theUrl.append(serverPort);
        }
        theUrl.append(contextPath);
        return theUrl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDocByFS(String fileName, HttpServletResponse response) throws IOException {
        String headerFileName = FileManagerServlet.extractFileName(fileName);
        String contentType = null;
        FileInputStream input = null;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                log.error((Object)("Bestand bestaat niet voor " + fileName));
                response.sendError(404, "Document " + headerFileName + " (bestand bestaat niet)");
                return;
            }
            contentType = this.getServletContext().getMimeType(fileName);
            if (contentType == null) {
                contentType = DEFAULT_MIME_TYPE;
            }
            input = new FileInputStream(file);
            response.setContentType(contentType);
            response.addHeader("Content-Disposition", "attachment; filename=" + headerFileName);
            try {
                ServletOutputStream output = response.getOutputStream();
                StreamCopy.copy(input, (OutputStream)output);
            }
            finally {
                if (input != null) {
                    ((InputStream)input).close();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception bij sturen document voor " + fileName), (Throwable)e);
            response.sendError(500, "Fout tijdens sturen document: " + e.getClass() + ": " + e.getMessage());
        }
    }

    private void getDocByHttp(String location, HttpServletResponse response) throws IOException {
        this.getDocByHttp(location, null, null, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDocByHttp(String location, String username, String password, HttpServletResponse response) throws IOException {
        String headerFileName = FileManagerServlet.extractFileName(location);
        String contentType = null;
        InputStream input = null;
        RequestConfig defaultRequestConfig = RequestConfig.custom().setStaleConnectionCheckEnabled(false).setTargetPreferredAuthSchemes(Arrays.asList("Basic")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).setConnectionRequestTimeout(20000).build();
        HttpClientBuilder hcb = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig);
        HttpClientContext context = HttpClientContext.create();
        if (username != null && password != null) {
            HttpHost targetHost = new HttpHost(host, -1);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(username, password);
            AuthScope authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort());
            credentialsProvider.setCredentials(authScope, (Credentials)defaultcreds);
            hcb = hcb.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        hcb.setRoutePlanner((HttpRoutePlanner)routePlanner);
        CloseableHttpClient client = hcb.build();
        HttpPost post = new HttpPost(location);
        CloseableHttpResponse iresponse = client.execute((HttpUriRequest)post, (HttpContext)context);
        try {
            int statusCode = iresponse.getStatusLine().getStatusCode();
            HttpEntity entity = iresponse.getEntity();
            input = entity.getContent();
            if (statusCode != 200) {
                log.error((Object)("Host: " + location + " error: " + iresponse.getStatusLine().getReasonPhrase()));
                response.sendError(404, "Document " + headerFileName + " (" + iresponse.getStatusLine().getReasonPhrase() + ")");
                return;
            }
            Header header = entity.getContentType();
            contentType = header == null || header.getValue().isEmpty() ? "image/png" : header.getValue();
            response.setContentType(contentType);
            response.addHeader("Content-Disposition", "attachment; filename=" + headerFileName);
            try {
                ServletOutputStream output = response.getOutputStream();
                StreamCopy.copy(input, (OutputStream)output);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception bij sturen document voor " + location), (Throwable)e);
            response.sendError(500, "Fout tijdens sturen document: " + e.getClass() + ": " + e.getMessage());
        }
        finally {
            iresponse.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FetchMethod {
        HTTP,
        FILE;

    }
}

