/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.clieop3.record;

import java.math.BigInteger;
import nl.b3p.commons.clieop3.PadUtils;
import nl.b3p.commons.clieop3.record.Record;

public class BatchStart
extends Record {
    private static final String RECORDCODE = "0010";
    private static final char VARIANTCODE = 'B';
    public static final String TRANSACTIEGROEP_BETALINGEN = "00";
    public static final String TRANSACTIEGROEP_INCASSOS = "10";
    private String transactieGroep;
    private BigInteger rekeningOpdrachtgever;
    private String valuta;
    private int volgnummer = 1;

    public BatchStart(String transactieGroep, BigInteger rekeningOpdrachtgever, String valuta) {
        super(RECORDCODE, 'B');
        this.transactieGroep = transactieGroep;
        this.rekeningOpdrachtgever = rekeningOpdrachtgever;
        this.valuta = valuta;
    }

    public String getTransactieGroep() {
        return this.transactieGroep;
    }

    public BigInteger getRekeningOpdrachtgever() {
        return this.rekeningOpdrachtgever;
    }

    public String getValuta() {
        return this.valuta;
    }

    public void setVolgnummer(int volgnummer) {
        this.volgnummer = volgnummer;
    }

    protected void appendRecordContents(StringBuffer buf) {
        PadUtils.padText(this.transactieGroep, 2, buf);
        PadUtils.padNumber(this.rekeningOpdrachtgever.toString(), 10, buf);
        PadUtils.padNumber(this.volgnummer + "", 4, buf);
        PadUtils.padText(this.valuta, 3, buf);
    }

    public static void main(String[] args) {
        BatchStart entry = new BatchStart(TRANSACTIEGROEP_BETALINGEN, new BigInteger("0679411372"), "EUR");
        entry.setVolgnummer(1);
        System.out.println(entry.getRecordData());
    }
}

