/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.services;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.b3p.commons.services.B3pCommonsException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.DynaValidatorForm;

public abstract class FormBaseBean {
    protected Log log = LogFactory.getLog(this.getClass());
    protected String action = null;
    protected ActionMessages errors = null;
    protected HttpSession session = null;
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected Locale locale = null;
    protected MessageResources messages = null;
    protected DynaValidatorForm form = null;
    protected Map requestParams = null;
    protected ActionMapping mapping = null;
    protected boolean isInit = false;
    public static final String UNKNOWN_ACTION = "Unknown";

    public FormBaseBean(HttpServletRequest req, DynaValidatorForm dform, ActionMapping mapp) {
        this(req, null, null, null, dform, mapp);
    }

    public FormBaseBean(HttpServletRequest req, Locale loc, MessageResources mess, ActionMessages err, DynaValidatorForm dform, ActionMapping mapp) {
        this.request = req;
        this.session = req.getSession();
        if (req instanceof MultipartRequestWrapper) {
            MultipartRequestWrapper mpr = (MultipartRequestWrapper)req;
            Enumeration mprenum = mpr.getParameterNames();
            HashMap<String, String> tempMap = new HashMap<String, String>();
            while (mprenum.hasMoreElements()) {
                String param = (String)mprenum.nextElement();
                tempMap.put(param, mpr.getParameter(param));
            }
            this.requestParams = tempMap;
        } else {
            this.requestParams = new HashMap(req.getParameterMap());
        }
        this.locale = loc;
        this.messages = mess;
        this.errors = err;
        this.form = dform;
        this.mapping = mapp;
        if (this.errors == null) {
            this.errors = new ActionErrors();
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (this.messages == null) {
            this.messages = MessageResources.getMessageResources((String)"nl.b3p.commons.services.FormBaseStrings");
        }
        this.setAction(UNKNOWN_ACTION);
        this.isInit = true;
    }

    public String getAction() {
        return this.action;
    }

    protected void setAction(String action) {
        this.action = action;
    }

    protected boolean isAction(String lact) {
        if (lact == null) {
            return false;
        }
        return lact.equals(this.getAction());
    }

    protected boolean buttonPressed(String butt) {
        if (butt == null) {
            return false;
        }
        String butval = null;
        try {
            butval = this.getParamAsString(butt);
        }
        catch (B3pCommonsException b3pCommonsException) {
            // empty catch block
        }
        return !FormBaseBean.nullOrEmpty(butval);
    }

    protected static boolean nullOrEmpty(String astr) {
        return astr == null || astr.length() == 0;
    }

    protected String getParamAsString(String param) throws B3pCommonsException {
        Object value = this.getParamAsObject(param);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof String[]) {
            String[] sa = (String[])value;
            if (sa.length > 0) {
                return sa[0];
            }
            return null;
        }
        throw new B3pCommonsException("Verkeerde functie aanroep: getParamAsString bij param: " + (param == null ? "?" : param));
    }

    protected String[] getParamAsStringArray(String param) throws B3pCommonsException {
        Object value = this.getParamAsObject(param);
        if (!(value instanceof String[]) && value != null) {
            throw new B3pCommonsException("Verkeerde functie aanroep: getParamAsStringArray bij param: " + (param == null ? "?" : param));
        }
        return (String[])value;
    }

    protected Object getParamAsObject(String param) {
        return this.requestParams.get(param);
    }

    protected String getForm(String param) throws B3pCommonsException {
        Object obj = this.getFormAsObject(param);
        if (!(obj instanceof String) && obj != null) {
            throw new B3pCommonsException("Verkeerde functie aanroep: getForm bij param: " + (param == null ? "?" : param));
        }
        return (String)obj;
    }

    protected String[] getFormAsStringArray(String param) throws B3pCommonsException {
        Object obj = this.getFormAsObject(param);
        if (!(obj instanceof String[]) && obj != null) {
            throw new B3pCommonsException("Verkeerde functie aanroep: getFormAsStringArray bij param: " + (param == null ? "?" : param));
        }
        return (String[])obj;
    }

    protected Integer getFormAsInteger(String param) throws B3pCommonsException {
        Object obj = this.getFormAsObject(param);
        if (!(obj instanceof Integer) && obj != null) {
            throw new B3pCommonsException("Verkeerde functie aanroep: getFormAsInteger bij param: " + (param == null ? "?" : param));
        }
        return (Integer)obj;
    }

    protected FormFile getFormAsFormFile(String param) throws B3pCommonsException {
        Object obj = this.getFormAsObject(param);
        if (!(obj instanceof FormFile) && obj != null) {
            throw new B3pCommonsException("Verkeerde functie aanroep: getFormAsFormFile bij param: " + (param == null ? "?" : param));
        }
        return (FormFile)obj;
    }

    protected boolean getFormAsBoolean(String param) throws B3pCommonsException {
        Object obj = this.getFormAsObject(param);
        if (!(obj instanceof Boolean) && obj != null) {
            throw new B3pCommonsException("Verkeerde functie aanroep: getFormAsBoolean bij param: " + (param == null ? "?" : param));
        }
        Boolean bo = (Boolean)obj;
        return bo != null && bo != false;
    }

    protected Object getFormAsObject(String param) throws B3pCommonsException {
        if (this.form == null) {
            throw new B3pCommonsException("Form null error.");
        }
        try {
            return this.form.get(param);
        }
        catch (IllegalArgumentException iae) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Dynaform get IllegalArgumentException ", (Throwable)iae);
            }
            throw new B3pCommonsException("getForm Error: ", iae);
        }
        catch (NullPointerException npe) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Dynaform get NullPointerException ", (Throwable)npe);
            }
            throw new B3pCommonsException("getForm Error: ", npe);
        }
        catch (ClassCastException cce) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Dynaform get ClassCastException ", (Throwable)cce);
            }
            throw new B3pCommonsException("getForm Error: ", cce);
        }
    }

    protected void setForm(String param, Object value) throws B3pCommonsException {
        try {
            this.form.set(param, value);
        }
        catch (IllegalArgumentException iae) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Dynaform get IllegalArgumentException ", (Throwable)iae);
            }
            throw new B3pCommonsException("setForm Error: ", iae);
        }
        catch (NullPointerException npe) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Dynaform get NullPointerException ", (Throwable)npe);
            }
            throw new B3pCommonsException("setForm Error: ", npe);
        }
        catch (ClassCastException cce) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Dynaform get ClassCastException ", (Throwable)cce);
            }
            throw new B3pCommonsException("setForm Error: ", cce);
        }
    }

    public ActionMessages getErrors() {
        return this.errors;
    }

    public void setErrors(ActionMessages errors) {
        this.errors = errors;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public MessageResources getMessages() {
        return this.messages;
    }

    public void setMessages(MessageResources messages) {
        this.messages = messages;
    }

    public DynaValidatorForm getForm() {
        return this.form;
    }

    public void setForm(DynaValidatorForm form) {
        this.form = form;
    }

    public Map getRequestParams() {
        return this.requestParams;
    }

    public void setRequestParams(Map requestParams) {
        this.requestParams = requestParams;
    }

    public ActionMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(ActionMapping mapping) {
        this.mapping = mapping;
    }
}

