/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.GetServiceFileSecureServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetServiceFileServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog(GetServiceFileServlet.class);
    public static final String FILE = "file";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (log.isInfoEnabled()) {
            log.info((Object)"Initializing GetServiceFileServlet servlet");
        }
        if (!(this instanceof GetServiceFileSecureServlet)) {
            log.warn((Object)"Insecure file getter. Recommending the use of GetServiceFileSecureServlet");
        }
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String fileString = request.getParameter(FILE);
        if (fileString == null || fileString.length() == 0) {
            this.writeErrorMessage(response, "No 'file' parameter given.");
            return;
        }
        File file = this.getCorrectedFile(fileString);
        if (file != null) {
            if (file.isDirectory()) {
                this.writeDirToHtml(request, response, file);
            } else {
                this.writeFile(response, file);
            }
        } else {
            this.writeFileNotFoundMessage(response, fileString);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    protected void writeFile(HttpServletResponse response, File file) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        ServletOutputStream out = response.getOutputStream();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + "\";");
        response.setContentLength((int)file.length());
        FileInputStream inputStream = new FileInputStream(file);
        while ((len = inputStream.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        inputStream.close();
        out.close();
    }

    protected void writeErrorMessage(HttpServletResponse response, String message) throws IOException {
        response.setContentType("text/html");
        ServletOutputStream out = response.getOutputStream();
        out.println("<html><head><title>Error</title></head><body>");
        out.println("<h1>Error getting file</h1>");
        out.println("Cause: <br>");
        out.println("<b>" + message + "</b>");
        out.println("</body></html>");
        out.close();
    }

    private void writeDirToHtml(HttpServletRequest request, HttpServletResponse response, File dir) throws IOException {
        File[] files;
        response.setContentType("text/html");
        ServletOutputStream out = response.getOutputStream();
        out.println("<html><head><title>Directory List</title></head><body>");
        for (File f : files = dir.listFiles()) {
            out.println("<a href=\"" + this.createFileUrl(request, f) + "\">" + f.getName() + "</a><br/>");
        }
        out.println("</body></html>");
        out.close();
    }

    protected String createFileUrl(HttpServletRequest request, File f) {
        String fileUrl = request.getRequestURI().toString();
        fileUrl = fileUrl + (fileUrl.contains("?") ? "&" : "?");
        fileUrl = fileUrl + "file=" + f.getAbsolutePath();
        return fileUrl;
    }

    protected void writeFileToHtml(HttpServletRequest request, HttpServletResponse response, File file) throws IOException {
        response.setContentType("text/html");
        ServletOutputStream out = response.getOutputStream();
        out.println("<html><head><title>Code generated</title></head><body>");
        out.println("<a href=\"" + this.createFileUrl(request, file) + "\">" + file.getName() + "</a>");
        out.println("</body></html>");
        out.close();
    }

    protected File getCorrectedFile(String fileString) {
        File file = new File(fileString);
        File relativeFile = null;
        if (!file.exists() && (relativeFile = new File(this.getServletContext().getRealPath(fileString))).exists()) {
            file = relativeFile;
        }
        if (file.exists()) {
            return file;
        }
        return null;
    }

    protected void writeFileNotFoundMessage(HttpServletResponse response, String fileString) throws IOException {
        File file = new File(fileString);
        File relativeFile = new File(this.getServletContext().getRealPath(fileString));
        this.writeErrorMessage(response, "File: '" + file.getAbsolutePath() + "' not found" + " and <br>" + "File: '" + relativeFile.getAbsolutePath() + "' not found");
    }
}

