/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.taglib;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import nl.b3p.commons.services.FormUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.taglib.TagUtils;

public class WriteDateTag
extends TagSupport {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected String name = null;
    protected String property = null;
    protected String scope = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public int doStartTag() throws JspException {
        String output;
        block15: {
            Object value = null;
            if (this.name != null) {
                if (TagUtils.getInstance().lookup(this.pageContext, this.name, this.scope) == null) {
                    return 0;
                }
                value = TagUtils.getInstance().lookup(this.pageContext, this.name, this.property, this.scope);
            }
            if (value == null) {
                Date exValue = new Date();
                value = exValue;
            }
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            Locale locale = request.getLocale();
            output = null;
            if (value != null) {
                if (value instanceof Date) {
                    output = FormUtils.DateToString((Date)value, locale);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Date: " + output));
                    }
                } else if (value instanceof Timestamp) {
                    Timestamp temptime = (Timestamp)value;
                    Date tempdate = new Date();
                    tempdate.setTime(temptime.getTime());
                    output = FormUtils.DateToString(tempdate, locale);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Timestamp: " + output));
                    }
                } else if (value instanceof String) {
                    SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
                    sdf.applyPattern("yyyy-MM-dd HH:mm");
                    Date tempdate = null;
                    try {
                        tempdate = sdf.parse((String)value);
                        output = FormUtils.DateToString(tempdate, locale);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("String (yyyy-MM-dd HH:mm): " + output));
                        }
                    }
                    catch (ParseException pe) {
                        output = ((String)value).trim();
                        int spacedex = output.indexOf(32);
                        if (spacedex > 1) {
                            output = output.substring(0, spacedex);
                        }
                        if (!this.log.isDebugEnabled()) break block15;
                        this.log.debug((Object)("No conversion: " + output));
                    }
                }
            }
        }
        TagUtils.getInstance().write(this.pageContext, output);
        return 0;
    }

    public void release() {
        super.release();
        this.name = null;
        this.property = null;
        this.scope = null;
    }
}

