/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.gui;

import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.FormView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HTMLPane
extends JEditorPane {
    private ActionListener actionListeners = null;

    public HTMLPane() {
        HTMLPane.registerEditorKitForContentType("text/html", "nl.b3p.commons.gui.HTMLPane$HTMLPaneEditorKit");
        this.setEditorKit(new HTMLPaneEditorKit());
        this.setContentType("text/html");
        this.addHyperlinkListener(new HyperlinkHandler());
        this.setEditable(false);
    }

    public final void addActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.add(this.actionListeners, listener);
    }

    public final void removeActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.remove(this.actionListeners, listener);
    }

    private final void handleSubmit(String method, String action, String data) {
        this.actionListeners.actionPerformed(new FormActionEvent(method, action, data));
    }

    private final class HyperlinkHandler
    implements HyperlinkListener {
        private HyperlinkHandler() {
        }

        public void hyperlinkUpdate(HyperlinkEvent event) {
            try {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HTMLPane source = (HTMLPane)event.getSource();
                    String description = event.getDescription();
                    Element e = event.getSourceElement();
                    AttributeSet tagAttributes = (AttributeSet)e.getAttributes().getAttribute(HTML.Tag.A);
                    String target = null;
                    if (tagAttributes != null) {
                        target = (String)tagAttributes.getAttribute(HTML.Attribute.TARGET);
                    }
                    if (target != null && target.equals("_blank")) {
                        return;
                    }
                    JEditorPane pane = (JEditorPane)event.getSource();
                    if (event instanceof HTMLFrameHyperlinkEvent) {
                        ((HTMLDocument)source.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)event);
                    } else {
                        HTMLPane.this.setPage(event.getURL());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class FormActionEvent
    extends ActionEvent {
        private final String method;
        private final String action;
        private final Properties data;

        private FormActionEvent(String method, String action, String data) {
            super(HTMLPane.this, 0, "submit");
            this.data = new Properties();
            this.method = method;
            this.action = action;
            try {
                this.data.load(new ByteArrayInputStream(data.getBytes()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String method() {
            return this.method;
        }

        public String action() {
            return this.action;
        }

        public Properties data() {
            return this.data;
        }

        public HTMLPane source() {
            return (HTMLPane)this.getSource();
        }
    }

    public final class LocalFormView
    extends FormView {
        public LocalFormView(Element element) {
            super(element);
        }

        private Element findFormTag() {
            for (Element e = this.getElement(); e != null; e = e.getParentElement()) {
                if (e.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.FORM) continue;
                return e;
            }
            throw new Error("HTMLPane.LocalFormView Can't find <form>");
        }

        protected void submitData(String data) {
            AttributeSet attributes = this.findFormTag().getAttributes();
            String action = (String)attributes.getAttribute(HTML.Attribute.ACTION);
            String method = (String)attributes.getAttribute(HTML.Attribute.METHOD);
            if (action == null) {
                action = "";
            }
            if (method == null) {
                method = "";
            }
            HTMLPane.this.handleSubmit(method.toLowerCase(), action, data);
        }

        protected void imageSubmit(String data) {
            this.submitData(data);
        }
    }

    private final class CustomViewFactory
    extends HTMLEditorKit.HTMLFactory {
        private CustomViewFactory() {
        }

        public View create(Element element) {
            HTML.Tag kind = (HTML.Tag)element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (kind == HTML.Tag.INPUT || kind == HTML.Tag.SELECT || kind == HTML.Tag.TEXTAREA) {
                FormView view = HTMLPane.this.actionListeners != null ? new LocalFormView(element) : (FormView)super.create(element);
                String type = (String)element.getAttributes().getAttribute(HTML.Attribute.TYPE);
                return view;
            }
            return super.create(element);
        }
    }

    public class HTMLPaneEditorKit
    extends HTMLEditorKit {
        public ViewFactory getViewFactory() {
            return new CustomViewFactory();
        }
    }
}

