/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.oai.dataprovider20;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import nl.b3p.commons.oai.dataprovider20.DCRecord;
import nl.b3p.commons.oai.dataprovider20.DataProviderInterface;
import nl.b3p.commons.oai.dataprovider20.Identity;
import nl.b3p.commons.oai.dataprovider20.RecordFactory;
import nl.b3p.commons.oai.dataprovider20.error.BadArgument;
import nl.b3p.commons.oai.dataprovider20.error.BadResumptionToken;
import nl.b3p.commons.oai.dataprovider20.error.CannotDisseminateFormat;
import nl.b3p.commons.oai.dataprovider20.error.IdDoesNotExist;
import nl.b3p.commons.oai.dataprovider20.error.NoRecordsMatch;
import nl.b3p.commons.oai.dataprovider20.error.OAIError;
import nl.b3p.commons.oai.dataprovider20.token.IdentifierToken;
import nl.b3p.commons.oai.dataprovider20.token.RecordsToken;
import nl.b3p.commons.oai.dataprovider20.token.SetToken;
import nl.b3p.commons.oai.dataprovider20.token.Token;
import nl.b3p.commons.oai.dataprovider20.token.TokenModem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataProvider
implements DataProviderInterface {
    Identity config;
    RecordFactory rf = null;
    int cursor = 0;
    Document doc = null;

    public DataProvider(Identity config, RecordFactory rf, Document doc) {
        this.config = config;
        this.rf = rf;
        this.doc = doc;
    }

    public DataProvider(Identity config, RecordFactory rf) {
        this.config = config;
        this.rf = rf;
    }

    public void setDocument(Document doc) {
        this.doc = doc;
    }

    public Element identify() {
        Element root = this.doc.createElement("Identify");
        this.doc.appendChild(root);
        Element curr = this.doc.createElement("repositoryName");
        curr.appendChild(this.doc.createTextNode(this.config.getName()));
        root.appendChild(curr);
        curr = this.doc.createElement("baseURL");
        curr.appendChild(this.doc.createTextNode(this.config.getBaseURL()));
        root.appendChild(curr);
        curr = this.doc.createElement("protocolVersion");
        curr.appendChild(this.doc.createTextNode(this.config.getOAIversion()));
        root.appendChild(curr);
        curr = this.doc.createElement("adminEmail");
        curr.appendChild(this.doc.createTextNode(this.config.getAdminemail()));
        root.appendChild(curr);
        curr = this.doc.createElement("earliestDatestamp");
        curr.appendChild(this.doc.createTextNode(this.config.getEarliestDatestamp()));
        root.appendChild(curr);
        curr = this.doc.createElement("deletedRecord");
        curr.appendChild(this.doc.createTextNode(this.config.getDeletedItem()));
        root.appendChild(curr);
        curr = this.doc.createElement("granularity");
        curr.appendChild(this.doc.createTextNode(this.config.getGranularity()));
        root.appendChild(curr);
        curr = this.doc.createElement("description");
        root.appendChild(curr);
        Element oaiIdentifier = this.doc.createElement("oai-identifier");
        curr.appendChild(oaiIdentifier);
        oaiIdentifier.setAttribute("xmlns", "http://www.openarchives.org/OAI/2.0/oai-identifier");
        oaiIdentifier.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        oaiIdentifier.setAttribute("xsi:schemaLocation", "http://www.openarchives.org/OAI/2.0/oai-identifier  http://www.openarchives.org/OAI/2.0/oai-identifier.xsd");
        curr = this.doc.createElement("scheme");
        curr.appendChild(this.doc.createTextNode(this.config.getSchema()));
        oaiIdentifier.appendChild(curr);
        curr = this.doc.createElement("repositoryIdentifier");
        curr.appendChild(this.doc.createTextNode(this.config.getID()));
        oaiIdentifier.appendChild(curr);
        curr = this.doc.createElement("delimiter");
        curr.appendChild(this.doc.createTextNode(this.config.getDelimiter()));
        oaiIdentifier.appendChild(curr);
        curr = this.doc.createElement("sampleIdentifier");
        curr.appendChild(this.doc.createTextNode(this.config.getSampleIdentifier()));
        oaiIdentifier.appendChild(curr);
        return root;
    }

    public Element listSets() throws OAIError {
        Element curr;
        Vector v;
        Element root = this.doc.createElement("ListSets");
        try {
            v = this.rf.getSets(this.cursor, Token.TOKENSIZE);
        }
        catch (Exception ex) {
            throw new NoRecordsMatch(ex.toString());
        }
        this.doc.appendChild(root);
        Enumeration enu = v.elements();
        while (enu.hasMoreElements()) {
            curr = this.doc.createElement("set");
            root.appendChild(curr);
            Element parent = curr;
            String name = (String)enu.nextElement();
            curr = this.doc.createElement("setSpec");
            curr.appendChild(this.doc.createTextNode(name));
            parent.appendChild(curr);
            curr = this.doc.createElement("setName");
            curr.appendChild(this.doc.createTextNode(name));
            parent.appendChild(curr);
        }
        if (v.size() == Token.TOKENSIZE) {
            SetToken token = new SetToken();
            token.setCursor(this.cursor + Token.TOKENSIZE);
            curr = this.doc.createElement("resumptionToken");
            curr.appendChild(this.doc.createTextNode(TokenModem.encode(token)));
            root.appendChild(curr);
        }
        this.cursor = 0;
        return root;
    }

    public Element listSets(String resumptionToken) throws OAIError {
        Token token = TokenModem.decode(resumptionToken);
        if (token.getType() == 1) {
            this.cursor = token.getCursor();
            return this.listSets();
        }
        throw new BadResumptionToken("malformat");
    }

    public Element listMetadataFormats(String id) throws OAIError {
        DCRecord record = null;
        if (id != null) {
            try {
                record = this.rf.getRecord(id);
            }
            catch (Exception ex) {
                throw new NoRecordsMatch(ex.toString());
            }
            if (record == null) {
                throw new IdDoesNotExist("id not exist");
            }
        }
        Element root = this.doc.createElement("ListMetadataFormats");
        this.doc.appendChild(root);
        if (record == null && id != null) {
            throw new IdDoesNotExist("id not exist");
        }
        Element curr = this.doc.createElement("metadataFormat");
        root.appendChild(curr);
        Element parent = curr;
        curr = this.doc.createElement("metadataPrefix");
        curr.appendChild(this.doc.createTextNode("oai_dc"));
        parent.appendChild(curr);
        curr = this.doc.createElement("schema");
        curr.appendChild(this.doc.createTextNode("http://www.openarchives.org/OAI/2.0/oai_dc.xsd"));
        parent.appendChild(curr);
        curr = this.doc.createElement("metadataNamespace");
        curr.appendChild(this.doc.createTextNode("http://www.openarchives.org/OAI/2.0/oai_dc"));
        parent.appendChild(curr);
        return root;
    }

    public Element listIdentifiers(String fileafter, String filebefore, String setspec, String metaformat) throws OAIError {
        Element curr;
        Vector v;
        fileafter = fileafter != null && !fileafter.trim().equals("") ? this.checkValidaty(fileafter) : null;
        filebefore = filebefore != null && !filebefore.trim().equals("") ? this.checkValidaty(filebefore) : null;
        if (metaformat == null) {
            throw new BadArgument("metadataPrefix error");
        }
        if (setspec == null || setspec.trim().equals("")) {
            setspec = null;
        }
        if (metaformat != null && !metaformat.trim().equals("") && !metaformat.equals("oai_dc")) {
            throw new CannotDisseminateFormat("can not disseminate " + metaformat);
        }
        try {
            v = this.rf.getRecords(fileafter, filebefore, setspec, this.cursor, Token.TOKENSIZE);
        }
        catch (Exception ex) {
            throw new NoRecordsMatch(ex.toString());
        }
        if (v == null || v.isEmpty()) {
            throw new NoRecordsMatch("not items match");
        }
        Element root = this.doc.createElement("ListIdentifiers");
        this.doc.appendChild(root);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            DCRecord record = (DCRecord)e.nextElement();
            Element header = curr = this.doc.createElement("header");
            root.appendChild(header);
            if (record.getFullid() != null) {
                curr = this.doc.createElement("identifier");
                curr.appendChild(this.doc.createTextNode(record.getFullid()));
                header.appendChild(curr);
            }
            if (record.getDatestamp() != null) {
                curr = this.doc.createElement("datestamp");
                curr.appendChild(this.doc.createTextNode(record.getDatestamp()));
                header.appendChild(curr);
            }
            if (record.getSets() == null) continue;
            curr = this.doc.createElement("setSpec");
            curr.appendChild(this.doc.createTextNode(record.getSets()));
            header.appendChild(curr);
        }
        if (Token.TOKENSIZE == v.size()) {
            IdentifierToken token = new IdentifierToken();
            token.setCursor(this.cursor + Token.TOKENSIZE);
            token.from = fileafter;
            token.until = filebefore;
            token.metadataPrefix = metaformat;
            token.set = setspec;
            curr = this.doc.createElement("resumptionToken");
            curr.appendChild(this.doc.createTextNode(TokenModem.encode(token)));
            root.appendChild(curr);
        }
        this.cursor = 0;
        return root;
    }

    public Element listIdentifiers(String resumptionToken) throws OAIError {
        IdentifierToken token = (IdentifierToken)TokenModem.decode(resumptionToken);
        if (token.getType() == 2) {
            this.cursor = token.getCursor();
            return this.listIdentifiers(token.from, token.until, token.set, token.metadataPrefix);
        }
        throw new BadResumptionToken("malformat");
    }

    public Element listRecords(String fileafter, String filebefore, String setspec, String metaformat) throws OAIError {
        Vector v;
        fileafter = fileafter != null && !fileafter.trim().equals("") ? this.checkValidaty(fileafter) : null;
        filebefore = filebefore != null && !filebefore.trim().equals("") ? this.checkValidaty(filebefore) : null;
        if (metaformat == null) {
            throw new BadArgument("metadataPrefix error");
        }
        if (!metaformat.equals("oai_dc")) {
            throw new CannotDisseminateFormat("can not disseminate " + metaformat);
        }
        try {
            v = this.rf.getRecords(fileafter, filebefore, setspec, this.cursor, Token.TOKENSIZE);
        }
        catch (Exception ex) {
            throw new NoRecordsMatch(ex.toString());
        }
        if (v == null || v.isEmpty()) {
            throw new NoRecordsMatch("no items match");
        }
        Element root = this.doc.createElement("ListRecords");
        this.doc.appendChild(root);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            this.createRecordElement(this.doc, root, (DCRecord)e.nextElement(), metaformat);
        }
        if (Token.TOKENSIZE == v.size()) {
            RecordsToken token = new RecordsToken();
            token.setCursor(this.cursor + Token.TOKENSIZE);
            token.from = fileafter;
            token.until = filebefore;
            token.set = setspec;
            token.metadataPrefix = metaformat;
            Element curr = this.doc.createElement("resumptionToken");
            curr.appendChild(this.doc.createTextNode(TokenModem.encode(token)));
            root.appendChild(curr);
        }
        this.cursor = 0;
        return root;
    }

    public Element listRecords(String resumptionToken) throws OAIError {
        RecordsToken token = (RecordsToken)TokenModem.decode(resumptionToken);
        if (token.getType() == 3) {
            this.cursor = token.getCursor();
            return this.listRecords(token.from, token.until, token.set, token.metadataPrefix);
        }
        throw new BadResumptionToken("malformat");
    }

    public Element getRecord(String handle, String metaformat) throws OAIError {
        DCRecord record;
        if (metaformat == null || handle == null) {
            throw new BadArgument("Missing Mandatory Field");
        }
        if (!metaformat.equals("oai_dc")) {
            throw new CannotDisseminateFormat("can not disseminate " + metaformat);
        }
        try {
            record = this.rf.getRecord(handle);
        }
        catch (Exception ex) {
            throw new IdDoesNotExist(ex.toString());
        }
        if (record == null) {
            throw new IdDoesNotExist("id not exist");
        }
        Element root = this.doc.createElement("GetRecord");
        this.doc.appendChild(root);
        this.createRecordElement(this.doc, root, record, metaformat);
        return root;
    }

    private void createRecordElement(Document doc, Element root, DCRecord record, String metaformat) {
        Enumeration e;
        Element curr = doc.createElement("record");
        root.appendChild(curr);
        Element recordElmt = curr;
        Element header = curr = doc.createElement("header");
        recordElmt.appendChild(header);
        if (record.getFullid() != null) {
            curr = doc.createElement("identifier");
            curr.appendChild(doc.createTextNode(record.getFullid()));
            header.appendChild(curr);
        }
        if (record.getDatestamp() != null) {
            curr = doc.createElement("datestamp");
            curr.appendChild(doc.createTextNode(record.getDatestamp()));
            header.appendChild(curr);
        }
        if (record.getSets() != null) {
            curr = doc.createElement("setSpec");
            curr.appendChild(doc.createTextNode(record.getSets()));
            header.appendChild(curr);
        }
        if (!metaformat.equals("oai_dc")) {
            return;
        }
        Element metadata = doc.createElement("metadata");
        recordElmt.appendChild(metadata);
        curr = doc.createElement("oai_dc:dc");
        this.addDCNameSpace(curr);
        Element dc = curr;
        metadata.appendChild(dc);
        if (record.getTitle() != null) {
            curr = doc.createElement("dc:title");
            curr.appendChild(doc.createTextNode(record.getTitle()));
            dc.appendChild(curr);
        }
        if (record.getFormat() != null) {
            curr = doc.createElement("dc:format");
            curr.appendChild(doc.createTextNode(record.getFormat()));
            dc.appendChild(curr);
        }
        if (record.getCreator() != null) {
            e = record.getCreator().elements();
            while (e.hasMoreElements()) {
                curr = doc.createElement("dc:creator");
                curr.appendChild(doc.createTextNode((String)e.nextElement()));
                dc.appendChild(curr);
            }
        }
        if (record.getSubject() != null) {
            e = record.getSubject().elements();
            while (e.hasMoreElements()) {
                curr = doc.createElement("dc:subject");
                curr.appendChild(doc.createTextNode((String)e.nextElement()));
                dc.appendChild(curr);
            }
        }
        if (record.getDescription() != null) {
            curr = doc.createElement("dc:description");
            curr.appendChild(doc.createTextNode(record.getDescription()));
            dc.appendChild(curr);
        }
        if (record.getRights() != null) {
            curr = doc.createElement("dc:rights");
            curr.appendChild(doc.createTextNode(record.getRights()));
            dc.appendChild(curr);
        }
        if (record.getPublisher() != null) {
            curr = doc.createElement("dc:publisher");
            curr.appendChild(doc.createTextNode(record.getPublisher()));
            dc.appendChild(curr);
        }
        if (record.getContributor() != null) {
            curr = doc.createElement("dc:contributor");
            curr.appendChild(doc.createTextNode(record.getContributor()));
            dc.appendChild(curr);
        }
        if (record.getDate() != null) {
            curr = doc.createElement("dc:date");
            curr.appendChild(doc.createTextNode(record.getDate()));
            dc.appendChild(curr);
        }
        if (record.getType() != null) {
            curr = doc.createElement("dc:type");
            curr.appendChild(doc.createTextNode(record.getType()));
            dc.appendChild(curr);
        }
        if (record.getIdentifier() != null) {
            e = record.getIdentifier().elements();
            while (e.hasMoreElements()) {
                curr = doc.createElement("dc:identifier");
                curr.appendChild(doc.createTextNode((String)e.nextElement()));
                dc.appendChild(curr);
            }
        }
        if (record.getSource() != null) {
            curr = doc.createElement("dc:source");
            curr.appendChild(doc.createTextNode(record.getSource()));
            dc.appendChild(curr);
        }
        if (record.getLanguage() != null) {
            curr = doc.createElement("dc:language");
            curr.appendChild(doc.createTextNode(record.getLanguage()));
            dc.appendChild(curr);
        }
        if (record.getRelation() != null) {
            curr = doc.createElement("dc:relation");
            curr.appendChild(doc.createTextNode(record.getRelation()));
            dc.appendChild(curr);
        }
    }

    private String checkValidaty(String day) throws OAIError {
        Date date;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        formatter.setLenient(true);
        try {
            date = formatter.parse(day);
        }
        catch (Exception e) {
            throw new BadArgument("date format error");
        }
        if (day.length() > 10) {
            throw new BadArgument("bad Granularity for " + day);
        }
        return formatter.format(date);
    }

    private void addDCNameSpace(Element e) {
        e.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        e.setAttribute("xmlns:oai_dc", "http://www.openarchives.org/OAI/2.0/oai_dc/");
        e.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        e.setAttribute("xsi:schemaLocation", "http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd");
    }
}

